/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class ProjectClassLocator
extends BaseClassLocator {
    protected static final boolean EXPORTED_LIBRARIES = true;
    protected static final boolean ALL_LIBRARIES = false;
    private Project _project;
    private BaseClassLocator _jdkLocator;
    private BaseClassLocator _libraryLocator;
    private BaseClassLocator _dependentLibraryLocator;
    private BaseClassLocator _dependentPathLocator;
    private BaseClassLocator _outputLocator;
    private BaseClassLocator _addedClassLocator;
    private BaseClassLocator _sourceLocator;

    protected ProjectClassLocator(Project project) {
        this._project = project;
        Library library = this.getJDKFor(project);
        this._jdkLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getLibraryLocator(library));
        Library[] libraryArray = this.getLibrariesFor(project, false);
        this._libraryLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getLibraryLocator(libraryArray));
        URL uRL = this.getOutputURLFor(project);
        this._outputLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getClassLocator(uRL));
        URLPath uRLPath = this.getAddedClassPathFor(project);
        this._addedClassLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getClassLocator(uRLPath));
        URLPath uRLPath2 = ProjectClassLocator.getSourcePathFor(project);
        this._sourceLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getSourceLocator(uRLPath2));
        ArrayList arrayList = new ArrayList(25);
        URLPath uRLPath3 = new URLPath(50);
        URLPath uRLPath4 = new URLPath(50);
        this.processDependenciesRecurse(project, new ArrayList(), arrayList, uRLPath3, uRLPath4, false);
        List<Library> list = libraryArray == null ? BaseClassLocator.EMPTY_COLLECTION : Arrays.asList(libraryArray);
        arrayList.removeAll(list);
        int n = arrayList.size();
        Library[] libraryArray2 = arrayList.toArray(new Library[n]);
        this._dependentLibraryLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getLibraryLocator(libraryArray2));
        uRLPath3.remove(uRLPath2);
        uRLPath4.remove(uRLPath);
        uRLPath4.remove(uRL);
        this._dependentPathLocator = ProjectClassLocator.ensureValid(ClassLocatorFactory.getPathLocator(uRLPath3, uRLPath4));
    }

    protected void processDependenciesRecurse(Project project, List list, List list2, URLPath uRLPath, URLPath uRLPath2, boolean bl) {
        if (list.contains(project)) {
            return;
        }
        list.add(project);
        Library[] libraryArray = this.getLibrariesFor(project, bl);
        int n = libraryArray == null ? 0 : libraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Library library = libraryArray[n2];
            if (!list2.contains(library)) {
                list2.add(library);
            }
            ++n2;
        }
        URLPath uRLPath3 = ProjectClassLocator.getSourcePathFor(project);
        uRLPath.add(uRLPath3);
        URL uRL = this.getOutputURLFor(project);
        URLPath uRLPath4 = this.getAddedClassPathFor(project);
        uRLPath2.add(uRL);
        uRLPath2.add(uRLPath4);
        Collection collection = ProjectClassLocator.getDependentsFor(project);
        for (Object e : collection) {
            if (e == null) continue;
            if (e instanceof ProjectLibrary) {
                Project project2 = (Project)((ProjectLibrary)e).getSource();
                this.processDependenciesRecurse(project2, list, list2, uRLPath, uRLPath2, true);
                continue;
            }
            if (!(e instanceof Library) || list2.contains(e)) continue;
            list2.add(e);
        }
    }

    public static Collection getDependentsFor(Project project) {
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((Project)project);
        List list = dependencyConfiguration.getDependencyList();
        return list == null ? BaseClassLocator.EMPTY_COLLECTION : list;
    }

    protected URLPath getAddedClassPathFor(Project project) {
        JProjectPaths jProjectPaths = JProjectPaths.getInstance((PropertyStorage)project);
        return jProjectPaths.getAdditionalClassPath();
    }

    protected URL getOutputURLFor(Project project) {
        JavaProject javaProject = JavaProject.getInstance(project);
        return javaProject.getOutputDirectory();
    }

    public static URLPath getSourcePathFor(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        return pathsConfiguration.getProjectSourcePath();
    }

    protected Library getJDKFor(Project project) {
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        return jProjectLibraries.getJDK();
    }

    protected Library[] getLibrariesFor(Project project, boolean bl) {
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        if (bl) {
            return jProjectLibraries.getExports();
        }
        return jProjectLibraries.getLibraries();
    }

    public void buildIndex() {
        this._sourceLocator.buildIndex();
        this._outputLocator.buildIndex();
        this._addedClassLocator.buildIndex();
        this._libraryLocator.buildIndex();
        this._jdkLocator.buildIndex();
        this._dependentLibraryLocator.buildIndex();
        this._dependentPathLocator.buildIndex();
    }

    protected void getPackages(String string, Collection collection) {
        this._sourceLocator.getPackages(string, collection);
        this._outputLocator.getPackages(string, collection);
        this._addedClassLocator.getPackages(string, collection);
        this._dependentPathLocator.getPackages(string, collection);
        this._dependentLibraryLocator.getPackages(string, collection);
        this._libraryLocator.getPackages(string, collection);
        this._jdkLocator.getPackages(string, collection);
    }

    protected void getClassesInPackage(String string, Collection collection) {
        this._sourceLocator.getClassesInPackage(string, collection);
        this._outputLocator.getClassesInPackage(string, collection);
        this._addedClassLocator.getClassesInPackage(string, collection);
        this._dependentPathLocator.getClassesInPackage(string, collection);
        this._dependentLibraryLocator.getClassesInPackage(string, collection);
        this._libraryLocator.getClassesInPackage(string, collection);
        this._jdkLocator.getClassesInPackage(string, collection);
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this._sourceLocator.getAllClasses(collection, classNameFilter);
        this._outputLocator.getAllClasses(collection, classNameFilter);
        this._addedClassLocator.getAllClasses(collection, classNameFilter);
        this._dependentPathLocator.getAllClasses(collection, classNameFilter);
        this._dependentLibraryLocator.getAllClasses(collection, classNameFilter);
        this._libraryLocator.getAllClasses(collection, classNameFilter);
        this._jdkLocator.getAllClasses(collection, classNameFilter);
    }

    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this._sourceLocator.getAllPackages(collection, packageNameFilter);
        this._outputLocator.getAllPackages(collection, packageNameFilter);
        this._addedClassLocator.getAllPackages(collection, packageNameFilter);
        this._dependentPathLocator.getAllPackages(collection, packageNameFilter);
        this._dependentLibraryLocator.getAllPackages(collection, packageNameFilter);
        this._libraryLocator.getAllPackages(collection, packageNameFilter);
        this._jdkLocator.getAllPackages(collection, packageNameFilter);
    }

    public URL getURL(String string) {
        URL uRL = this._outputLocator.getClassURL(string);
        URL uRL2 = this._sourceLocator.getSourceURL(string);
        if (uRL != null || uRL2 != null) {
            long l;
            if (uRL == null) {
                return uRL2;
            }
            if (uRL2 == null) {
                return uRL;
            }
            long l2 = URLFileSystem.lastModified((URL)uRL);
            Node node = NodeFactory.find((URL)uRL2);
            long l3 = l = node != null && node.isOpen() ? node.getTimestamp() : URLFileSystem.lastModified((URL)uRL2);
            if (l2 >= l) {
                return uRL;
            }
            return uRL2;
        }
        uRL = this._addedClassLocator.getClassURL(string);
        if (uRL == null) {
            uRL = this._dependentPathLocator.getURL(string);
        }
        if (uRL == null) {
            uRL = this._dependentLibraryLocator.getURL(string);
        }
        if (uRL == null) {
            uRL = this._libraryLocator.getURL(string);
        }
        if (uRL == null) {
            uRL = this._jdkLocator.getURL(string);
        }
        return uRL;
    }

    public URL getProjectSourceURL(String string, boolean bl) {
        URL uRL = this._sourceLocator.getSourceURL(string);
        if (uRL == null && bl) {
            uRL = this._dependentPathLocator.getSourceURL(string);
        }
        return uRL;
    }

    public URL getNonProjectSourceURL(String string) {
        URL uRL = this._dependentLibraryLocator.getSourceURL(string);
        if (uRL == null) {
            uRL = this._libraryLocator.getSourceURL(string);
        }
        if (uRL == null) {
            uRL = this._jdkLocator.getSourceURL(string);
        }
        return uRL;
    }

    public URL getSourceURL(String string) {
        URL uRL = this.getProjectSourceURL(string, true);
        if (uRL == null) {
            uRL = this.getNonProjectSourceURL(string);
        }
        return uRL;
    }

    public URL getClassURL(String string) {
        URL uRL = this._outputLocator.getClassURL(string);
        if (uRL == null) {
            uRL = this._addedClassLocator.getClassURL(string);
        }
        if (uRL == null) {
            uRL = this._dependentPathLocator.getClassURL(string);
        }
        if (uRL == null) {
            uRL = this._dependentLibraryLocator.getClassURL(string);
        }
        if (uRL == null) {
            uRL = this._libraryLocator.getClassURL(string);
        }
        if (uRL == null) {
            uRL = this._jdkLocator.getClassURL(string);
        }
        return uRL;
    }

    public URL getResourceURL(String string) {
        URL uRL = this._outputLocator.getResourceURL(string);
        if (uRL == null) {
            uRL = this._addedClassLocator.getResourceURL(string);
        }
        if (uRL == null) {
            uRL = this._dependentPathLocator.getResourceURL(string);
        }
        if (uRL == null) {
            uRL = this._dependentLibraryLocator.getResourceURL(string);
        }
        if (uRL == null) {
            uRL = this._libraryLocator.getResourceURL(string);
        }
        if (uRL == null) {
            uRL = this._jdkLocator.getResourceURL(string);
        }
        return uRL;
    }
}

