/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public abstract class URLClassLocator
extends BaseClassLocator {
    protected URL _rootURL;
    protected int _fileType;
    public static final int CLASS_TYPE = 1;
    public static final int SOURCE_TYPE = 2;
    public static final String[] CLASS_SUFFIXES = new String[]{".class"};
    public static final String[] SOURCE_SUFFIXES = new String[]{".java", ".sqlj"};

    public URLClassLocator(URL uRL, int n) {
        this._rootURL = uRL;
        this._fileType = n;
    }

    protected URL getRootURL() {
        return this._rootURL;
    }

    protected int getFileType() {
        return this._fileType;
    }

    protected boolean isSourceTypeLocator() {
        return this._fileType == 2;
    }

    protected boolean isClassTypeLocator() {
        return this._fileType == 1;
    }

    protected boolean isMatchingFileType(URL uRL) {
        String string = uRL.getFile();
        return URLClassLocator.isMatchingFileType(string, this._fileType);
    }

    protected boolean isMatchingFileType(String string) {
        return URLClassLocator.isMatchingFileType(string, this._fileType);
    }

    private static boolean isMatchingFileType(String string, int n) {
        String[] stringArray;
        switch (n) {
            case 2: {
                stringArray = SOURCE_SUFFIXES;
                break;
            }
            case 1: {
                stringArray = CLASS_SUFFIXES;
                break;
            }
            default: {
                stringArray = null;
            }
        }
        if (stringArray != null) {
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                if (string.endsWith(string2)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public URL getSourceURL(String string) {
        if (this.isSourceTypeLocator()) {
            return this.getURL(string);
        }
        return null;
    }

    public URL getClassURL(String string) {
        if (this.isClassTypeLocator()) {
            return this.getURL(string);
        }
        return null;
    }
}

