/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.classfile.ClClass;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.common.AbstractPackage;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.util.ClassFileCache;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public abstract class BaseFileProvider
implements JavaFileProvider {
    protected static final Collection EMPTY_COLLECTION = BaseClassLocator.EMPTY_COLLECTION;
    private static WeakReference preferencesRef = null;
    protected static final String CLASS_SUFFIX = ".class";
    protected static final String SOURCE_SUFFIX = ".java";
    protected static final Class JAVACLASSNODE_CLASS = JavaClassNode.class;
    protected static final Class JAVASOURCENODE_CLASS = JavaSourceNode.class;
    protected static final int CLASS_TYPE = 1;
    protected static final int SOURCE_TYPE = 2;
    public static final int UNKNOWN_TYPE = -1;

    public abstract JavaClassLocator getClassLocator();

    protected final SourcePreferences getSourcePreferences() {
        SourcePreferences sourcePreferences;
        WeakReference weakReference = preferencesRef;
        if (weakReference != null && (sourcePreferences = (SourcePreferences)weakReference.get()) != null) {
            return sourcePreferences;
        }
        try {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            if (codingStyleManager == null) {
                SourcePreferences sourcePreferences2 = null;
                return sourcePreferences2;
            }
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            SourcePreferences sourcePreferences3 = codingStyleOptions.getSourcePreferences();
            if (sourcePreferences3 == null) {
                SourcePreferences sourcePreferences4 = null;
                return sourcePreferences4;
            }
            SourcePreferences sourcePreferences5 = sourcePreferences3;
            return sourcePreferences5;
        }
        catch (NullPointerException nullPointerException) {
            SourcePreferences sourcePreferences6 = null;
            return sourcePreferences6;
        }
    }

    protected final int getFileType(URL uRL) {
        String string;
        Class clazz = Recognizer.recognizeURL((URL)uRL);
        if (clazz != null) {
            if (JAVASOURCENODE_CLASS.isAssignableFrom(clazz)) {
                return 2;
            }
            if (JAVACLASSNODE_CLASS.isAssignableFrom(clazz)) {
                return 1;
            }
        }
        if ((string = uRL.getFile()).endsWith(SOURCE_SUFFIX)) {
            return 2;
        }
        if (string.endsWith(CLASS_SUFFIX)) {
            return 1;
        }
        return -1;
    }

    public JavaFile getFile(URL uRL) {
        return this.getFileImpl(uRL);
    }

    public JavaFile getFile(URL uRL, boolean bl) {
        return this.getFileImpl(uRL, bl);
    }

    protected JavaFile getFileImpl(URL uRL) {
        return this.getFileImpl(uRL, false);
    }

    protected JavaFile getFileImpl(URL uRL, boolean bl) {
        int n = this.getFileType(uRL);
        switch (n) {
            case 2: {
                return this.getSourceFileImpl(uRL, bl);
            }
            case 1: {
                return this.getClassFileImpl(uRL);
            }
        }
        return null;
    }

    public SourceFile getSourceFile(URL uRL) {
        return this.getSourceFileImpl(uRL);
    }

    public SourceFile getSourceFile(URL uRL, boolean bl) {
        return this.getSourceFileImpl(uRL, bl);
    }

    public SourceFile getSourceFile(TextBuffer textBuffer) {
        return this.createSourceFile(textBuffer);
    }

    protected JavaFile getClassFileImpl(URL uRL) {
        ClassFile classFile = ClassFileCache.getClassFile(uRL);
        if (classFile != null) {
            BaseClass baseClass = new BaseClass(classFile, this);
            ClFile clFile = new ClFile((JavaClass)baseClass, uRL);
            baseClass._javaFile = clFile;
            return clFile;
        }
        return null;
    }

    protected JavaFile getJavaFile(JavaClass javaClass) {
        if (javaClass instanceof SourceClass) {
            return ((SourceClass)javaClass).getOwningSourceFile();
        }
        if (javaClass instanceof BaseClass) {
            return ((BaseClass)javaClass)._javaFile;
        }
        return null;
    }

    protected SourceFile getSourceFileImpl(URL uRL, boolean bl) {
        TextBuffer textBuffer = this.getTextBuffer(uRL, bl);
        if (textBuffer == null) {
            return null;
        }
        SourceFile sourceFile = this.createSourceFile(textBuffer);
        if (sourceFile != null) {
            sourceFile.setURL(uRL);
        }
        return sourceFile;
    }

    private SourceFile createSourceFile(TextBuffer textBuffer) {
        textBuffer.readLock();
        try {
            int n = this.getTargetJdkVersion();
            SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer, (int)n);
            if (sourceFile != null) {
                sourceFile.pinTextBuffer(textBuffer);
                sourceFile.setProvider((JavaProvider)this);
                SourcePreferences sourcePreferences = this.getSourcePreferences();
                if (sourcePreferences != null) {
                    SourcePreferences sourcePreferences2 = SourcePreferences.createCascadingPreferences((SourcePreferences)sourcePreferences);
                    sourceFile.setPreferences(sourcePreferences2);
                }
            }
            SourceFile sourceFile2 = sourceFile;
            textBuffer.readUnlock();
            return sourceFile2;
        }
        catch (Throwable throwable) {
            textBuffer.readUnlock();
            throw throwable;
        }
    }

    protected SourceFile getSourceFileImpl(URL uRL) {
        return this.getSourceFileImpl(uRL, false);
    }

    public SourceFile createSourceFile(URL uRL) throws IOException, IllegalArgumentException {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                if (!node.isNew()) {
                    SourceFile sourceFile = null;
                    return sourceFile;
                }
                boolean bl = node instanceof JavaSourceNode;
                boolean bl2 = node instanceof TextNode;
                if (!bl && bl2) {
                    String string = URLFileSystem.getSuffix((URL)uRL);
                    bl = string.equals(SOURCE_SUFFIX);
                }
                if (bl) {
                    OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
                    outputStream.close();
                    SourceFile sourceFile = this.getSourceFile(uRL);
                    return sourceFile;
                }
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unrecognized url: " + uRL);
    }

    public JavaClass getClass(String string) {
        int n;
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(60)) != -1) {
            TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
            SourceFile sourceFile = this.getSourceFile(textBuffer);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceTypeReference sourceTypeReference = sourceFactory.createTypeFromText(string);
            CallerContext callerContext = CallerContext.createContext((SourceElement)sourceFile, (boolean)true);
            sourceTypeReference.setContext(callerContext);
            JavaType javaType = sourceTypeReference.getResolvedType();
            if (javaType instanceof JavaClass) {
                return (JavaClass)javaType;
            }
            return null;
        }
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            int n3 = (string.length() - n2) / 2;
            String string2 = string.substring(0, n2).trim();
            JavaClass javaClass = this.getClass(string2);
            if (javaClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)javaClass, n3);
        }
        JavaClass javaClass = this.getPrimitiveClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        return this.getClassLeftToRight(string);
    }

    protected JavaClass getClassLeftToRight(String string) {
        String string2 = "";
        String string3 = string;
        while (string3.length() > 0) {
            JavaClass javaClass;
            int n = string3.indexOf(46);
            String string4 = n != -1 ? string3.substring(0, n) : string3;
            String string5 = BaseClassLocator.buildFQName(string2, string4);
            JavaClass javaClass2 = this.getClassExactImpl(string5);
            if (javaClass2 != null && (javaClass = this.locateClass(javaClass2, string)) != null) {
                return javaClass;
            }
            int n2 = string2.length();
            int n3 = string4.length();
            string2 = n2 > 0 ? string.substring(0, n2 + n3 + 1) : string4;
            String string6 = string3 = n != -1 ? string3.substring(n + 1) : "";
        }
        return null;
    }

    protected JavaClass getClassExactImpl(String string) {
        JavaFile javaFile;
        if (string.length() == 0) {
            return null;
        }
        JavaClassLocator javaClassLocator = this.getClassLocator();
        URL uRL = javaClassLocator.getURL(string);
        if (uRL != null && (javaFile = this.getFileImpl(uRL)) != null) {
            return this.locateClass(javaFile, string);
        }
        return null;
    }

    public JavaClass getClass(String string, String string2) {
        return this.getClass(BaseClassLocator.buildFQName(string, string2));
    }

    public JavaClass getClassByVMName(String string) {
        int n = string.indexOf(91);
        if (n != -1) {
            int n2 = (string.length() - n) / 2;
            String string2 = string.substring(0, n).trim();
            JavaClass javaClass = this.getClassByVMName(string2);
            if (javaClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)javaClass, n2);
        }
        JavaClass javaClass = this.getPrimitiveClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        int n3 = string.lastIndexOf(47);
        String string3 = n3 == -1 ? "" : string.substring(0, n3);
        string3 = string3.replace('/', '.');
        String string4 = n3 == -1 ? string : string.substring(n3 + 1);
        String string5 = "";
        int n4 = 0;
        while (string5.length() < string4.length()) {
            JavaClass javaClass2;
            int n5 = string4.indexOf(36, n4);
            if (n5 == -1) {
                string5 = string4;
            } else {
                string5 = string4.substring(0, n5);
                n4 = n5 + 1;
            }
            String string6 = BaseClassLocator.buildFQName(string3, string5);
            JavaClass javaClass3 = this.getClassExactImpl(string6);
            if (javaClass3 == null || (javaClass2 = this.locateClassByVMName(javaClass3, string)) == null) continue;
            return javaClass2;
        }
        return null;
    }

    protected JavaClass getInnerClassByVMName(String string) {
        JavaFile javaFile;
        JavaClass javaClass;
        String string2 = string.replace('/', '.');
        JavaClassLocator javaClassLocator = this.getClassLocator();
        URL uRL = javaClassLocator.getClassURL(string2);
        if (uRL != null && string.equals((javaClass = (javaFile = this.getFileImpl(uRL)).getPrimaryClass()).getVMName())) {
            return javaClass;
        }
        return null;
    }

    protected JavaClass locateClass(JavaFile javaFile, String string) {
        return this.locateClass(javaFile.getPrimaryClass(), string);
    }

    protected JavaClass locateClass(JavaClass javaClass, String string) {
        if (javaClass == null) {
            return null;
        }
        String string2 = javaClass.getQualifiedName();
        if (!string.startsWith(string2)) {
            return null;
        }
        if (string.length() == string2.length()) {
            return javaClass;
        }
        if (string.charAt(string2.length()) != '.') {
            return null;
        }
        Collection collection = javaClass.getDeclaredClasses();
        for (JavaClass javaClass2 : collection) {
            JavaClass javaClass3;
            if (javaClass2 == null || (javaClass3 = this.locateClass(javaClass2, string)) == null) continue;
            return javaClass3;
        }
        return null;
    }

    protected JavaClass locateClassByVMName(JavaClass javaClass, String string) {
        String string2 = javaClass.getVMName();
        if (!string.startsWith(string2)) {
            return null;
        }
        if (string.length() == string2.length()) {
            return javaClass;
        }
        if (string.charAt(string2.length()) != '$') {
            return null;
        }
        Collection collection = javaClass.getDeclaredClasses();
        for (JavaClass javaClass2 : collection) {
            JavaClass javaClass3;
            if (javaClass2 == null || (javaClass3 = this.locateClassByVMName(javaClass2, string)) == null) continue;
            return javaClass3;
        }
        return null;
    }

    public SourceClass getSourceClass(String string) {
        JavaClass javaClass;
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((javaClass = this.getClass(string)) != null) {
            return (SourceClass)javaClass.getSourceElement();
        }
        return null;
    }

    protected SourceClass getSourceClassByHint(JavaClass javaClass, String string) {
        SourceFile sourceFile;
        String string2;
        String string3 = javaClass.getPackageName();
        if (string != null) {
            int n = string.lastIndexOf(46);
            string2 = n != -1 ? string.substring(0, n) : string;
        } else {
            String string4 = javaClass.getQualifiedName();
            int n = string3 != null ? string3.length() : 0;
            String string5 = n > 0 ? string4.substring(n + 1) : string4;
            int n2 = string5.indexOf(46);
            string2 = n2 == -1 ? string5 : string5.substring(0, n2);
        }
        String string6 = BaseClassLocator.buildFQName(string3, string2);
        JavaClassLocator javaClassLocator = this.getClassLocator();
        URL uRL = javaClassLocator.getSourceURL(string6);
        if (uRL != null && (sourceFile = this.getSourceFile(uRL)) != null) {
            String string7 = javaClass.getQualifiedName();
            return this.locateSourceClass(sourceFile, string7);
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceFile sourceFile, String string) {
        Collection collection = sourceFile.getClasses();
        for (SourceClass sourceClass : collection) {
            SourceClass sourceClass2;
            if (sourceClass == null || (sourceClass2 = this.locateSourceClass(sourceClass, string)) == null) continue;
            return sourceClass2;
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceClass sourceClass, String string) {
        JavaClass javaClass = this.locateClass((JavaClass)sourceClass, string);
        if (javaClass == null) {
            return null;
        }
        if (javaClass instanceof SourceClass) {
            return (SourceClass)javaClass;
        }
        throw new IllegalStateException("Not a SourceClass");
    }

    protected JavaClass getPrimitiveClass(String string) {
        PrimitiveType primitiveType = CommonUtilities.getPrimitiveType((String)string);
        return primitiveType;
    }

    public JavaType getArrayType(JavaType javaType, int n) {
        if (n == 0) {
            return javaType;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        String string = javaType.getUniqueIdentifier();
        int n2 = n;
        while (n2 > 0) {
            string = string + "[]";
            --n2;
        }
        return this.getArrayTypeImpl(string, javaType, n);
    }

    protected JavaType getArrayTypeImpl(String string, JavaType javaType, int n) {
        return CommonUtilities.createArrayType((JavaProvider)this, (JavaType)javaType, (int)n);
    }

    public JavaPackage getPackage(String string) {
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        return this.getPackageImpl(string);
    }

    protected BasePackage getPackageImpl(String string) {
        return string != null ? new BasePackage(string) : null;
    }

    protected JavaPackage getPackage(String string, String string2) {
        String string3 = BaseClassLocator.buildFQName(string, string2);
        return this.getPackage(string3);
    }

    protected TextBuffer getTextBuffer(URL uRL, boolean bl) {
        Class clazz = Recognizer.recognizeURL((URL)uRL);
        if (clazz != null) {
            boolean bl2;
            boolean bl3 = JavaSourceNode.class.isAssignableFrom(clazz);
            boolean bl4 = !bl3 && JavaClassNode.class.isAssignableFrom(clazz);
            boolean bl5 = bl2 = !bl3 && !bl4 && TextNode.class.isAssignableFrom(clazz);
            if (bl2) {
                String string = URLFileSystem.getSuffix((URL)uRL);
                bl3 = string.equals(SOURCE_SUFFIX);
            }
            if (bl3 || bl4) {
                try {
                    boolean bl6 = URLFileSystem.exists((URL)uRL);
                    Node node = NodeFactory.find((URL)uRL);
                    if (node != null && !bl6) {
                        if (!bl && !node.isDirty()) {
                            TextBuffer textBuffer = null;
                            return textBuffer;
                        }
                    } else if (node == null && bl6) {
                        node = NodeFactory.findOrCreate((URL)uRL);
                    }
                    if (node != null) {
                        if (node instanceof TextNode) {
                            TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
                            return textBuffer;
                        }
                        TextBuffer textBuffer = null;
                        return textBuffer;
                    }
                }
                catch (InstantiationException instantiationException) {
                    TextBuffer textBuffer = null;
                    return textBuffer;
                }
                catch (IllegalAccessException illegalAccessException) {
                    TextBuffer textBuffer = null;
                    return textBuffer;
                }
            }
        }
        return null;
    }

    public TextBuffer getTextBuffer(URL uRL) {
        return this.getTextBuffer(uRL, false);
    }

    protected int getTargetJdkVersion() {
        return 3;
    }

    protected final class BaseClass
    extends ClClass {
        protected JavaFile _javaFile;

        protected BaseClass(ClassFile classFile, BaseFileProvider baseFileProvider2) {
            super(classFile, (JavaProvider)baseFileProvider2);
        }

        protected JavaClass getInnerClassByVMName(String string) {
            return BaseFileProvider.this.getInnerClassByVMName(string);
        }

        protected SourceClass getSourceClass(String string) {
            return BaseFileProvider.this.getSourceClassByHint((JavaClass)this, string);
        }
    }

    protected class BasePackage
    extends AbstractPackage {
        protected String _packageName;
        protected Collection _classes;
        protected Collection _packages;

        protected BasePackage(String string) {
            this._packageName = string;
        }

        public String getQualifiedName() {
            return this._packageName;
        }

        protected synchronized void clear() {
            this._classes = null;
            this._packages = null;
        }

        public synchronized Collection getDeclaredClasses() {
            if (this._classes == null) {
                JavaClassLocator javaClassLocator = BaseFileProvider.this.getClassLocator();
                Collection collection = javaClassLocator.getClassesInPackage(this._packageName);
                this._classes = new ArrayList();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    JavaClass javaClass = BaseFileProvider.this.getClass(this._packageName, string);
                    if (javaClass == null) continue;
                    this._classes.add(javaClass);
                }
                if (this._classes.size() == 0) {
                    this._classes = EMPTY_COLLECTION;
                }
            }
            return this._classes;
        }

        public JavaPackage getOwningPackage() {
            if (this._packageName.length() == 0) {
                return null;
            }
            int n = this._packageName.lastIndexOf(46);
            String string = n == -1 ? "" : this._packageName.substring(0, n);
            return BaseFileProvider.this.getPackage(string);
        }

        public JavaPackage getPackage(String string) {
            return BaseFileProvider.this.getPackage(this._packageName, string);
        }

        public synchronized Collection getPackages() {
            if (this._packages == null) {
                JavaClassLocator javaClassLocator = BaseFileProvider.this.getClassLocator();
                Collection collection = javaClassLocator.getPackages(this._packageName);
                this._packages = new ArrayList();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    JavaPackage javaPackage = BaseFileProvider.this.getPackage(this._packageName, string);
                    if (javaPackage == null) continue;
                    this._packages.add(javaPackage);
                }
                if (this._packages.size() == 0) {
                    this._packages = EMPTY_COLLECTION;
                }
            }
            return this._packages;
        }
    }
}

