/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceFileListener;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.provider.BaseFileProvider;
import oracle.jdeveloper.java.util.JRLClassLoader;

public abstract class CachedFileProvider
extends BaseFileProvider
implements CacheSupport {
    protected ClassLoader _classLoader;
    protected final Object _cacheLock;
    protected int _cacheRefCount;
    protected Map _classFileCacheMap;
    protected Map _sourceFileCacheMap;
    protected Map _urlToObserverMap;
    protected Map _classCacheMap;
    protected static final Object CLASS_NOT_FOUND = Boolean.FALSE;
    protected Map _arrayCacheMap;
    protected Map _packageCacheMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        CachedFileProvider cachedFileProvider = this;
        synchronized (cachedFileProvider) {
            if (this._classLoader == null) {
                JavaResourceLocator javaResourceLocator = (JavaResourceLocator)((Object)this.getClassLocator());
                this._classLoader = new JRLClassLoader(javaResourceLocator);
            }
            ClassLoader classLoader = this._classLoader;
            return classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassLoader() {
        CachedFileProvider cachedFileProvider = this;
        synchronized (cachedFileProvider) {
            this._classLoader = null;
        }
    }

    void $init$() {
        this._cacheLock = new Object[]{"CACHE_LOCK", this};
        this._cacheRefCount = 0;
        this._classFileCacheMap = new HashMap(100);
        this._sourceFileCacheMap = new HashMap(100);
        this._urlToObserverMap = new HashMap(1000);
        this._classCacheMap = new HashMap(200);
        this._arrayCacheMap = new HashMap(50);
        this._packageCacheMap = new HashMap(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCacheUse() {
        Object object = this._cacheLock;
        synchronized (object) {
            ++this._cacheRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCacheUse() {
        Object object = this._cacheLock;
        synchronized (object) {
            --this._cacheRefCount;
            if (this._cacheRefCount < 0) {
                this._cacheRefCount = 0;
            }
            if (this._cacheRefCount == 0) {
                this.flushCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this.clearClassFileCache();
            this.clearSourceFileCache();
            this.clearClassCache();
            this.clearArrayCache();
            this.clearPackageCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushFoundCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this.clearClassCache();
            this.clearArrayCache();
            this.clearPackageCache();
        }
    }

    protected void clearAllData() {
        this.stopTrackingAll();
        this.expireAllSourceFiles();
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaFile getClassFileImpl(URL uRL) {
        JavaFile javaFile = null;
        Object object = this._cacheLock;
        synchronized (object) {
            javaFile = (JavaFile)this._classFileCacheMap.get(uRL);
        }
        if (javaFile != null) {
            return javaFile;
        }
        javaFile = super.getClassFileImpl(uRL);
        if (javaFile != null) {
            Object object2 = this._cacheLock;
            synchronized (object2) {
                this._classFileCacheMap.put(uRL, javaFile);
            }
        }
        return javaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassFileCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._classFileCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceFile lookupCachedSourceFile(URL uRL) {
        Object object = this._cacheLock;
        synchronized (object) {
            SoftReference softReference = (SoftReference)this._sourceFileCacheMap.get(uRL);
            if (softReference != null) {
                SourceFile sourceFile = (SourceFile)softReference.get();
                return sourceFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCachedSourceFile(URL uRL) {
        Object object = this._cacheLock;
        synchronized (object) {
            this._sourceFileCacheMap.remove(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeCachedSourceFile(URL uRL, SourceFile sourceFile) {
        if (sourceFile != null) {
            Object object = this._cacheLock;
            synchronized (object) {
                SoftReference<SourceFile> softReference = new SoftReference<SourceFile>(sourceFile);
                this._sourceFileCacheMap.put(uRL, softReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireAllSourceFiles() {
        ArrayList arrayList = new ArrayList();
        Object object = this._cacheLock;
        synchronized (object) {
            arrayList.addAll(this._sourceFileCacheMap.keySet());
        }
        for (URL uRL : arrayList) {
            SourceFile sourceFile = this.lookupCachedSourceFile(uRL);
            if (sourceFile == null) continue;
            sourceFile.expire();
        }
    }

    protected SourceFile getSourceFileImpl(URL uRL, boolean bl) {
        SourceFile sourceFile;
        URL uRL2 = uRL;
        if (!(uRL = URLFileSystem.canonicalize((URL)uRL2)).equals(uRL2)) {
            SourceFile sourceFile2 = this.lookupCachedSourceFile(uRL2);
            if (sourceFile2 != null) {
                sourceFile2.expire();
            }
            this.removeCachedSourceFile(uRL2);
        }
        if ((sourceFile = this.lookupCachedSourceFile(uRL)) != null && !sourceFile.isExpired()) {
            if (sourceFile.getTransaction() != null) {
                return sourceFile;
            }
            TextBuffer textBuffer = this.getTextBuffer(uRL);
            TextBuffer textBuffer2 = sourceFile.getTextBuffer();
            if (textBuffer2 != textBuffer) {
                this.removeCachedSourceFile(uRL);
                sourceFile.expire();
            } else {
                return sourceFile;
            }
        }
        if ((sourceFile = super.getSourceFileImpl(uRL, bl)) != null) {
            this.storeCachedSourceFile(uRL, sourceFile);
            SourceFileTracker sourceFileTracker = new SourceFileTracker(sourceFile, uRL);
            sourceFile.addSourceFileListener((SourceFileListener)sourceFileTracker);
            this.startTrackingURL(uRL);
        }
        return sourceFile;
    }

    protected void clearSourceFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCompiledInfo() {
        Object object = this._cacheLock;
        synchronized (object) {
            for (SoftReference softReference : this._sourceFileCacheMap.values()) {
                SourceFile sourceFile;
                if (softReference == null || (sourceFile = (SourceFile)softReference.get()) == null) continue;
                sourceFile.clearCompiledInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTrackingURL(URL uRL) {
        Map map = this._urlToObserverMap;
        synchronized (map) {
            Node node;
            if (!this._urlToObserverMap.containsKey(uRL) && (node = NodeFactory.find((URL)uRL)) != null) {
                NodeObserver nodeObserver = new NodeObserver(node, uRL);
                this._urlToObserverMap.put(uRL, nodeObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTrackingURL(URL uRL) {
        Map map = this._urlToObserverMap;
        synchronized (map) {
            this._urlToObserverMap.remove(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTrackingAll() {
        Map map = this._urlToObserverMap;
        synchronized (map) {
            for (NodeObserver nodeObserver : this._urlToObserverMap.values()) {
                NodeObserver.mav$detachSelf(nodeObserver);
            }
            this._urlToObserverMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaClass getClassExactImpl(String string) {
        JavaClass javaClass = null;
        Object object = this._cacheLock;
        synchronized (object) {
            Object v = this._classCacheMap.get(string);
            if (v == CLASS_NOT_FOUND) {
                JavaClass javaClass2 = null;
                return javaClass2;
            }
            javaClass = (JavaClass)v;
        }
        if (javaClass != null) {
            return javaClass;
        }
        javaClass = super.getClassExactImpl(string);
        Object object2 = this._cacheLock;
        synchronized (object2) {
            Object object3 = javaClass == null ? CLASS_NOT_FOUND : javaClass;
            this._classCacheMap.put(string, object3);
        }
        return javaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._classCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaType getArrayTypeImpl(String string, JavaType javaType, int n) {
        JavaType javaType2 = null;
        Object object = this._cacheLock;
        synchronized (object) {
            javaType2 = (JavaType)this._arrayCacheMap.get(string);
            if (javaType2 != null) {
                JavaType javaType3 = javaType2;
                return javaType3;
            }
        }
        javaType2 = super.getArrayTypeImpl(string, javaType, n);
        if (javaType2 != null) {
            Object object2 = this._cacheLock;
            synchronized (object2) {
                this._arrayCacheMap.put(string, javaType2);
            }
        }
        return javaType2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearArrayCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._arrayCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseFileProvider.BasePackage getPackageImpl(String string) {
        BaseFileProvider.BasePackage basePackage = null;
        Object object = this._cacheLock;
        synchronized (object) {
            basePackage = (BaseFileProvider.BasePackage)((Object)this._packageCacheMap.get(string));
        }
        if (basePackage != null) {
            return basePackage;
        }
        basePackage = super.getPackageImpl(string);
        if (basePackage != null) {
            Object object2 = this._cacheLock;
            synchronized (object2) {
                this._packageCacheMap.put(string, basePackage);
            }
        }
        return basePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPackageCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._packageCacheMap.clear();
        }
    }

    public CachedFileProvider() {
        this.$init$();
    }

    protected class SourceFileTracker
    implements SourceFileListener {
        private SourceFile _sourceFile;
        private URL _sourceURL;

        protected SourceFileTracker(SourceFile sourceFile, URL uRL) {
            this._sourceFile = sourceFile;
            this._sourceURL = uRL;
        }

        public void expiredUpdate(SourceFile sourceFile) {
            CachedFileProvider.this.removeCachedSourceFile(this._sourceURL);
            CachedFileProvider.this.flushCache();
            CachedFileProvider.this.clearCompiledInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeUpdate(SourceFile sourceFile, SourceTransaction sourceTransaction) {
            for (JavaClass javaClass : sourceFile.getSourceClasses()) {
                String string = javaClass.getQualifiedName();
                String string2 = javaClass.getRawName();
                Object object = CachedFileProvider.this._cacheLock;
                synchronized (object) {
                    CachedFileProvider.this._classCacheMap.remove(string);
                    CachedFileProvider.this._classCacheMap.remove(string2);
                }
            }
        }
    }

    protected class NodeObserver
    extends NodeListener
    implements Observer {
        private URL _sourceURL;
        private Node _node;

        protected NodeObserver(Node node, URL uRL) {
            this._sourceURL = uRL;
            this._node = node;
            this._node.attach((Observer)this);
            this._node.addNodeListener((NodeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void detachSelf() {
            NodeObserver nodeObserver = this;
            synchronized (nodeObserver) {
                if (this._node != null) {
                    this._node.removeNodeListener((NodeListener)this);
                    this._node.detach((Observer)this);
                    this._node = null;
                }
            }
        }

        private void initiateExpire() {
            SourceFile sourceFile = CachedFileProvider.this.lookupCachedSourceFile(this._sourceURL);
            if (sourceFile != null) {
                sourceFile.expire();
            }
        }

        private void initiateDetach() {
            CachedFileProvider.this.stopTrackingURL(this._sourceURL);
            this.detachSelf();
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.initiateDetach();
            this.initiateExpire();
        }

        public void nodeRenamed(NodeEvent nodeEvent, URL uRL, URL uRL2) {
            this.initiateDetach();
            this.initiateExpire();
        }

        public void update(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.OBJECT_RENAMED) {
                this.initiateDetach();
                this.initiateExpire();
            }
        }

        static void mav$detachSelf(NodeObserver nodeObserver) {
            nodeObserver.detachSelf();
        }
    }
}

