/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.library.ProjectLibrary;

public class ProjectFileProvider
extends CachedFileProvider {
    private static Map _providerMap = new HashMap(20);
    private JavaClassLocator _locator;
    private Project _project;
    private int _j2se;
    protected final Object _locatorLock;
    protected final Observer _projectObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectFileProvider getFileProvider(Project project) {
        Map map = _providerMap;
        synchronized (map) {
            ProjectFileProvider projectFileProvider = (ProjectFileProvider)_providerMap.get(project);
            if (projectFileProvider == null) {
                projectFileProvider = new ProjectFileProvider(project);
                _providerMap.put(project, projectFileProvider);
            }
            ProjectFileProvider projectFileProvider2 = projectFileProvider;
            return projectFileProvider2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectFileProvider lookupFileProvider(Project project) {
        Map map = _providerMap;
        synchronized (map) {
            ProjectFileProvider projectFileProvider = (ProjectFileProvider)_providerMap.get(project);
            return projectFileProvider;
        }
    }

    static {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            1 var1_1 = new 1();
            Compiler.getCompiler().addBuildSystemListener((BuildSystemListener)var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uncacheProviderFor(Project project) {
        Map map = _providerMap;
        synchronized (map) {
            _providerMap.remove(project);
        }
    }

    private ProjectFileProvider(Project project) {
        this.$init$();
        this._project = project;
        this._project.attach(this._projectObserver);
    }

    void $init$() {
        this._j2se = 3;
        this._locatorLock = new Object[]{"LOCATOR_LOCK", this};
        this._projectObserver = new 2();
    }

    protected void handleProjectClose() {
        ProjectFileProvider.uncacheProviderFor(this._project);
        this._project.detach(this._projectObserver);
        this.clearAllData();
        this.clearClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectLoad() {
        Object object = this._locatorLock;
        synchronized (object) {
            this.clearAllData();
            this._locator = null;
            this.clearClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectPathsChange() {
        Object object = this._locatorLock;
        synchronized (object) {
            this.flushCache();
            this.clearCompiledInfo();
            this._locator = null;
            this.clearClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectContentsChange() {
        Object object = this._locatorLock;
        synchronized (object) {
            this.flushFoundCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassLocator getClassLocator() {
        Object object = this._locatorLock;
        synchronized (object) {
            if (this._locator == null) {
                this._locator = ClassLocatorFactory.getProjectLocator(this._project);
            }
            JavaClassLocator javaClassLocator = this._locator;
            return javaClassLocator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadClassLocator() {
        Object object = this._locatorLock;
        synchronized (object) {
            if (this._locator != null) {
                this._locator = ClassLocatorFactory.getProjectLocator(this._project);
            }
        }
        this.flushCache();
        this.clearCompiledInfo();
        this.clearClassLoader();
    }

    public SourceClass getProjectSourceClass(String string) {
        JavaClassLocator javaClassLocator = this.getClassLocator();
        if (javaClassLocator instanceof ProjectClassLocator) {
            ProjectClassLocator projectClassLocator = (ProjectClassLocator)javaClassLocator;
            URL uRL = projectClassLocator.getProjectSourceURL(string, true);
            if (uRL != null) {
                return this.getSourceClass(string);
            }
            URL uRL2 = projectClassLocator.getNonProjectSourceURL(string);
            if (uRL2 != null) {
                return null;
            }
            SourceClass sourceClass = this.getSourceClass(string);
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL uRL3 = sourceFile.getURL();
            if (this.isProjectSourceURL(uRL3)) {
                return sourceClass;
            }
        }
        return null;
    }

    protected boolean isProjectSourceURL(URL uRL) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        arrayList.add(this._project);
        ArrayList<Project> arrayList2 = new ArrayList<Project>();
        while (arrayList.size() > 0) {
            Project project = (Project)arrayList.remove(0);
            arrayList2.add(project);
            URLPath uRLPath = ProjectClassLocator.getSourcePathFor(project);
            if (ProjectFileProvider.pathContainsURL(uRLPath, uRL)) {
                return true;
            }
            Collection collection = ProjectClassLocator.getDependentsFor(project);
            for (Object e : collection) {
                Project project2;
                if (e == null || !(e instanceof ProjectLibrary) || arrayList2.contains(project2 = (Project)((ProjectLibrary)e).getSource())) continue;
                arrayList.add(project2);
            }
        }
        return false;
    }

    protected static boolean pathContainsURL(URLPath uRLPath, URL uRL) {
        URL[] uRLArray = uRLPath.getEntries();
        int n = uRLArray != null ? uRLArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (URLFileSystem.isBaseURLFor((URL)uRLArray[n2], (URL)uRL)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void fetchTargetJdkVersion() {
        OjcConfiguration ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)this._project);
        int n = ojcConfiguration.isJDK15() ? 3 : 2;
        this._j2se = n;
    }

    protected int getTargetJdkVersion() {
        return this._j2se;
    }

    static Project ra$_project(ProjectFileProvider projectFileProvider) {
        return projectFileProvider._project;
    }

    static void mav$fetchTargetJdkVersion(ProjectFileProvider projectFileProvider) {
        projectFileProvider.fetchTargetJdkVersion();
    }

    static ProjectFileProvider maS$lookupFileProvider(Project project) {
        return ProjectFileProvider.lookupFileProvider(project);
    }

    public final class 2
    implements Observer {
        public void update(Object object, UpdateMessage updateMessage) {
            if (object == ProjectFileProvider.ra$_project(ProjectFileProvider.this)) {
                int n = updateMessage.getMessageID();
                if (n == UpdateMessage.OBJECT_OPENED || n == UpdateMessage.OBJECT_RELOADED) {
                    ProjectFileProvider.this.handleProjectLoad();
                } else if (n == UpdateMessage.PROPERTY_SET) {
                    if (updateMessage.containsProperty("classPath") || updateMessage.containsProperty("sourcePath")) {
                        ProjectFileProvider.this.handleProjectPathsChange();
                    }
                } else if (n == UpdateMessage.CHILD_ADDED || n == UpdateMessage.CHILD_REMOVED || n == UpdateMessage.CHILD_RENAMED) {
                    ProjectFileProvider.this.handleProjectContentsChange();
                } else if (n == UpdateMessage.OBJECT_CLOSED) {
                    ProjectFileProvider.this.handleProjectClose();
                    return;
                }
                ProjectFileProvider.mav$fetchTargetJdkVersion(ProjectFileProvider.this);
            }
        }
    }

    public static final class 1
    implements BuildSystemListener {
        private Context _lastContext;

        void $init$() {
            this._lastContext = null;
        }

        public void buildWillStart(Context context) throws BuildSystemVetoException {
            this._lastContext = context;
        }

        public void buildFinished(int n, int n2, int n3) throws BuildSystemVetoException {
            if (this._lastContext != null) {
                Project project = this._lastContext.getProject();
                ProjectFileProvider projectFileProvider = ProjectFileProvider.maS$lookupFileProvider(project);
                if (projectFileProvider != null) {
                    projectFileProvider.handleProjectPathsChange();
                }
                this._lastContext = null;
            }
        }

        public 1() {
            this.$init$();
        }
    }
}

