/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.jdeveloper.java.util.TimedLRUCache;
import oracle.jdeveloper.usage.util.FileUtilities;

public final class ClassFileCache {
    private static final int CLASS_FILE_CACHE_SIZE = 100;
    private static final int CLASS_FILE_EXPIRATION_TIME = 3600;
    private static TimedLRUCache _classCache = new TimedLRUCache(100, 3600);

    private ClassFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile getClassFile(URL uRL) {
        long l = URLFileSystem.lastModified((URL)uRL);
        CacheEntry cacheEntry = (CacheEntry)_classCache.get(uRL);
        if (cacheEntry != null) {
            if (l == CacheEntry.ra$timestamp(cacheEntry)) {
                return CacheEntry.ra$classFile(cacheEntry);
            }
            _classCache.remove(uRL);
        }
        TimedLRUCache timedLRUCache = _classCache;
        synchronized (timedLRUCache) {
            ClassFile classFile = ClassFileCache.readClassFile(uRL);
            if (classFile != null) {
                cacheEntry = new CacheEntry(uRL, classFile, l, null);
                _classCache.put(uRL, cacheEntry);
                ClassFile classFile2 = classFile;
                return classFile2;
            }
        }
        return null;
    }

    private static ClassFile readClassFile(URL uRL) {
        try {
            byte[] byArray = FileUtilities.readFile(uRL);
            if (byArray != null && byArray.length > 0) {
                ClassFile classFile;
                ClassFile classFile2 = classFile = new ClassFile(byArray, uRL);
                return classFile2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static class CacheEntry {
        private URL classURL;
        private ClassFile classFile;
        private long timestamp;

        private CacheEntry(URL uRL, ClassFile classFile, long l) {
            this.classURL = uRL;
            this.classFile = classFile;
            this.timestamp = l;
        }

        static long ra$timestamp(CacheEntry cacheEntry) {
            return cacheEntry.timestamp;
        }

        static ClassFile ra$classFile(CacheEntry cacheEntry) {
            return cacheEntry.classFile;
        }

        CacheEntry(URL uRL, ClassFile classFile, long l, 1 var5_4) {
            this(uRL, classFile, l);
        }

        public final class 1 {
        }
    }
}

