/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.io.IOException;
import java.net.URL;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.usage.util.FileUtilities;

public class JRLClassLoader
extends ClassLoader {
    private JavaResourceLocator _locator;

    public JRLClassLoader(ClassLoader classLoader, JavaResourceLocator javaResourceLocator) {
        super(classLoader);
        this._locator = javaResourceLocator;
    }

    public JRLClassLoader(JavaResourceLocator javaResourceLocator) {
        this._locator = javaResourceLocator;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        URL uRL = this._locator.getClassURL(string);
        if (uRL != null) {
            try {
                byte[] byArray = FileUtilities.readFile(uRL);
                if (byArray != null && byArray.length > 0) {
                    Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
                    return clazz;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected URL findResource(String string) {
        return this._locator.getResourceURL(string);
    }
}

