/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Timer;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.util.SourceElementPath;

public class SourceElementHandle
implements ActionListener,
TextBufferListener {
    public static final String PROPERTY_VALID = "VALID";
    private static final int DELAY = 500;
    private JavaFileProvider _javaFileProvider;
    private URL _url;
    private SourceElementPath _sourceElementPath;
    private SourceElement _sourceElement;
    private int _hashCode;
    private PropertyChangeListener _propertyChangeListener;
    private Timer _timer;
    private final NodeListener _nodeListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = SourceElementHandle.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this._nodeListener = new 1();
    }

    public SourceElementHandle(SourceElement sourceElement) {
        this.$init$();
        this._sourceElement = sourceElement;
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        this._url = sourceFile.getURL();
        String string = sourceElement.getText();
        this._hashCode = string.hashCode();
        JavaProvider javaProvider = sourceFile.getProvider();
        if (javaProvider instanceof JavaFileProvider) {
            this._javaFileProvider = (JavaFileProvider)javaProvider;
            this._sourceElementPath = SourceElementPath.createElement(sourceElement);
            TextNode textNode = this.getNode();
            textNode.addNodeListener(this._nodeListener);
            this.attachTextBufferListener();
        }
    }

    private TextNode getNode() {
        TextNode textNode = null;
        try {
            textNode = (TextNode)NodeFactory.findOrCreate((URL)this._url);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return textNode;
    }

    private void attachTextBufferListener() {
        TextNode textNode = this.getNode();
        if (textNode != null) {
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            textBuffer.addTextBufferListener((TextBufferListener)this);
        }
    }

    private void detachTextBufferListener() {
        TextNode textNode = this.getNode();
        if (textNode != null) {
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            textBuffer.removeTextBufferListener((TextBufferListener)this);
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        if (this._sourceElementPath != null) {
            this._sourceElementPath.updateOffsets(n, n2);
            this.whenBufferUpdated();
        }
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        if (this._sourceElementPath != null) {
            this._sourceElementPath.updateOffsets(n, -n2);
            this.whenBufferUpdated();
        }
    }

    private void whenBufferUpdated() {
        Timer timer = this.getTimer();
        timer.restart();
    }

    private Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer(500, this);
            this._timer.setCoalesce(true);
            this._timer.setRepeats(false);
        }
        return this._timer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._propertyChangeListener != null) {
            SourceElement sourceElement = this.getElement();
            boolean bl = sourceElement != null;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROPERTY_VALID, null, bl);
            this._propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public URL getURL() {
        return this._url;
    }

    public SourceElement getElement() {
        SourceFile sourceFile;
        boolean bl = false;
        if (this._sourceElement != null && !(sourceFile = this._sourceElement.getOwningSourceFile()).isExpired()) {
            bl = true;
        }
        if (!bl) {
            this._sourceElement = null;
            SourceFile sourceFile2 = this._javaFileProvider.getSourceFile(this._url);
            if (this._sourceElementPath != null) {
                String string;
                SourceElement sourceElement;
                if (sourceFile2 != null && this._sourceElement == null && (sourceElement = this._sourceElementPath.find(sourceFile2)) != null && (string = sourceElement.getText()).hashCode() == this._hashCode) {
                    this._sourceElement = sourceElement;
                }
            } else {
                this._sourceElement = sourceFile2;
            }
        }
        return this._sourceElement;
    }

    public void release() {
        if (this._timer != null) {
            this._timer.stop();
        }
        TextNode textNode = this.getNode();
        textNode.removeNodeListener(this._nodeListener);
        this.detachTextBufferListener();
    }

    public int getOffset() {
        if (this._sourceElementPath != null) {
            return this._sourceElementPath.getOffset();
        }
        return 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && this._propertyChangeListener != null) {
            throw new AssertionError();
        }
        this._propertyChangeListener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListener = null;
    }

    static PropertyChangeListener ra$_propertyChangeListener(SourceElementHandle sourceElementHandle) {
        return sourceElementHandle._propertyChangeListener;
    }

    static void wa$_url(SourceElementHandle sourceElementHandle, URL uRL) {
        sourceElementHandle._url = uRL;
    }

    static void wa$_sourceElement(SourceElementHandle sourceElementHandle, SourceElement sourceElement) {
        sourceElementHandle._sourceElement = sourceElement;
    }

    static void mav$detachTextBufferListener(SourceElementHandle sourceElementHandle) {
        sourceElementHandle.detachTextBufferListener();
    }

    static void mav$attachTextBufferListener(SourceElementHandle sourceElementHandle) {
        sourceElementHandle.attachTextBufferListener();
    }

    public final class 1
    extends NodeListener {
        public void nodeOpened(NodeEvent nodeEvent) {
            SourceElementHandle.mav$attachTextBufferListener(SourceElementHandle.this);
            SourceElementHandle.this.getElement();
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
            SourceElementHandle.wa$_sourceElement(SourceElementHandle.this, null);
            SourceElementHandle.mav$detachTextBufferListener(SourceElementHandle.this);
        }

        public void nodeDeleted(NodeEvent nodeEvent) {
            if (SourceElementHandle.ra$_propertyChangeListener(SourceElementHandle.this) != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, SourceElementHandle.PROPERTY_VALID, null, false);
                SourceElementHandle.ra$_propertyChangeListener(SourceElementHandle.this).propertyChange(propertyChangeEvent);
            }
        }

        public void nodeRenamed(NodeEvent nodeEvent, URL uRL, URL uRL2) {
            if (SourceElementHandle.ra$_propertyChangeListener(SourceElementHandle.this) != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, SourceElementHandle.PROPERTY_VALID, null, false);
                SourceElementHandle.ra$_propertyChangeListener(SourceElementHandle.this).propertyChange(propertyChangeEvent);
            }
            SourceElementHandle.wa$_url(SourceElementHandle.this, uRL2);
        }
    }
}

