/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasBlock;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;

public class SourceUtils {
    public static void addImport(SourceFile sourceFile, String string) {
        sourceFile.getSourceImportNames().add(string);
    }

    public static void addLineComment(SourceBlock sourceBlock, String string) {
    }

    public static void addLineComment(SourceClassBody sourceClassBody, String string) {
    }

    public static void addLineComment(SourceElement sourceElement, boolean bl, String string) {
    }

    public static void addBlankLine(SourceBlock sourceBlock) {
    }

    public static void addBlankLine(SourceClassBody sourceClassBody) {
    }

    public static void addBlankLine(SourceElement sourceElement, boolean bl) {
    }

    public static SourceClass addClass(SourceFile sourceFile, String string, int n) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceFile);
        SourceClass sourceClass = sourceFactory.createClass(0, string);
        sourceClass.setModifiers(n);
        sourceFile.getSourceClasses().add(sourceClass);
        return sourceClass;
    }

    public static SourceClass addInterface(SourceFile sourceFile, String string, int n) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceFile);
        SourceClass sourceClass = sourceFactory.createClass(1, string);
        sourceClass.setModifiers(n);
        sourceFile.getSourceClasses().add(sourceClass);
        return sourceClass;
    }

    public static void setSuperclass(SourceClass sourceClass, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        sourceClass.setSourceSuperclass(sourceFactory.createType(string));
    }

    public static void addSuperInterface(SourceClass sourceClass, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        sourceClass.getSourceInterfaces().add(sourceFactory.createType(string));
    }

    public static SourceMethod addConstructor(SourceClass sourceClass, int n) {
        SourceMethod sourceMethod = SourceUtils.createConstructor(sourceClass, n);
        sourceClass.getSourceMembers().add(0, sourceMethod);
        return sourceMethod;
    }

    public static SourceMethod getDefaultConstructor(SourceClass sourceClass) {
        return sourceClass.getSourceConstructor(new JavaType[0]);
    }

    public static SourceMethod addMethod(SourceClass sourceClass, String string, String string2, int n) {
        SourceMethod sourceMethod = SourceUtils.createMethod(sourceClass, string, string2, n);
        sourceClass.getSourceMethods().add(sourceMethod);
        return sourceMethod;
    }

    public static SourceMethod addMethod(SourceClass sourceClass, String string, String string2, int n, SourceMember sourceMember, boolean bl) {
        SourceMethod sourceMethod = SourceUtils.createMethod(sourceClass, string, string2, n);
        SourceUtils.addMember(sourceClass, (SourceMember)sourceMethod, sourceMember, bl);
        return sourceMethod;
    }

    public static SourceMember addMember(SourceClass sourceClass, SourceMember sourceMember, SourceMember sourceMember2, boolean bl) {
        int n;
        List list = sourceClass.getSourceMembers();
        if (sourceMember2 != null && (n = list.indexOf(sourceMember2)) != -1) {
            int n2 = bl ? n : n + 1;
            list.add(n2, sourceMember);
            return sourceMember;
        }
        if (bl) {
            list.add(0, sourceMember);
        } else {
            list.add(sourceMember);
        }
        return sourceMember;
    }

    public static SourceMethod createMethod(SourceClass sourceClass, String string, String string2, int n) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        SourceBlock sourceBlock = sourceClass.isClass() ? sourceFactory.createBlock() : null;
        SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference, string2, null, null, sourceBlock);
        sourceMethod.setModifiers(n);
        return sourceMethod;
    }

    public static SourceMethod createConstructor(SourceClass sourceClass, int n) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        SourceBlock sourceBlock = sourceFactory.createBlock();
        SourceMethod sourceMethod = sourceFactory.createConstructor(null, null, sourceBlock);
        sourceMethod.setModifiers(n);
        return sourceMethod;
    }

    public static void addThrows(SourceMethod sourceMethod, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceMethod);
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        sourceMethod.getSourceExceptions().add(sourceTypeReference);
    }

    public static void removeThrows(SourceMethod sourceMethod, String string) {
        List list = sourceMethod.getSourceExceptions();
        for (SourceTypeReference sourceTypeReference : list) {
            if (!sourceTypeReference.getName().equals(string)) continue;
            sourceTypeReference.removeSelf();
            break;
        }
    }

    public static SourceMethod addMainMethod(SourceClass sourceClass) {
        SourceMethod sourceMethod = SourceUtils.createMainMethod(sourceClass);
        sourceClass.getSourceMethods().add(sourceMethod);
        return sourceMethod;
    }

    public static SourceMethod createMainMethod(SourceClass sourceClass) {
        SourceMethod sourceMethod = SourceUtils.createMethod(sourceClass, "void", "main", 9);
        SourceUtils.addMethodParameter(sourceMethod, "java.lang.String[]", "args");
        return sourceMethod;
    }

    public static SourceMethod getMainMethod(SourceClass sourceClass) {
        return SourceUtils.getMethod(sourceClass, "main", new String[]{"java.lang.String[]"});
    }

    public static SourceMethod getMethod(SourceClass sourceClass, String string, String[] stringArray) {
        JavaProvider javaProvider = sourceClass.getOwningSourceFile().getProvider();
        int n = stringArray == null ? 0 : stringArray.length;
        JavaType[] javaTypeArray = new JavaType[n];
        int n2 = 0;
        while (n2 < n) {
            javaTypeArray[n2] = SourceUtils.getType(javaProvider, stringArray[n2]);
            ++n2;
        }
        return sourceClass.getSourceMethod(string, javaTypeArray);
    }

    public static JavaType getType(JavaProvider javaProvider, String string) {
        String string2 = string;
        int n = 0;
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            n = (string.length() - n2) / 2;
            string2 = string.substring(0, n2).trim();
        }
        JavaClass javaClass = javaProvider.getClass(string2);
        if (n == 0 || javaClass == null) {
            return javaClass;
        }
        return javaProvider.getArrayType((JavaType)javaClass, n);
    }

    public static SourceLocalVariable addMethodParameter(SourceMethod sourceMethod, String string, String string2) {
        SourceFile sourceFile = sourceMethod.getOwningSourceFile();
        SourceLocalVariable sourceLocalVariable = SourceUtils.createLocalVariable(sourceFile, string, string2);
        sourceMethod.getSourceParameters().add(sourceLocalVariable);
        return sourceLocalVariable;
    }

    public static SourceClassInitializer addStaticClassInitializer(SourceClass sourceClass, SourceBlock sourceBlock) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        SourceClassInitializer sourceClassInitializer = sourceFactory.createStaticInitializer(sourceBlock);
        sourceClass.getSourceInitializers().add(sourceClassInitializer);
        return sourceClassInitializer;
    }

    public static SourceDocComment addDocComment(SourceMember sourceMember, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceMember);
        SourceDocTextFragment sourceDocTextFragment = sourceFactory.createDocTextFragment(string);
        SourceDocDescription sourceDocDescription = sourceFactory.createDocDescription(sourceDocTextFragment);
        SourceDocComment sourceDocComment = sourceFactory.createDocComment(sourceDocDescription);
        sourceMember.setDocComment(sourceDocComment);
        return sourceDocComment;
    }

    public static SourceDocTag addDocTag(SourceDocComment sourceDocComment, String string, String string2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceDocComment);
        SourceDocTagName sourceDocTagName = sourceFactory.createDocTagName(string);
        SourceDocTextFragment sourceDocTextFragment = sourceFactory.createDocTextFragment(string2);
        SourceDocDescription sourceDocDescription = sourceFactory.createDocDescription(sourceDocTextFragment);
        SourceDocBlockTag sourceDocBlockTag = sourceFactory.createDocBlockTag(sourceDocTagName, sourceDocDescription);
        sourceDocComment.getBlockTags().add(sourceDocBlockTag);
        return sourceDocBlockTag;
    }

    public static SourceFieldDeclaration addField(SourceClass sourceClass, String string, String string2, int n, String string3) {
        SourceFieldDeclaration sourceFieldDeclaration = SourceUtils.createField(sourceClass, string, string2, n, string3);
        sourceClass.getSourceFieldDeclarations().add(sourceFieldDeclaration);
        return sourceFieldDeclaration;
    }

    public static SourceFieldDeclaration createField(SourceClass sourceClass, String string, String string2, int n, String string3) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceClass);
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        SourceExpression sourceExpression = null;
        if (string3 != null && string3.length() > 0) {
            sourceExpression = sourceFactory.createExpressionFromText(string3);
        }
        SourceFieldDeclaration sourceFieldDeclaration = sourceExpression == null ? sourceFactory.createFieldDeclaration(sourceTypeReference, string2) : sourceFactory.createFieldDeclaration(sourceTypeReference, string2, sourceExpression);
        sourceFieldDeclaration.setModifiers(n);
        return sourceFieldDeclaration;
    }

    public static SourceLocalVariable createLocalVariable(SourceFile sourceFile, String string, String string2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceFile);
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceTypeReference, string2);
        return sourceLocalVariable;
    }

    public static SourceVariableDeclaration addLocalVariableDeclaration(SourceBlock sourceBlock, String string, String string2, String string3) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = null;
        if (string3 != null && string3.length() > 0) {
            sourceExpression = sourceFactory.createExpressionFromText(string3);
        }
        return SourceUtils.addLocalVariableDeclaration(sourceBlock, string, string2, sourceExpression);
    }

    public static SourceVariableDeclaration addLocalVariableDeclaration(SourceBlock sourceBlock, String string, String string2, SourceExpression sourceExpression) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        SourceLocalVariableDeclaration sourceLocalVariableDeclaration = sourceExpression == null ? sourceFactory.createLocalVariableDeclaration(sourceTypeReference, string2) : sourceFactory.createLocalVariableDeclaration(sourceTypeReference, string2, sourceExpression);
        sourceBlock.getCodeElements().add(sourceLocalVariableDeclaration);
        return sourceLocalVariableDeclaration;
    }

    public static SourceExpression createMethodCall(SourceBlock sourceBlock, String string, String string2, String[] stringArray) {
        SourceExpression[] sourceExpressionArray;
        int n;
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        if (stringArray == null) {
            stringArray = JavaConstants.EMPTY_STRING_ARRAY;
        }
        if ((n = stringArray.length) == 0) {
            sourceExpressionArray = SourceExpression.EMPTY_ARRAY;
        } else {
            ArrayList<SourceExpression> arrayList = new ArrayList<SourceExpression>();
            int n2 = 0;
            while (n2 < n) {
                SourceExpression sourceExpression = sourceFactory.createExpressionFromText(stringArray[n2]);
                if (sourceExpression != null) {
                    arrayList.add(sourceExpression);
                }
                ++n2;
            }
            SourceExpression[] sourceExpressionArray2 = new SourceExpression[arrayList.size()];
            sourceExpressionArray = arrayList.toArray(sourceExpressionArray2);
        }
        return SourceUtils.createMethodCall(sourceBlock, string, string2, sourceExpressionArray);
    }

    public static SourceExpression createMethodCall(SourceBlock sourceBlock, String string, String string2, SourceExpression[] sourceExpressionArray) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = null;
        if (string != null) {
            sourceExpression = sourceFactory.createExpressionFromText(string);
        }
        SourceListExpression sourceListExpression = sourceFactory.createExpressionList(sourceExpressionArray);
        SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall(sourceExpression, string2, sourceListExpression);
        return sourceMethodCallExpression;
    }

    public static SourceStatement addMethodCallStatement(SourceBlock sourceBlock, String string, String string2, String[] stringArray) {
        SourceExpression sourceExpression = SourceUtils.createMethodCall(sourceBlock, string, string2, stringArray);
        return SourceUtils.addExpressionStatement(sourceBlock, sourceExpression);
    }

    public static SourceStatement addMethodCallStatement(SourceBlock sourceBlock, String string, String string2, SourceExpression[] sourceExpressionArray) {
        SourceExpression sourceExpression = SourceUtils.createMethodCall(sourceBlock, string, string2, sourceExpressionArray);
        return SourceUtils.addExpressionStatement(sourceBlock, sourceExpression);
    }

    public static SourceExpression createAssign(SourceBlock sourceBlock, String string, String string2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceExpression sourceExpression2 = sourceFactory.createExpressionFromText(string2);
        SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, sourceExpression, sourceExpression2);
        return sourceAssignmentExpression;
    }

    public static SourceStatement addAssignStatement(SourceBlock sourceBlock, String string, String string2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string2);
        return SourceUtils.addAssignStatement(sourceBlock, string, sourceExpression);
    }

    public static SourceStatement addAssignStatement(SourceBlock sourceBlock, String string, SourceExpression sourceExpression) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression2 = sourceFactory.createExpressionFromText(string);
        SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, sourceExpression2, sourceExpression);
        return SourceUtils.addExpressionStatement(sourceBlock, (SourceExpression)sourceAssignmentExpression);
    }

    public static SourceStatement addExpressionStatement(SourceBlock sourceBlock, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        return SourceUtils.addExpressionStatement(sourceBlock, sourceExpression);
    }

    public static SourceStatement addExpressionStatement(SourceBlock sourceBlock, SourceExpression sourceExpression) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement(sourceExpression);
        sourceBlock.getCodeElements().add(sourceExpressionStatement);
        return sourceExpressionStatement;
    }

    public static SourceStatement addStatement(SourceBlock sourceBlock, String string) {
        SourceBlockElement sourceBlockElement;
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceStatement sourceStatement = sourceFactory.createStatementFromText(string);
        if (sourceStatement == null && (sourceBlockElement = sourceFactory.createBlockElementFromText(string)) != null) {
            throw new UnsupportedOperationException("Is a block element but not a statement");
        }
        sourceBlock.getCodeElements().add(sourceStatement);
        return sourceStatement;
    }

    public static SourceStatement addExpressionStatement(SourceBlock sourceBlock, String string, SourceElement sourceElement, boolean bl) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        return SourceUtils.addExpressionStatement(sourceBlock, sourceExpression, sourceElement, bl);
    }

    public static SourceStatement addExpressionStatement(SourceBlock sourceBlock, SourceExpression sourceExpression, SourceElement sourceElement, boolean bl) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement(sourceExpression);
        return SourceUtils.addStatement(sourceBlock, (SourceStatement)sourceExpressionStatement, sourceElement, bl);
    }

    public static SourceStatement addStatement(SourceBlock sourceBlock, SourceStatement sourceStatement, SourceElement sourceElement, boolean bl) {
        int n;
        List list = sourceBlock.getCodeElements();
        if (sourceElement != null && (n = list.indexOf(sourceElement)) != -1) {
            int n2 = bl ? n : n + 1;
            list.add(n2, sourceStatement);
            return sourceStatement;
        }
        if (bl) {
            list.add(0, sourceStatement);
        } else {
            list.add(sourceStatement);
        }
        return sourceStatement;
    }

    public static SourceIfStatement addIfStatement(SourceBlock sourceBlock, String string, SourceBlock sourceBlock2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceIfStatement sourceIfStatement = sourceFactory.createIfStatement(sourceExpression, (SourceStatement)sourceFactory.createBlockStatement(sourceBlock2));
        sourceBlock.getCodeElements().add(sourceIfStatement);
        return sourceIfStatement;
    }

    public static SourceWhileStatement addWhileStatement(SourceBlock sourceBlock, String string, SourceBlock sourceBlock2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceWhileStatement sourceWhileStatement = sourceFactory.createWhileStatement(sourceExpression, (SourceStatement)sourceFactory.createBlockStatement(sourceBlock2));
        sourceBlock.getCodeElements().add(sourceWhileStatement);
        return sourceWhileStatement;
    }

    public static SourceIfStatement addIfElseStatement(SourceBlock sourceBlock, String string, SourceBlock sourceBlock2, SourceBlock sourceBlock3) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceIfStatement sourceIfStatement = sourceFactory.createIfElseStatement(sourceExpression, (SourceStatement)sourceFactory.createBlockStatement(sourceBlock2), (SourceStatement)sourceFactory.createBlockStatement(sourceBlock3));
        sourceBlock.getCodeElements().add(sourceIfStatement);
        return sourceIfStatement;
    }

    public static SourceStatement addReturn(SourceBlock sourceBlock, String string) {
        SourceStatement sourceStatement = SourceUtils.createReturn(sourceBlock, string);
        sourceBlock.getCodeElements().add(sourceStatement);
        return sourceStatement;
    }

    public static SourceStatement createReturn(SourceBlock sourceBlock, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceReturnStatement sourceReturnStatement = sourceFactory.createReturnStatement(sourceExpression);
        return sourceReturnStatement;
    }

    public static SourceThrowStatement addThrowStatement(SourceBlock sourceBlock, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceThrowStatement sourceThrowStatement = sourceFactory.createThrowStatement(sourceExpression);
        sourceBlock.getCodeElements().add(sourceThrowStatement);
        return sourceThrowStatement;
    }

    public static SourceSwitchStatement addSwitchStatement(SourceBlock sourceBlock, String string, SourceBlock sourceBlock2) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceSwitchStatement sourceSwitchStatement = sourceFactory.createSwitchStatement(sourceExpression, sourceFactory.createBlockStatement(sourceBlock2));
        sourceBlock.getCodeElements().add(sourceSwitchStatement);
        return sourceSwitchStatement;
    }

    public static SourceSwitchLabel addSwitchCaseLabel(SourceBlock sourceBlock, String string) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
        SourceSwitchLabel sourceSwitchLabel = sourceFactory.createSwitchCaseLabel(sourceExpression);
        sourceBlock.getCodeElements().add(sourceSwitchLabel);
        return sourceSwitchLabel;
    }

    public static SourceTryStatement addTryCatchStatement(SourceBlock sourceBlock, SourceBlock sourceBlock2, String string, String string2, SourceBlock sourceBlock3) {
        SourceTryStatement sourceTryStatement = SourceUtils.createTryCatchStatement(sourceBlock, sourceBlock2, string, string2, sourceBlock3);
        sourceBlock.getCodeElements().add(sourceTryStatement);
        return sourceTryStatement;
    }

    public static SourceBlock getFinallyBlock(SourceTryStatement sourceTryStatement) {
        SourceStatement sourceStatement;
        SourceFinallyClause sourceFinallyClause = sourceTryStatement.getFinallyClause();
        if (sourceFinallyClause != null && (sourceStatement = sourceFinallyClause.getPrimaryClause()) instanceof SourceHasBlock) {
            return ((SourceHasBlock)sourceStatement).getBlock();
        }
        return null;
    }

    public static SourceFinallyClause addFinallyClause(SourceTryStatement sourceTryStatement, SourceBlock sourceBlock) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceTryStatement);
        SourceFinallyClause sourceFinallyClause = sourceFactory.createFinallyClause(sourceFactory.createBlockStatement(sourceBlock));
        sourceTryStatement.getChildren().add(sourceFinallyClause);
        return sourceFinallyClause;
    }

    public static SourceCatchClause addCatchClause(SourceTryStatement sourceTryStatement, String string, String string2, SourceBlock sourceBlock) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceTryStatement);
        SourceLocalVariable sourceLocalVariable = SourceUtils.createLocalVariable(sourceTryStatement.getOwningSourceFile(), string, string2);
        SourceCatchClause sourceCatchClause = sourceFactory.createCatchClause(sourceLocalVariable, sourceFactory.createBlockStatement(sourceBlock));
        sourceTryStatement.getCatchClauses().add(sourceCatchClause);
        return sourceCatchClause;
    }

    public static SourceTryStatement createTryCatchStatement(SourceBlock sourceBlock, SourceBlock sourceBlock2, String string, String string2, SourceBlock sourceBlock3) {
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceLocalVariable sourceLocalVariable = SourceUtils.createLocalVariable(sourceBlock.getOwningSourceFile(), string, string2);
        SourceTryStatement sourceTryStatement = sourceFactory.createTryCatchStatement(sourceFactory.createBlockStatement(sourceBlock2), sourceLocalVariable, sourceFactory.createBlockStatement(sourceBlock3));
        return sourceTryStatement;
    }

    public static SourceVariable getMethodParameter(SourceMethod sourceMethod, int n) {
        List list = sourceMethod.getSourceParameters();
        if (list.size() > n) {
            return (SourceVariable)list.get(n);
        }
        return null;
    }

    public static SourceFactory getFactory(SourceElement sourceElement) {
        return sourceElement.getOwningSourceFile().getFactory();
    }

    public static SourceBlock createBlock(SourceElement sourceElement) {
        return SourceUtils.getFactory(sourceElement).createBlock();
    }
}

