/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class TimedLRUCache {
    public static final int NO_EXPIRATION = -1;
    public static final int MINIMUM_EXPIRATION = 60000;
    private static final int CHECK_INTERVAL = 5000;
    private int _maxSize;
    private int _expireTime;
    private HashMap _entryMap;
    private long _lastCheck;
    private static final Comparator ACCESS_COMPARATOR = new AccessComparator(null);

    public TimedLRUCache(int n) {
        this(n, -1);
    }

    public TimedLRUCache(int n, int n2) {
        this._maxSize = n;
        this._expireTime = n2;
        if (this._expireTime != -1) {
            this._expireTime = Math.max(this._expireTime, 60000);
        }
        this._lastCheck = System.currentTimeMillis();
        this._entryMap = new HashMap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.get(object);
            if (entry != null) {
                Entry.wa$access(entry, System.currentTimeMillis());
                Object object2 = Entry.ra$value(entry);
                return object2;
            }
            Object var5_5 = null;
            return var5_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, Object object2) {
        this.checkForExpiration();
        if (object2 != null && object != null) {
            Entry entry = new Entry(object, object2, System.currentTimeMillis(), null);
            HashMap hashMap = this._entryMap;
            synchronized (hashMap) {
                this._entryMap.put(object, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.remove(object);
            if (entry != null) {
                Object object2 = Entry.ra$value(entry);
                return object2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKey(Object object) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            boolean bl = this._entryMap.containsKey(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int size() {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            int n = this._entryMap.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForExpiration() {
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            int n;
            long l = this._lastCheck + 5000L;
            long l2 = System.currentTimeMillis();
            if (l2 < l) {
                return;
            }
            this._lastCheck = l2;
            if (this._expireTime != -1) {
                long l3 = System.currentTimeMillis();
                long l4 = l3 - (long)this._expireTime;
                Iterator iterator = this._entryMap.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    if (Entry.ra$access(entry) > l4) continue;
                    iterator.remove();
                }
            }
            if ((n = this._entryMap.size()) > this._maxSize) {
                Object[] objectArray = this._entryMap.values().toArray();
                Arrays.sort(objectArray, ACCESS_COMPARATOR);
                int n2 = this._maxSize;
                while (n2 < n) {
                    Entry entry = (Entry)objectArray[n2];
                    this._entryMap.remove(Entry.ra$key(entry));
                    ++n2;
                }
            }
        }
    }

    private static class AccessComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return (int)(Entry.ra$access(entry2) - Entry.ra$access(entry));
        }

        private AccessComparator() {
        }

        AccessComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class Entry {
        private Object key;
        private Object value;
        private long access;

        private Entry(Object object, Object object2, long l) {
            this.key = object;
            this.value = object2;
            this.access = l;
        }

        static long ra$access(Entry entry) {
            return entry.access;
        }

        static Object ra$key(Entry entry) {
            return entry.key;
        }

        static Object ra$value(Entry entry) {
            return entry.value;
        }

        Entry(Object object, Object object2, long l, 1 var5_4) {
            this(object, object2, l);
        }

        static void wa$access(Entry entry, long l) {
            entry.access = l;
        }

        public final class 1 {
        }
    }
}

