/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.javadoc.TagDefs;

public class TagDescriptor
implements TagDefs,
Copyable {
    private String _name;
    private int _params;
    private String _reference;
    private int _scope;
    private boolean _custom;
    private boolean _allowDuplicates;
    private boolean _required;
    private boolean _allowsTemplate;
    private String _template;
    private String _label;

    public TagDescriptor() {
        this("", 0, 1);
    }

    public TagDescriptor(String string, int n, int n2) {
        this(string, n, n2, "", true, true, false, true, "", string);
    }

    public TagDescriptor(String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, String string4) {
        this._name = string;
        this._scope = n;
        this._params = n2;
        this._reference = string2;
        this._custom = bl;
        this._allowDuplicates = bl2;
        this._required = bl3;
        this._allowsTemplate = bl4;
        this._template = string3;
        this._label = string4;
    }

    public Object copyTo(Object object) {
        TagDescriptor tagDescriptor = object instanceof TagDescriptor ? (TagDescriptor)object : new TagDescriptor();
        this.copyToImpl(tagDescriptor);
        return tagDescriptor;
    }

    private void copyToImpl(TagDescriptor tagDescriptor) {
        tagDescriptor._name = this._name;
        tagDescriptor._params = this._params;
        tagDescriptor._reference = this._reference;
        tagDescriptor._scope = this._scope;
        tagDescriptor._custom = this._custom;
        tagDescriptor._allowDuplicates = this._allowDuplicates;
        tagDescriptor._required = this._required;
        tagDescriptor._allowsTemplate = this._allowsTemplate;
        tagDescriptor._template = this._template;
        tagDescriptor._label = this._label;
    }

    public boolean equals(TagDescriptor tagDescriptor) {
        return tagDescriptor != null && this.getName().equals(tagDescriptor.getName()) && this.getTemplate().equals(tagDescriptor.getTemplate()) && this.isCustom() == tagDescriptor.isCustom() && this.getParams() == tagDescriptor.getParams() && this.getScope() == tagDescriptor.getScope() && this.isRequired() == tagDescriptor.isRequired() && this.isAllowDuplicates() == tagDescriptor.isAllowDuplicates() && this.isAllowsTemplate() == tagDescriptor.isAllowsTemplate() && this.getLabel().equals(tagDescriptor.getLabel()) && this.getReference() == tagDescriptor.getReference();
    }

    public boolean nameAndReferenceEquals(SourceDocTag sourceDocTag) {
        return this.nameEquals(sourceDocTag) && this.referenceEquals(sourceDocTag);
    }

    public boolean equals(SourceDocTag sourceDocTag) {
        if (this.nameEquals(sourceDocTag)) {
            if (this.getParams() == 2) {
                return this.referenceEquals(sourceDocTag) && this.templateEquals(sourceDocTag);
            }
            return this.templateEquals(sourceDocTag);
        }
        return false;
    }

    private boolean nameEquals(SourceDocTag sourceDocTag) {
        String string = sourceDocTag.getName();
        if (string.equals(this.getName())) {
            return true;
        }
        if ("@throws".equals(this.getName()) && sourceDocTag.isException()) {
            return "@throws".equals(string) || "@exception".equals(string);
        }
        return false;
    }

    private boolean referenceEquals(SourceDocTag sourceDocTag) {
        if (this.getParams() == 2) {
            String string = this.getReference();
            if (sourceDocTag.isParameter()) {
                SourceDocReference sourceDocReference = sourceDocTag.getReference();
                String string2 = sourceDocReference != null ? sourceDocReference.getParameterName() : sourceDocTag.getArgumentText();
                return string2.equals(string);
            }
            if (sourceDocTag.isException()) {
                String string3 = sourceDocTag.getReferenceText();
                if (string3 == null || string3.equals("")) {
                    return string.equals("");
                }
                return string3.equals(string) || string3.endsWith("." + string);
            }
        }
        return true;
    }

    private boolean templateEquals(SourceDocTag sourceDocTag) {
        String string = this.getTemplate();
        if (string.length() == 0) {
            return true;
        }
        String string2 = sourceDocTag.getArgumentText();
        string2 = string2 == null ? "" : string2.trim();
        return string2.startsWith(string);
    }

    public SourceDocTag[] findDocTags(SourceDocTag[] sourceDocTagArray) {
        ArrayList<SourceDocTag> arrayList = new ArrayList<SourceDocTag>();
        int n = 0;
        while (n < sourceDocTagArray.length) {
            SourceDocTag sourceDocTag = sourceDocTagArray[n];
            if (this.equals(sourceDocTag)) {
                arrayList.add(sourceDocTag);
            }
            ++n;
        }
        SourceDocTag[] sourceDocTagArray2 = new SourceDocTag[arrayList.size()];
        arrayList.toArray(sourceDocTagArray2);
        return sourceDocTagArray2;
    }

    public boolean tagNamesAreEqual(TagDescriptor tagDescriptor) {
        if (this.getParams() == 1 && this.getParams() == tagDescriptor.getParams()) {
            return this.getName().equals(tagDescriptor.getName());
        }
        return this.getName().equals(tagDescriptor.getName()) && this.getReference().equals(tagDescriptor.getReference());
    }

    public String getFullTagName() {
        String string = this.getName();
        if (this.getParams() == 2 && this.getReference().length() > 0) {
            string = string + " " + this.getReference();
        }
        if (this.getTemplate().length() > 0) {
            string = string + " " + this.getTemplate();
        }
        return string;
    }

    public String getBriefName() {
        int n;
        String string = this.getName();
        if (string.startsWith("{") && (string = string.substring((n = string.indexOf(123)) + 1)).endsWith("}")) {
            n = string.lastIndexOf(125);
            string = string.substring(0, n);
        }
        if (string.startsWith("@")) {
            int n2 = string.indexOf(64);
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public void setReference(String string) {
        this._reference = string;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLabel(String string) {
        this._label = string;
    }

    public String getLabel() {
        return this._label;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setParams(int n) {
        this._params = n;
    }

    public int getParams() {
        return this._params;
    }

    public void setScope(int n) {
        this._scope |= n;
    }

    public void unsetScope(int n) {
        this._scope &= ~n;
    }

    public int getScope() {
        return this._scope;
    }

    public void setTemplate(String string) {
        this._template = string;
    }

    public String getTemplate() {
        return this._template;
    }

    public void setAllowDuplicates(boolean bl) {
        this._allowDuplicates = bl;
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowsTemplate(boolean bl) {
        this._allowsTemplate = bl;
    }

    public boolean isAllowsTemplate() {
        return this._allowsTemplate;
    }

    public void setCustom(boolean bl) {
        this._custom = bl;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public void setRequired(boolean bl) {
        this._required = bl;
    }

    public boolean isRequired() {
        return this._required;
    }
}

