/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDefs;
import oracle.jdeveloper.javadoc.TagDescriptor;

public class TagManager
implements TagDefs {
    private static ArrayList _allTagsList;
    private static TagDescriptor[] _inlineTags;
    private static JavadocSettings _settings;
    private static TagManager _singleton;
    private static TagDescriptor[] _standaloneTags;

    private TagManager() {
        ArrayList<TagDescriptor> arrayList = new ArrayList<TagDescriptor>();
        TagDescriptor tagDescriptor = new TagDescriptor("@author", 1, 1);
        tagDescriptor.setCustom(false);
        tagDescriptor.setRequired(false);
        tagDescriptor.setAllowsTemplate(true);
        tagDescriptor.setAllowDuplicates(true);
        arrayList.add(tagDescriptor);
        TagDescriptor tagDescriptor2 = new TagDescriptor("@version", 1, 1);
        tagDescriptor2.setCustom(false);
        tagDescriptor2.setRequired(false);
        tagDescriptor2.setAllowsTemplate(true);
        tagDescriptor2.setAllowDuplicates(false);
        arrayList.add(tagDescriptor2);
        TagDescriptor tagDescriptor3 = new TagDescriptor("@param", 12, 2);
        tagDescriptor3.setCustom(false);
        tagDescriptor3.setAllowDuplicates(false);
        tagDescriptor3.setRequired(true);
        tagDescriptor3.setAllowsTemplate(false);
        tagDescriptor3.setTemplate("<parameter name>");
        arrayList.add(tagDescriptor3);
        TagDescriptor tagDescriptor4 = new TagDescriptor("@return", 4, 1);
        tagDescriptor4.setCustom(false);
        tagDescriptor4.setAllowDuplicates(false);
        tagDescriptor4.setRequired(true);
        tagDescriptor4.setAllowsTemplate(false);
        arrayList.add(tagDescriptor4);
        TagDescriptor tagDescriptor5 = new TagDescriptor("@throws", 12, 2);
        tagDescriptor5.setCustom(false);
        tagDescriptor5.setAllowDuplicates(false);
        tagDescriptor5.setRequired(true);
        tagDescriptor5.setAllowsTemplate(false);
        tagDescriptor5.setTemplate("<throws type>");
        arrayList.add(tagDescriptor5);
        TagDescriptor tagDescriptor6 = new TagDescriptor("@see", 15, 1);
        tagDescriptor6.setCustom(false);
        tagDescriptor6.setAllowDuplicates(true);
        tagDescriptor6.setRequired(false);
        tagDescriptor6.setAllowsTemplate(false);
        arrayList.add(tagDescriptor6);
        TagDescriptor tagDescriptor7 = new TagDescriptor("@since", 15, 1);
        tagDescriptor7.setCustom(false);
        tagDescriptor7.setAllowDuplicates(false);
        tagDescriptor7.setRequired(false);
        tagDescriptor7.setAllowsTemplate(true);
        arrayList.add(tagDescriptor7);
        TagDescriptor tagDescriptor8 = new TagDescriptor("@serial", 3, 1);
        tagDescriptor8.setCustom(false);
        tagDescriptor8.setAllowDuplicates(false);
        tagDescriptor8.setRequired(false);
        tagDescriptor8.setAllowsTemplate(false);
        arrayList.add(tagDescriptor8);
        TagDescriptor tagDescriptor9 = new TagDescriptor("@serialData", 12, 1);
        tagDescriptor9.setCustom(false);
        tagDescriptor9.setAllowDuplicates(false);
        tagDescriptor9.setRequired(false);
        tagDescriptor9.setAllowsTemplate(false);
        arrayList.add(tagDescriptor9);
        TagDescriptor tagDescriptor10 = new TagDescriptor("@serialField", 2, 1);
        tagDescriptor10.setCustom(false);
        tagDescriptor10.setAllowDuplicates(false);
        tagDescriptor10.setRequired(false);
        tagDescriptor10.setAllowsTemplate(false);
        arrayList.add(tagDescriptor10);
        TagDescriptor tagDescriptor11 = new TagDescriptor("@deprecated", 15, 1);
        tagDescriptor11.setCustom(false);
        tagDescriptor11.setAllowDuplicates(false);
        tagDescriptor11.setRequired(false);
        tagDescriptor11.setAllowsTemplate(false);
        arrayList.add(tagDescriptor11);
        _standaloneTags = new TagDescriptor[arrayList.size()];
        arrayList.toArray(_standaloneTags);
        arrayList = new ArrayList();
        TagDescriptor tagDescriptor12 = new TagDescriptor("@docRoot", 15, 1);
        tagDescriptor12.setCustom(false);
        tagDescriptor12.setAllowDuplicates(true);
        tagDescriptor12.setRequired(false);
        tagDescriptor12.setAllowsTemplate(false);
        tagDescriptor12.setLabel("@docRoot");
        arrayList.add(tagDescriptor12);
        TagDescriptor tagDescriptor13 = new TagDescriptor("@inheritDoc", 12, 1);
        tagDescriptor13.setCustom(false);
        tagDescriptor13.setAllowDuplicates(true);
        tagDescriptor13.setRequired(false);
        tagDescriptor13.setAllowsTemplate(false);
        tagDescriptor13.setLabel("@inheritDoc");
        arrayList.add(tagDescriptor13);
        TagDescriptor tagDescriptor14 = new TagDescriptor("@link", 15, 1);
        tagDescriptor14.setCustom(false);
        tagDescriptor14.setAllowDuplicates(true);
        tagDescriptor14.setRequired(false);
        tagDescriptor14.setAllowsTemplate(false);
        tagDescriptor14.setLabel("@link");
        arrayList.add(tagDescriptor14);
        TagDescriptor tagDescriptor15 = new TagDescriptor("@linkplain", 15, 1);
        tagDescriptor15.setCustom(false);
        tagDescriptor15.setAllowDuplicates(true);
        tagDescriptor15.setRequired(false);
        tagDescriptor15.setAllowsTemplate(false);
        tagDescriptor15.setLabel("@linkplain");
        arrayList.add(tagDescriptor15);
        TagDescriptor tagDescriptor16 = new TagDescriptor("@value", 2, 1);
        tagDescriptor16.setCustom(false);
        tagDescriptor16.setAllowDuplicates(true);
        tagDescriptor16.setRequired(false);
        tagDescriptor16.setAllowsTemplate(false);
        tagDescriptor16.setLabel("@value");
        arrayList.add(tagDescriptor16);
        _inlineTags = new TagDescriptor[arrayList.size()];
        arrayList.toArray(_inlineTags);
    }

    public TagDescriptor findTagDescriptorByName(TagDescriptor tagDescriptor, TagDescriptor[] tagDescriptorArray) {
        int n = 0;
        while (n < tagDescriptorArray.length) {
            TagDescriptor tagDescriptor2 = tagDescriptorArray[n];
            if (tagDescriptor.tagNamesAreEqual(tagDescriptor2)) {
                return tagDescriptor2;
            }
            ++n;
        }
        return null;
    }

    public TagDescriptor[] getAllTags() {
        this.getSettings();
        this.refreshAllTagsList();
        TagDescriptor[] tagDescriptorArray = new TagDescriptor[_allTagsList.size()];
        _allTagsList.toArray(tagDescriptorArray);
        return tagDescriptorArray;
    }

    public TagDescriptor[] getInlneTags() {
        return _inlineTags;
    }

    public ArrayList getTags(int n) {
        this.getSettings();
        this.refreshAllTagsList();
        int n2 = _allTagsList.size();
        ArrayList<TagDescriptor> arrayList = new ArrayList<TagDescriptor>();
        int n3 = 0;
        while (n3 < n2) {
            TagDescriptor tagDescriptor = (TagDescriptor)_allTagsList.get(n3);
            if ((tagDescriptor.getScope() & n) > 0) {
                arrayList.add(tagDescriptor);
            }
            ++n3;
        }
        return arrayList;
    }

    public ArrayList getInlineTags(int n) {
        ArrayList<TagDescriptor> arrayList = new ArrayList<TagDescriptor>();
        int n2 = 0;
        while (n2 < _inlineTags.length) {
            TagDescriptor tagDescriptor = _inlineTags[n2];
            if ((tagDescriptor.getScope() & n) > 0) {
                arrayList.add(tagDescriptor);
            }
            ++n2;
        }
        return arrayList;
    }

    private void refreshAllTagsList() {
        _allTagsList = (ArrayList)_settings.getTagList();
        if (_allTagsList.size() == 0 || _allTagsList.get(0) == null) {
            _allTagsList = new ArrayList();
            this.addBuiltInTagsToList(_allTagsList);
            _settings.setTagList(_allTagsList);
        } else {
            for (TagDescriptor tagDescriptor : _allTagsList) {
                if (tagDescriptor.getName().startsWith("@")) continue;
                tagDescriptor.setName("@" + tagDescriptor.getName());
            }
        }
    }

    private void addBuiltInTagsToList(ArrayList arrayList) {
        TagDescriptor[] tagDescriptorArray = new TagDescriptor[arrayList.size()];
        arrayList.toArray(tagDescriptorArray);
        int n = 0;
        while (n < _standaloneTags.length) {
            TagDescriptor tagDescriptor = _standaloneTags[n];
            TagDescriptor tagDescriptor2 = this.findTagDescriptorByName(tagDescriptor, tagDescriptorArray);
            if (tagDescriptor2 == null) {
                arrayList.add(tagDescriptor);
            }
            ++n;
        }
    }

    public JavadocSettings getSettings() {
        if (_settings == null) {
            this.initializeSettings();
        }
        return _settings;
    }

    private void initializeSettings() {
        _settings = (JavadocSettings)Ide.getSettings().getData("JavadocSettings");
        if (_settings == null || _settings.getTagList().size() == 0) {
            _settings = new JavadocSettings();
            this.refreshAllTagsList();
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            clientSetting.putData("JavadocSettings", (Copyable)_settings);
        }
    }

    public static TagManager getInstance() {
        if (_singleton == null) {
            _singleton = new TagManager();
        }
        return _singleton;
    }
}

