/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.NodeObserver;

public abstract class AbstractDerivedLibrary
extends AbstractLibrary
implements Observer,
SubDirtyable,
DerivedLibrary {
    private Dirtyable _owner;
    private URL _sourceURL;
    private URL _sourceOwnerURL;
    private WeakReference _sourceRef;
    private WeakReference _sourceOwnerRef;

    public String getName() throws TransientMarker {
        return URLFileSystem.getFileName((URL)this.getSourceURL());
    }

    public Element getSource() {
        if (this._sourceRef != null && this._sourceRef.get() != null) {
            return (Element)this._sourceRef.get();
        }
        if (this._sourceURL == null) {
            return null;
        }
        this._sourceRef = new WeakReference<Node>(this.createNode(this._sourceURL));
        return (Element)this._sourceRef.get();
    }

    public Folder getSourceOwner() {
        if (this._sourceOwnerRef != null && this._sourceOwnerRef.get() != null) {
            return (Folder)this._sourceOwnerRef.get();
        }
        if (this._sourceOwnerURL == null) {
            return null;
        }
        this._sourceOwnerRef = new WeakReference<Node>(this.createNode(this._sourceOwnerURL));
        return (Folder)this._sourceOwnerRef.get();
    }

    public URL getSourceURL() {
        Node node;
        if (this._sourceRef != null && this._sourceRef.get() != null && (node = (Node)this._sourceRef.get()) != null) {
            this._sourceURL = node.getURL();
        }
        return this._sourceURL;
    }

    public void setSourceURL(URL uRL) {
        this._sourceURL = uRL;
        this.cacheMe();
    }

    public URL getSourceOwnerURL() {
        Node node;
        if (this._sourceOwnerRef != null && this._sourceOwnerRef.get() != null && (node = (Node)this._sourceOwnerRef.get()) != null) {
            this._sourceOwnerURL = node.getURL();
        }
        return this._sourceOwnerURL;
    }

    public void setSourceOwnerURL(URL uRL) {
        this._sourceOwnerURL = uRL;
        this.cacheMe();
    }

    public void setOwner(Dirtyable dirtyable) {
        this._owner = dirtyable;
    }

    public void markDirty(boolean bl) {
        if (this._owner != null) {
            this._owner.markDirty(bl);
        }
    }

    public boolean isDirty() {
        return this._owner != null ? this._owner.isDirty() : false;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((AbstractDerivedLibrary)object);
    }

    protected final boolean equalsImpl(AbstractDerivedLibrary abstractDerivedLibrary) {
        return super.equalsImpl(abstractDerivedLibrary) && ModelUtil.areEqual((Object)this.getSourceURL(), (Object)abstractDerivedLibrary.getSourceURL()) && ModelUtil.areEqual((Object)this.getSourceOwnerURL(), (Object)abstractDerivedLibrary.getSourceOwnerURL());
    }

    protected final void copyToImpl(AbstractDerivedLibrary abstractDerivedLibrary) {
        super.copyToImpl(abstractDerivedLibrary);
    }

    protected void checkPropertyChange(String string, String string2, UpdateMessage updateMessage, List list) {
        PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)updateMessage.getProperty(string);
        if (propertyChangeEvent != null) {
            list.add(new PropertyChangeEvent(this, string2, null, null));
        }
    }

    protected void firePropertiesChanged(List list) {
        int n = list.size();
        if (n > 0) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.PROPERTY_SET, (Object)JLibraryManager.getInstance());
            boolean bl = false;
            for (PropertyChangeEvent propertyChangeEvent : list) {
                String string = propertyChangeEvent.getPropertyName();
                if (string != null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (PropertyChangeEvent propertyChangeEvent : list) {
                    String string = propertyChangeEvent.getPropertyName();
                    updateMessage.setProperty(string, (Object)propertyChangeEvent);
                }
            }
            JLibraryManager.getInstance().notifyObservers(this, updateMessage);
        }
    }

    protected boolean isPropertyChange(UpdateMessage updateMessage) {
        return updateMessage.getMessageID() == UpdateMessage.PROPERTY_SET;
    }

    private Node createNode(URL uRL) {
        if (uRL != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                new NodeObserver(node, this);
                Node node2 = node;
                return node2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void cacheMe() {
        if (this._sourceURL != null) {
            JLibraryManager.cacheDerivedLibrary(this);
        }
    }
}

