/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.resource.LibraryArb;

public class AddinJDK
extends AbstractLibrary
implements JDK {
    private String _name;
    private URLPath _clsPath;
    private URLPath _srcPath;
    private URLPath _docPath;
    private URL _exeURL;
    private VersionNumber _version;
    private URL _sdkBinDir;
    private String[] _VMs;

    public AddinJDK(String string, URLPath uRLPath, URLPath uRLPath2, URLPath uRLPath3, URL uRL, VersionNumber versionNumber, URL uRL2) {
        this._name = string;
        this._clsPath = new URLPath(uRLPath);
        this._srcPath = new URLPath(uRLPath2);
        this._docPath = new URLPath(uRLPath3);
        this._exeURL = uRL;
        this._version = versionNumber;
        this._sdkBinDir = uRL2;
    }

    public String getName() {
        return this._name;
    }

    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    public URL getJavaExecutable() {
        return this._exeURL;
    }

    public void setJavaExecutable(URL uRL) {
    }

    public String[] getInstalledVMs() {
        URL uRL;
        if (this._VMs == null && (uRL = this.getSDKBinDir()) != null) {
            this._VMs = JDKUtil.getVMChoices(uRL, false);
        }
        return this._VMs != null ? this._VMs : new String[]{};
    }

    public void setInstalledVMs(String[] stringArray) {
    }

    public VersionNumber getJavaVersion() {
        return this._version;
    }

    public void setJavaVersion(VersionNumber versionNumber) {
    }

    public URL getSDKBinDir() {
        return this._sdkBinDir;
    }

    public void setSDKBinDir(URL uRL) {
    }

    public String getSDKBinJavaExecutableNoConsole() {
        URL uRL = this.getSDKBinDir();
        if (uRL != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }

    public String getJavaExecutableNoConsole() {
        URL uRL = this.getJavaExecutable();
        if (uRL != null && (uRL = URLFileSystem.getParent((URL)uRL)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }

    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(5);
    }
}

