/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.DataNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.LibraryArb;

public abstract class ExternalLibrary
extends DataNode
implements Library {
    private String _name;
    private URLPath _clsPath;
    private URLPath _srcPath;
    private URLPath _docPath;
    private boolean _isLocked;

    public ExternalLibrary() {
    }

    public ExternalLibrary(URL uRL) {
        super(uRL);
    }

    protected abstract String getExtension();

    public URLPath getDefaultClassPath() throws TransientMarker {
        return this.getClassPath();
    }

    public void setDefaultClassPath(URLPath uRLPath) {
        this.setClassPath(uRLPath);
    }

    public URLPath getDefaultSourcePath() throws TransientMarker {
        return this.getSourcePath();
    }

    public void setDefaultSourcePath(URLPath uRLPath) {
        this.setSourcePath(uRLPath);
    }

    public URLPath getDefaultDocPath() throws TransientMarker {
        return this.getDocPath();
    }

    public void setDefaultDocPath(URLPath uRLPath) {
        this.setDocPath(uRLPath);
    }

    public URLPath getClassPath() {
        return this.ensureOpen() ? this._clsPath : new URLPath();
    }

    public void setClassPath(URLPath uRLPath) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)uRLPath, (Object)this._clsPath)) {
            this._clsPath = uRLPath;
            this.markDirty(true);
        }
    }

    public URLPath getSourcePath() {
        return this.ensureOpen() ? this._srcPath : new URLPath();
    }

    public void setSourcePath(URLPath uRLPath) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)uRLPath, (Object)this._srcPath)) {
            this._srcPath = uRLPath;
            this.markDirty(true);
        }
    }

    public URLPath getDocPath() {
        return this.ensureOpen() ? this._docPath : new URLPath();
    }

    public void setDocPath(URLPath uRLPath) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)uRLPath, (Object)this._docPath)) {
            this._docPath = uRLPath;
            this.markDirty(true);
        }
    }

    public boolean isLocked() {
        return this.ensureOpen() ? this._isLocked : true;
    }

    public void setLocked(boolean bl) {
        if (this.ensureOpen() && bl != this._isLocked) {
            this._isLocked = bl;
            this.markDirty(true);
        }
    }

    public String getName() {
        String string;
        if (this._name != null) {
            return this._name;
        }
        String string2 = URLFileSystem.getFileName((URL)this.getURL());
        if (string2.endsWith(string = this.getExtension())) {
            return string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public void setName(String string) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)string, (Object)this._name)) {
            this._name = string;
            this.markDirty(true);
        }
    }

    public Object getID() {
        return this.getURL();
    }

    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    public void initFromLibrary(Library library) {
        if (library != null) {
            URLPath uRLPath = library.getClassPath();
            if (ModelUtil.areDifferent((Object)uRLPath, (Object)this.getClassPath())) {
                this.setClassPath(uRLPath);
            }
            if (ModelUtil.areDifferent((Object)(uRLPath = library.getSourcePath()), (Object)this.getSourcePath())) {
                this.setSourcePath(uRLPath);
            }
            if (ModelUtil.areDifferent((Object)(uRLPath = library.getDocPath()), (Object)this.getDocPath())) {
                this.setDocPath(uRLPath);
            }
            if (library.isLocked() != this.isLocked()) {
                this.setLocked(library.isLocked());
            }
        }
    }

    public String getShortLabel() {
        return this.getName();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(4);
    }

    public String toString() {
        return this.getShortLabel();
    }
}

