/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.ToStringManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;

public final class JDKAdapter
extends LibraryAdapter
implements JDK {
    private transient String[] _vms;

    public JDKAdapter(HashStructure hashStructure) {
        super(hashStructure);
    }

    public boolean equivalent(Library library) {
        JDK jDK;
        JDK jDK2 = jDK = library instanceof JDK ? (JDK)library : null;
        if (!super.equivalent(jDK)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jDK.getJavaExecutable(), (Object)this.getJavaExecutable())) {
            return false;
        }
        if (!Arrays.equals(jDK.getInstalledVMs(), this.getInstalledVMs())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jDK.getJavaVersion(), (Object)this.getJavaVersion())) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jDK.getSDKBinDir(), (Object)this.getSDKBinDir());
    }

    public void initFromLibrary(Library library) {
        if (library instanceof JDK) {
            super.initFromLibrary(library);
            JDK jDK = (JDK)library;
            URL uRL = jDK.getJavaExecutable();
            Object[] objectArray = jDK.getInstalledVMs();
            VersionNumber versionNumber = jDK.getJavaVersion();
            URL uRL2 = jDK.getSDKBinDir();
            if (ModelUtil.areDifferent((Object)uRL, (Object)this.getJavaExecutable())) {
                this.setJavaExecutable(uRL);
            }
            if (!Arrays.equals(objectArray, this.getInstalledVMs())) {
                this.setInstalledVMs((String[])objectArray);
            }
            if (ModelUtil.areDifferent((Object)versionNumber, (Object)this.getJavaVersion())) {
                this.setJavaVersion(versionNumber);
            }
            if (ModelUtil.areDifferent((Object)uRL2, (Object)this.getSDKBinDir())) {
                this.setSDKBinDir(uRL2);
            }
        }
    }

    public URL getJavaExecutable() {
        return this._hash.getURL("javaExecutable");
    }

    public void setJavaExecutable(URL uRL) {
        if (uRL == null) {
            this._hash.remove("javaExecutable");
        } else {
            this._hash.putURL("javaExecutable", uRL);
        }
    }

    public synchronized String[] getInstalledVMs() {
        if (this._vms == null && this.getSDKBinDir() != null) {
            this._vms = JDKUtil.getVMChoices(this.getSDKBinDir(), false);
        }
        return this._vms != null ? this._vms : new String[]{};
    }

    public synchronized void setInstalledVMs(String[] stringArray) {
        this._vms = stringArray;
    }

    public VersionNumber getJavaVersion() {
        String string = this._hash.getString("version");
        if (string != null) {
            try {
                VersionNumber versionNumber = (VersionNumber)ToStringManager.fromString((String)string, VersionNumber.class);
                return versionNumber;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setJavaVersion(VersionNumber versionNumber) {
        if (versionNumber == null) {
            this._hash.remove("version");
        } else {
            try {
                this._hash.putString("version", ToStringManager.toString((Object)versionNumber, VersionNumber.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public URL getSDKBinDir() {
        return this._hash.getURL("sdkBinDir");
    }

    public void setSDKBinDir(URL uRL) {
        if (uRL == null) {
            this._hash.remove("sdkBinDir");
        } else {
            this._hash.putURL("sdkBinDir", uRL);
        }
    }

    public String getSDKBinJavaExecutableNoConsole() {
        URL uRL = this.getSDKBinDir();
        if (uRL != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }

    public String getJavaExecutableNoConsole() {
        URL uRL = this.getJavaExecutable();
        if (uRL != null && (uRL = URLFileSystem.getParent((URL)uRL)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }
}

