/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.XMLRecognizer;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;

public class JDKNode
extends ExternalLibrary
implements JDK {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jdknode");
    public static final String ROOT_TAG = "JDKNode";
    private URL _javaExe;
    private String[] _VMs;
    private VersionNumber _version;
    private URL _binDir;

    static {
        Object2Dom.registerNamespaceElem(JDKNode.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
        XMLRecognizer.mapRootElementToClass((String)ROOT_TAG, JDKNode.class);
    }

    public JDKNode() {
    }

    public JDKNode(URL uRL) {
        super(uRL);
    }

    public boolean equivalent(Library library) {
        JDK jDK;
        JDK jDK2 = jDK = library instanceof JDK ? (JDK)library : null;
        if (!super.equivalent(jDK)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jDK.getJavaExecutable(), (Object)this.getJavaExecutable())) {
            return false;
        }
        if (!Arrays.equals(jDK.getInstalledVMs(), this.getInstalledVMs())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jDK.getJavaVersion(), (Object)this.getJavaVersion())) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jDK.getSDKBinDir(), (Object)this.getSDKBinDir());
    }

    public void initFromLibrary(Library library) {
        if (library instanceof JDK) {
            super.initFromLibrary(library);
            JDK jDK = (JDK)library;
            URL uRL = jDK.getJavaExecutable();
            Object[] objectArray = jDK.getInstalledVMs();
            VersionNumber versionNumber = jDK.getJavaVersion();
            URL uRL2 = jDK.getSDKBinDir();
            if (ModelUtil.areDifferent((Object)uRL, (Object)this.getJavaExecutable())) {
                this.setJavaExecutable(uRL);
            }
            if (!Arrays.equals(objectArray, this.getInstalledVMs())) {
                this.setInstalledVMs((String[])objectArray);
            }
            if (ModelUtil.areDifferent((Object)versionNumber, (Object)this.getJavaVersion())) {
                this.setJavaVersion(versionNumber);
            }
            if (ModelUtil.areDifferent((Object)uRL2, (Object)this.getSDKBinDir())) {
                this.setSDKBinDir(uRL2);
            }
        }
    }

    public URL getJavaExecutable() {
        return this.ensureOpen() ? this._javaExe : null;
    }

    public void setJavaExecutable(URL uRL) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)uRL, (Object)this._javaExe)) {
            this._javaExe = uRL;
            this.markDirty(true);
        }
    }

    public String[] getInstalledVMs() throws TransientMarker {
        URL uRL;
        if (this.ensureOpen() && this._VMs == null && (uRL = this.getSDKBinDir()) != null) {
            this._VMs = JDKUtil.getVMChoices(uRL, false);
        }
        return this._VMs != null ? this._VMs : new String[]{};
    }

    public void setInstalledVMs(String[] stringArray) {
        if (this.ensureOpen() && !Arrays.equals(stringArray, this._VMs)) {
            this._VMs = stringArray;
            this.markDirty(true);
        }
    }

    public VersionNumber getJavaVersion() {
        return this.ensureOpen() ? this._version : null;
    }

    public void setJavaVersion(VersionNumber versionNumber) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)versionNumber, (Object)this._version)) {
            this._version = versionNumber;
            this.markDirty(true);
        }
    }

    public URL getSDKBinDir() {
        return this.ensureOpen() ? this._binDir : null;
    }

    public void setSDKBinDir(URL uRL) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)uRL, (Object)this._binDir)) {
            this._binDir = uRL;
            this.markDirty(true);
        }
    }

    public String getSDKBinJavaExecutableNoConsole() {
        URL uRL = this.getSDKBinDir();
        if (uRL != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }

    public String getJavaExecutableNoConsole() {
        URL uRL = this.getJavaExecutable();
        if (uRL != null && (uRL = URLFileSystem.getParent((URL)uRL)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(uRL);
        }
        return null;
    }

    protected String getExtension() {
        return ".jdk";
    }
}

