/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.JdkIntrospector;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.resource.ControlsArb;

public final class JDKUtil {
    private static final String SUN_HOST = "java.sun.com";
    private static final String BASE_1_2_PATH = "/products/jdk/1.2/docs/api/";
    private static final URL BASE_1_2_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/products/jdk/1.2/docs/api/", null, null);
    private static final String BASE_1_3_PATH = "/j2se/1.3/docs/api/";
    private static final URL BASE_1_3_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.3/docs/api/", null, null);
    private static final String BASE_1_4_PATH = "/j2se/1.4/docs/api/";
    private static final URL BASE_1_4_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.4/docs/api/", null, null);
    private static final String BASE_1_5_PATH = "/j2se/1.5/docs/api/";
    private static final URL BASE_1_5_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.5/docs/api/", null, null);
    private static final String CFG_FILE = "jvm.cfg";

    public static boolean initJDK(JDK jDK, URL uRL) {
        String string = null;
        String string2 = null;
        String string3 = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        if (jDK != null && new JDKExeFilter().accept(uRL)) {
            try {
                try {
                    URL uRL2 = URLFileSystem.getParent((URL)uRL);
                    URL uRL3 = JDKUtil.getJavaExecutableNoConsole(uRL2);
                    URL[] uRLArray = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
                    URLPath uRLPath = new URLPath(uRLArray);
                    String string4 = JdkIntrospector.class.getName();
                    if (!JDKUtil._pathValid(uRL3, uRLPath, string4)) {
                        boolean bl = false;
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return bl;
                    }
                    String[] stringArray = new String[]{URLFileSystem.getPlatformPathName((URL)uRL3), "-classpath", uRLPath.toString(), string4};
                    Process process = Runtime.getRuntime().exec(stringArray);
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    inputStreamReader = new InputStreamReader(process.getErrorStream());
                    while (true) {
                        if (inputStreamReader.ready()) {
                            char[] cArray = new char[256];
                            int n = inputStreamReader.read(cArray);
                            if (n <= 0) continue;
                        }
                        String string5 = bufferedReader.readLine();
                        if (string5 == null) break;
                        if (string5.equals(".")) {
                            break;
                        }
                        int n = string5.indexOf(9);
                        if (n == -1) {
                            break;
                        }
                        String string6 = string5.substring(0, n);
                        String string7 = string5.substring(n + 1);
                        if ("java.version".equals(string6)) {
                            string = string7;
                            continue;
                        }
                        if ("java.home".equals(string6)) {
                            string3 = string7;
                            continue;
                        }
                        if (!"sun.boot.class.path".equals(string6)) continue;
                        string2 = string7;
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (string != null && string2 != null && string3 != null) {
            JDKUtil.initJDK(jDK, uRL, string, string2, string3);
            return true;
        }
        return false;
    }

    public static void initJDK(JDK jDK, URL uRL, String string, String string2, String string3) {
        VersionNumber versionNumber = new VersionNumber(string);
        jDK.setJavaVersion(versionNumber);
        jDK.setJavaExecutable(uRL);
        jDK.setClassPath(URLPath.newURLPathFromString((String)string2));
        URL uRL2 = URLFactory.newDirURL((String)string3);
        URL uRL3 = URLFileSystem.getParent((URL)uRL2);
        URL uRL4 = URLFactory.newDirURL((URL)uRL3, (String)"jre");
        if (!URLFileSystem.exists((URL)uRL4)) {
            uRL3 = uRL2;
        }
        URLPath uRLPath = new URLPath();
        URL uRL5 = JDKUtil._getSrcURL(uRL3);
        if (uRL5 != null) {
            uRLPath.add(uRL5);
        }
        jDK.setSourcePath(uRLPath);
        URLPath uRLPath2 = new URLPath();
        if (versionNumber.isBefore(new VersionNumber("1.3"), false)) {
            uRLPath2.add(BASE_1_2_URL);
        } else if (versionNumber.isBefore(new VersionNumber("1.4"), false)) {
            uRLPath2.add(BASE_1_3_URL);
        } else if (versionNumber.isBefore(new VersionNumber("1.5"), false)) {
            uRLPath2.add(BASE_1_4_URL);
        } else {
            uRLPath2.add(BASE_1_5_URL);
        }
        jDK.setDocPath(uRLPath2);
        if (uRL2 != null) {
            URL uRL6 = URLFileSystem.getParent((URL)uRL2);
            URL uRL7 = URLFactory.newDirURL((URL)uRL6, (String)"bin");
            if (!URLFileSystem.exists((URL)uRL7)) {
                uRL7 = URLFactory.newDirURL((URL)uRL2, (String)"bin");
            }
            jDK.setSDKBinDir(uRL7);
            JDKUtil.updateOjvm(jDK, false);
        }
    }

    private static boolean _pathValid(URL uRL, URLPath uRLPath, String string) {
        return URLFileSystem.exists((URL)uRL) && URLFileSystem.isRegularFile((URL)uRL) && uRLPath.toQualifiedURL(string.replace('.', '/') + ".class") != null;
    }

    private static URL _getSrcURL(URL uRL) {
        String[] stringArray = new String[]{"src.jar", "src.zip"};
        String[] stringArray2 = new String[]{"src/", ""};
        int n = 0;
        while (n < stringArray.length) {
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)stringArray[n]);
            if (URLFileSystem.exists((URL)uRL2)) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    URL uRL3 = URLFactory.newJarURL((URL)uRL2, (String)stringArray2[n2]);
                    if (URLFileSystem.exists((URL)URLFactory.newURL((URL)uRL3, (String)"java/lang/Object.java"))) {
                        return uRL3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    private static URL _checkLocation(URL uRL) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)CFG_FILE);
        return uRL2 != null && URLFileSystem.exists((URL)uRL2) ? uRL2 : null;
    }

    private static URL _findJvmCfg(URL uRL) {
        URL uRL2 = JDKUtil._checkLocation(uRL);
        if (uRL2 != null) {
            return uRL2;
        }
        String string = System.getProperty("os.arch");
        if ("x86".equals(string)) {
            string = "i386";
        }
        if ((uRL2 = JDKUtil._checkLocation(URLFactory.newDirURL((URL)uRL, (String)string))) != null) {
            return uRL2;
        }
        return JDKUtil._checkChildren(uRL);
    }

    private static URL _checkChildren(URL uRL) {
        URL[] uRLArray = URLFileSystem.list((URL)uRL, (URLFilter)new 2());
        if (uRLArray != null) {
            int n = uRLArray.length - 1;
            while (n >= 0) {
                URL uRL2 = JDKUtil._checkLocation(uRLArray[n]);
                if (uRL2 != null) {
                    return uRL2;
                }
                uRL2 = JDKUtil._checkChildren(uRLArray[n]);
                if (uRL2 != null) {
                    return uRL2;
                }
                --n;
            }
        }
        return null;
    }

    public static String[] getVMChoices(URL uRL, boolean bl) {
        URL uRL2;
        URL uRL3 = URLFileSystem.getParent((URL)uRL);
        URL uRL4 = URLFactory.newDirURL((URL)uRL3, (String)"jre");
        if (!URLFileSystem.exists((URL)uRL4)) {
            uRL4 = uRL3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL5 = URLFactory.newURL((URL)uRL4, (String)"lib/");
        if (uRL5 == null) {
            uRL5 = uRL4;
        }
        if ((uRL2 = JDKUtil._findJvmCfg(uRL5)) != null) {
            boolean bl2 = false;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL2.openStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("#")) continue;
                        String string2 = null;
                        String string3 = null;
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            if (stringTokenizer.hasMoreTokens()) {
                                string3 = stringTokenizer.nextToken();
                            }
                        }
                        if (string2 == null || string3 != null && !string3.equalsIgnoreCase("KNOWN") && !string3.equalsIgnoreCase("ALIASED_TO")) continue;
                        if (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                        }
                        arrayList.add(string2);
                        bl2 |= string2.equals("ojvm");
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (!bl2 && bl) {
                try {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(new File(uRL2.getPath()), true));
                    printWriter.println("-ojvm KNOWN");
                    printWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                arrayList.add("ojvm");
            }
        } else {
            URL[] uRLArray;
            URL uRL6 = URLFactory.newDirURL((URL)uRL4, (String)"bin");
            if (URLFileSystem.exists((URL)uRL6) && (uRLArray = URLFileSystem.list((URL)uRL6, (URLFilter)new 1())) != null) {
                int n = 0;
                while (n < uRLArray.length) {
                    String string = URLFileSystem.getFileName((URL)uRLArray[n]);
                    arrayList.add(string);
                    ++n;
                }
                int n2 = arrayList.indexOf("ojvm");
                if (n2 != -1) {
                    Object e = arrayList.remove(n2);
                    arrayList.add(0, (String)e);
                } else {
                    n2 = arrayList.indexOf("classic");
                    if (n2 != -1) {
                        Object e = arrayList.remove(n2);
                        arrayList.add(0, (String)e);
                    }
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    static URL getJavaExecutableNoConsole(URL uRL) {
        String[] stringArray = new String[]{"javaw.exe", "javaw", "java.exe", "java"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)stringArray[n2]);
            if (URLFileSystem.exists((URL)uRL2)) {
                return uRL2;
            }
            ++n2;
        }
        return null;
    }

    static String getJavaExecutableNoConsolePath(URL uRL) {
        URL uRL2 = JDKUtil.getJavaExecutableNoConsole(uRL);
        return uRL2 != null ? URLFileSystem.getPlatformPathName((URL)uRL2) : "java";
    }

    public static boolean updateOjvm(JDK jDK, boolean bl) {
        boolean bl2 = false;
        if (Ide.isStarting()) {
            Ide.addIdeListener((IdeListener)new DeferredUpdate(jDK, bl));
        } else {
            bl2 = JDKUtil.updateOjvmWithConfig(jDK, bl);
        }
        return bl2;
    }

    private static boolean updateOjvmWithConfig(JDK jDK, boolean bl) {
        boolean bl2 = JDKUtil.updateOjvmImpl(jDK, bl);
        if (jDK.getSDKBinDir() != null) {
            jDK.setInstalledVMs(JDKUtil.getVMChoices(jDK.getSDKBinDir(), bl2));
        }
        return bl2;
    }

    private static boolean updateOjvmImpl(JDK jDK, boolean bl) {
        URL uRL = jDK.getJavaExecutable();
        if (uRL == null || !uRL.getPath().toLowerCase().endsWith(".exe")) {
            return false;
        }
        if (!Ide.getIdeArgs().getCreateUI()) {
            return false;
        }
        File file = new File(Ide.getSystemDirectory() + File.separator + "cache" + File.separator + "ojvmInstallations.properties");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
                String string = properties.getProperty(uRL.getPath());
                if (string != null && !bl) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File file2 = JDKUtil.getOjvmSourceDir();
        File file3 = JDKUtil.getOjvmTargetDir(jDK);
        if (file2 == null || file3 == null) {
            return false;
        }
        boolean bl3 = false;
        if (!(file3.equals(file2) || file3.exists() && JDKUtil.ojvmDirUptodate(file2, file3))) {
            int n = 0;
            if (!bl && !JDKUtil.ojvmInUse(file3)) {
                String string = new File(jDK.getJavaExecutable().getPath()).getParentFile().getParent();
                int n2 = file3.exists() ? 74 : 73;
                n = JOptionPane.showConfirmDialog(SwingUtils.getToplevelWindow(), ControlsArb.format(n2, string), ControlsArb.getString(75), 0, 3);
            }
            switch (n) {
                case 0: {
                    if (JDKUtil.ojvmInUse(file3)) {
                        if (bl) {
                            JOptionPane.showMessageDialog(SwingUtils.getToplevelWindow(), "Unable to install OJVM, already in use by JDeveloper itself", ControlsArb.getString(75), 0);
                        }
                    } else {
                        File[] fileArray = new File[]{null};
                        bl3 = JDKUtil.copyOjvm(file2, file3, fileArray);
                        if (!bl3) {
                            String string = fileArray[0] != null ? ControlsArb.format(80, fileArray[0].getPath()) : ControlsArb.getString(76);
                            JOptionPane.showMessageDialog(SwingUtils.getToplevelWindow(), string, ControlsArb.getString(75), 0);
                        }
                    }
                    properties.setProperty(uRL.getPath(), "installed");
                    break;
                }
                case -1: 
                case 1: {
                    properties.setProperty(uRL.getPath(), "not installed");
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        try {
            File file4 = file.getParentFile();
            if (!file4.isDirectory()) {
                file4.mkdirs();
            }
            properties.store(new FileOutputStream(file), "JDeveloper internal file -- don't modify");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl3;
    }

    private static File getOjvmSourceDir() {
        if (File.separatorChar == '/') {
            return null;
        }
        File file = new File(Ide.getHomeDirectory() + File.separator + "ojvm/win32");
        if (!file.isDirectory()) {
            file = new File(Ide.getOracleHomeDirectory() + File.separator + "jdk/jre/bin/ojvm");
        }
        if (!file.isDirectory()) {
            return null;
        }
        return file;
    }

    private static File getOjvmTargetDir(JDK jDK) {
        if (File.separatorChar == '/') {
            return null;
        }
        URL uRL = jDK.getJavaExecutable();
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getPath()).getParentFile().getParentFile();
        if (!(file = new File(file, "jre/bin")).isDirectory()) {
            file = new File(uRL.getPath()).getParentFile();
        }
        if (!file.isDirectory() || !new File(file, "client").isDirectory()) {
            return null;
        }
        return new File(file, "ojvm");
    }

    public static boolean ojvmUptodate(JDK jDK) {
        File file = JDKUtil.getOjvmSourceDir();
        File file2 = JDKUtil.getOjvmTargetDir(jDK);
        return file != null && file2 != null && file2.isDirectory() && JDKUtil.ojvmDirUptodate(file, file2);
    }

    private static boolean ojvmDirUptodate(File file, File file2) {
        File file3 = new File(file, "version.txt");
        File file4 = new File(file2, "version.txt");
        return file3.exists() && file4.exists() && JDKUtil.compareFile(file3, file4);
    }

    private static boolean copyOjvm(File file, File file2, File[] fileArray) {
        if (!file2.isDirectory() && !file2.mkdir()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!JDKUtil.copyFile(stringArray[n], file, file2, fileArray)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private static boolean copyFile(String string, File file, File file2, File[] fileArray) {
        try {
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            if (file4.exists() && !file4.canWrite() && !file4.delete()) {
                fileArray[0] = file4;
                boolean bl = false;
                return bl;
            }
            long l = file3.length();
            byte[] byArray = JDKUtil.readFile(file3);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            file4.setLastModified(file3.lastModified());
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private static boolean compareFile(File file, File file2) {
        try {
            byte[] byArray;
            if (!file.canRead() || !file2.canRead()) {
                boolean bl = false;
                return bl;
            }
            byte[] byArray2 = JDKUtil.readFile(file);
            if (byArray2.length != (byArray = JDKUtil.readFile(file2)).length) {
                boolean bl = false;
                return bl;
            }
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] != byArray[n]) {
                    boolean bl = false;
                    return bl;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private static byte[] readFile(File file) throws IOException {
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            if ((long)fileInputStream.read(byArray) != l) {
                throw new IOException();
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return byArray;
    }

    private static boolean ojvmInUse(File file) {
        String string;
        String string2 = System.getProperty("java.vm.name");
        if (string2 != null && string2.startsWith("OJVM") && (string = System.getProperty("java.home")) != null) {
            try {
                String string3 = file.getCanonicalPath();
                String string4 = new File(string).getCanonicalPath();
                boolean bl = string3.startsWith(string4);
                return bl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean maS$updateOjvmWithConfig(JDK jDK, boolean bl) {
        return JDKUtil.updateOjvmWithConfig(jDK, bl);
    }

    public static class JDKExeFilter
    implements URLFilter {
        public boolean accept(URL uRL) {
            String string;
            boolean bl = false;
            if (uRL != null && "file".equals(uRL.getProtocol()) && URLFileSystem.isRegularFile((URL)uRL) && (string = URLFileSystem.getFileName((URL)uRL)) != null) {
                bl = (string = string.toLowerCase()).equals("java") || string.equals("java.exe");
            }
            return bl;
        }

        public boolean equals(Object object) {
            return object instanceof JDKExeFilter;
        }

        public String toString() {
            return ControlsArb.getString(53);
        }
    }

    public static final class 2
    implements URLFilter {
        public boolean accept(URL uRL) {
            return URLFileSystem.isDirectory((URL)uRL);
        }
    }

    public static final class 1
    implements URLFilter {
        public boolean accept(URL uRL) {
            return URLFileSystem.isDirectory((URL)uRL) && URLFileSystem.exists((URL)URLFactory.newURL((URL)uRL, (String)"jvm.dll"));
        }
    }

    private static class DeferredUpdate
    implements IdeListener {
        JDK jdk;
        boolean forceInstall;

        public DeferredUpdate(JDK jDK, boolean bl) {
            this.jdk = jDK;
            this.forceInstall = bl;
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            JDKUtil.maS$updateOjvmWithConfig(this.jdk, this.forceInstall);
        }

        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }
    }
}

