/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;
import oracle.jdeveloper.resource.LibraryArb;

public class JLibraryAdapter
extends LibraryAdapter
implements JLibrary {
    private transient Icon icon;

    public JLibraryAdapter(HashStructure hashStructure) {
        super(hashStructure);
    }

    public boolean equivalent(Library library) {
        JLibrary jLibrary;
        JLibrary jLibrary2 = jLibrary = library instanceof JLibrary ? (JLibrary)library : null;
        if (!super.equivalent(library)) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jLibrary.getDeployedByDefault(), (Object)this.getDeployedByDefault());
    }

    public void initFromLibrary(Library library) {
        if (library instanceof JLibrary) {
            JLibrary jLibrary = (JLibrary)library;
            Boolean bl = jLibrary.getDeployedByDefault();
            super.initFromLibrary(jLibrary);
            if (ModelUtil.areDifferent((Object)bl, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(bl);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (!this.isLocked()) {
            return LibraryArb.getIcon(6);
        }
        if (URLFileSystem.isDirectory((URL)this.getClassPath().getFirstEntry())) {
            return LibraryArb.getIcon(8);
        }
        return LibraryArb.getIcon(7);
    }

    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._hash.getBoolean("deployedByDefault", false) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDeployedByDefault(Boolean bl) {
        if (bl == null) {
            this._hash.remove("deployedByDefault");
        } else {
            this._hash.putBoolean("deployedByDefault", bl.booleanValue());
        }
    }

    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    public JLibraryDefinition getLibraryDefinition(VersionNumber versionNumber) {
        return this;
    }
}

