/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKNode;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryNode;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.LibraryArb;

public final class JLibraryList
implements Locatable,
MutableLibraryList {
    public static final String SYSTEM_LIBRARIES = LibraryArb.getString(0);
    public static final String USER_LIBRARIES = LibraryArb.getString(1);
    public static final URLFilter JDK_FILTER = new DefaultURLFilter(LibraryArb.getString(10), ".jdk");
    public static final URLFilter LIB_FILTER = new DefaultURLFilter(LibraryArb.getString(9), ".library");
    private URL _url;
    private String _name;

    public JLibraryList(URL uRL) {
        this._url = uRL;
    }

    public JDK findJDK(Object object) {
        URL uRL;
        JDKNode jDKNode = null;
        if (object instanceof URL && (jDKNode = (JDKNode)NodeFactory.find((URL)(uRL = (URL)object))) == null && URLFileSystem.exists((URL)uRL)) {
            try {
                jDKNode = (JDKNode)NodeFactory.findOrCreate((URL)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return jDKNode;
    }

    public JLibrary findLibrary(Object object) {
        URL uRL;
        JLibraryNode jLibraryNode = null;
        if (object instanceof URL && (jLibraryNode = (JLibraryNode)NodeFactory.find((URL)(uRL = (URL)object))) == null && URLFileSystem.exists((URL)uRL)) {
            try {
                jLibraryNode = (JLibraryNode)NodeFactory.findOrCreate((URL)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return jLibraryNode;
    }

    public List getJdkList() {
        ArrayList<JDK> arrayList = new ArrayList<JDK>();
        URL[] uRLArray = URLFileSystem.list((URL)this.getURL(), (URLFilter)JDK_FILTER);
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                JDK jDK = this.findJDK(uRLArray[n]);
                if (jDK != null) {
                    arrayList.add(jDK);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List getLibraryList() {
        ArrayList<JLibrary> arrayList = new ArrayList<JLibrary>();
        URL[] uRLArray = URLFileSystem.list((URL)this.getURL(), (URLFilter)LIB_FILTER);
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                JLibrary jLibrary = this.findLibrary(uRLArray[n]);
                if (jLibrary != null) {
                    arrayList.add(jLibrary);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public String getListName() {
        return this._name != null ? this._name : URLFileSystem.getFileName((URL)this.getURL()) + " (" + URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)this.getURL())) + ")";
    }

    public boolean isTransient() {
        return URLFileSystem.isReadOnly((URL)this.getURL());
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this.getURL());
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(14);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
    }

    public void setJdkList(List list) {
    }

    public void setLibraryList(List list) {
    }

    public void setListName(String string) {
        this._name = string;
    }

    public JDK addJDK(String string, URL uRL, URL uRL2) {
        JDKNode jDKNode = null;
        if (uRL2 != null) {
            try {
                jDKNode = (JDKNode)NodeFactory.find((URL)uRL2);
                if (jDKNode == null) {
                    jDKNode = (JDKNode)NodeFactory.findOrCreate((URL)uRL2);
                }
                jDKNode.setName(string);
                JDKUtil.initJDK(jDKNode, uRL);
                jDKNode.save();
            }
            catch (Exception exception) {
                jDKNode = null;
                exception.printStackTrace();
            }
        }
        return jDKNode;
    }

    public JDK addJDK(String string, URL uRL) {
        URL uRL2 = this.getUniqueURL(string, true);
        return this.addJDK(string, uRL, uRL2);
    }

    public JLibrary addLibrary(String string, URL uRL) {
        JLibraryNode jLibraryNode = null;
        if (uRL != null) {
            try {
                jLibraryNode = (JLibraryNode)NodeFactory.find((URL)uRL);
                if (jLibraryNode == null) {
                    int n;
                    jLibraryNode = (JLibraryNode)NodeFactory.findOrCreate((URL)uRL);
                    if (string == null && (n = (string = URLFileSystem.getFileName((URL)uRL)).lastIndexOf(46)) > 0 && !Character.isUpperCase((string = string.substring(0, n)).charAt(0))) {
                        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                    }
                    jLibraryNode.setName(string);
                    jLibraryNode.save();
                } else {
                    jLibraryNode.setName(string);
                }
            }
            catch (Exception exception) {
                jLibraryNode = null;
                exception.printStackTrace();
            }
        }
        return jLibraryNode;
    }

    public JLibrary addLibrary(String string) {
        URL uRL = this.getUniqueURL(string, false);
        return this.addLibrary(string, uRL);
    }

    public boolean remove(Library library) {
        URL uRL;
        if (library instanceof ExternalLibrary && URLFileSystem.delete((URL)(uRL = ((ExternalLibrary)library).getURL()))) {
            NodeFactory.uncache((URL)uRL);
            return true;
        }
        return false;
    }

    public Object createIDFromName(String string, boolean bl) {
        String string2 = string = string != null ? string.trim() : null;
        if (string != null && string.length() > 0) {
            if (string.indexOf(47) >= 0 || string.indexOf(92) >= 0) {
                return null;
            }
            try {
                URL uRL = URLFactory.newURL((URL)this.getURL(), (String)string);
                String string3 = bl ? ".jdk" : ".library";
                URL uRL2 = uRL = uRL != null ? URLFileSystem.ensureSuffix((URL)uRL, (String)string3) : null;
                if (uRL != null && URLFileSystem.isValid((URL)uRL)) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private URL getUniqueURL(String string, boolean bl) {
        int n = -1;
        if (string == null || string.length() == 0) {
            string = bl ? LibraryArb.getString(10) : LibraryArb.getString(9);
            n = 1;
        }
        String string2 = bl ? ".jdk" : ".library";
        return URLFactory.newUniqueURL((URL)this.getURL(), (NameGenerator)new DefaultNameGenerator(string, string2, n));
    }

    public Icon getDefaultIcon() {
        return LibraryArb.getIcon(4);
    }
}

