/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.library.AddinLibraryList;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.ProjectDependencyFactory;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.library.LibrariesHook;

public final class JLibraryManager
implements DependableRecognizer,
Subject,
ShutdownHook,
Addin {
    public static final String LEGACY_LIBRARY_FILE = "library.ini";
    public static final String LIBRARY_LIST_FILE = "libraries.xml";
    public static final String LIBRARY_EXTENSION = ".library";
    public static final String JDK_EXTENSION = ".jdk";
    public static final int LIBRARY_ADDED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_ADDED");
    public static final int LIBRARY_REMOVED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_REMOVED");
    public static final String SETTINGS_KEY = "LibraryManagerOptions";
    private static final HashMap LISTS = new HashMap();
    private static JLibraryManager _instance;
    private static JLibraryList _userLibs;
    private static AddinLibraryList _addinLibs;
    private static IdeSubject _delegate;
    private static HashMap _dependableRegistry;
    private static JDK _defaultJDK;

    static {
        _delegate = new IdeSubject();
        _dependableRegistry = new HashMap();
        JLibraryManager.registerDerivedLibrary(Project.class, ProjectLibrary.class);
    }

    public JLibraryManager() throws SingletonClassException {
        if (_instance != null) {
            throw new SingletonClassException("oracle.jdeveloper.library.JLibraryManager");
        }
        _instance = this;
    }

    public static JLibraryManager getInstance() {
        return _instance;
    }

    public static LibraryList[] getAllLibraryLists() {
        ArrayList<LibraryList> arrayList = new ArrayList<LibraryList>();
        arrayList.add(JLibraryManager.getAddinLibraries());
        arrayList.add(JLibraryManager.getUserLibraries());
        Collection collection = LISTS.values();
        if (collection != null) {
            arrayList.addAll(LISTS.values());
        }
        return arrayList.toArray(new LibraryList[arrayList.size()]);
    }

    public static List getLibraries() {
        LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < libraryListArray.length) {
            List list = libraryListArray[n].getLibraryList();
            arrayList.addAll(list);
            ++n;
        }
        return arrayList;
    }

    public static List getJDKs() {
        LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < libraryListArray.length) {
            List list = libraryListArray[n].getJdkList();
            arrayList.addAll(list);
            ++n;
        }
        return arrayList;
    }

    public static synchronized JDK getDefaultJDK() {
        if (_defaultJDK == null) {
            _defaultJDK = JLibraryManager.findOrCreateDefaultJDK();
        }
        return _defaultJDK;
    }

    public static JLibrary createLibrary(Object object, MutableLibraryList mutableLibraryList) {
        JLibrary jLibrary = null;
        if (mutableLibraryList != null && mutableLibraryList.findLibrary(object) == null) {
            jLibrary = mutableLibraryList.addLibrary(null);
        }
        return jLibrary;
    }

    public static JLibrary findLibrary(Object object) {
        JLibrary jLibrary = JLibraryManager.getUserLibraries().findLibrary(object);
        if (jLibrary == null && (jLibrary = JLibraryManager.getAddinLibraries().findLibrary(object)) == null) {
            try {
                URL uRL = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(object.toString() + LIBRARY_EXTENSION));
                jLibrary = JLibraryManager.getUserLibraries().findLibrary(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jLibrary;
    }

    public static void removeLibrary(JLibrary jLibrary, MutableLibraryList mutableLibraryList) {
        if (jLibrary != null && mutableLibraryList != null && mutableLibraryList.remove(jLibrary)) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            updateMessage.getRemoveObjects().add(jLibrary);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), updateMessage);
        }
    }

    public static JDK createJDK(Object object, URL uRL, MutableLibraryList mutableLibraryList) {
        JDK jDK = null;
        if (uRL != null && mutableLibraryList != null && mutableLibraryList.findJDK(object) == null && (jDK = mutableLibraryList.addJDK(null, uRL)) != null) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            updateMessage.getAddObjects().add(jDK);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), updateMessage);
        }
        return jDK;
    }

    public static JDK findJDK(Object object) {
        JDK jDK = JLibraryManager.getUserLibraries().findJDK(object);
        if (jDK == null && (jDK = JLibraryManager.getAddinLibraries().findJDK(object)) == null) {
            try {
                URL uRL = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(object.toString() + JDK_EXTENSION));
                jDK = JLibraryManager.getUserLibraries().findJDK(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jDK;
    }

    public static JDK findJDK(VersionNumber versionNumber, JDK[] jDKArray) {
        JDK jDK = null;
        JDK jDK2 = null;
        JDK jDK3 = null;
        if (versionNumber != null) {
            int n = 0;
            while (n < jDKArray.length) {
                VersionNumber versionNumber2 = jDKArray[n].getJavaVersion();
                if (versionNumber2.equals((Object)versionNumber)) {
                    jDK3 = jDKArray[n];
                    break;
                }
                if (versionNumber2.isBefore(versionNumber, false)) {
                    if (jDK == null || jDK.getJavaVersion().isBefore(versionNumber2, false)) {
                        jDK = jDKArray[n];
                    }
                } else if (jDK2 == null || jDK2.getJavaVersion().isAfter(versionNumber2, false)) {
                    jDK2 = jDKArray[n];
                }
                ++n;
            }
            if (jDK3 == null) {
                jDK3 = jDK2 != null ? jDK2 : jDK;
            }
        }
        return jDK3;
    }

    public static JDK findJDKMatch(Object object, VersionNumber versionNumber) {
        JDK jDK = JLibraryManager.findJDK(object);
        if (jDK == null) {
            List list = JLibraryManager.getJDKs();
            JDK[] jDKArray = list.toArray(new JDK[list.size()]);
            jDK = JLibraryManager.findJDK(versionNumber, jDKArray);
        }
        return jDK;
    }

    public static void removeJDK(JDK jDK, MutableLibraryList mutableLibraryList) {
        if (jDK != null && mutableLibraryList != null && mutableLibraryList.remove(jDK)) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            updateMessage.getRemoveObjects().add(jDK);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), updateMessage);
        }
    }

    public static JLibraryList addLibraryList(URL uRL) {
        JLibraryList jLibraryList = null;
        if (uRL != null && (jLibraryList = (JLibraryList)LISTS.get(uRL)) == null) {
            if (uRL.equals(JLibraryManager.getUserLibraries().getURL())) {
                return JLibraryManager.getUserLibraries();
            }
            jLibraryList = new JLibraryList(uRL);
            LISTS.put(uRL, jLibraryList);
        }
        return jLibraryList;
    }

    public static boolean removeLibraryList(LibraryList libraryList) {
        if (libraryList instanceof JLibraryList) {
            return LISTS.remove(((JLibraryList)libraryList).getURL()) != null;
        }
        return false;
    }

    public static synchronized JLibraryList getUserLibraries() {
        ExtensionRegistry extensionRegistry;
        URL uRL;
        if (_userLibs == null && (_userLibs = JLibraryManager._createLibraryList(uRL = (extensionRegistry = ExtensionRegistry.getOracleRegistry()).getSystemDirectory(Ide.getProductID()))) != null) {
            _userLibs.setListName(JLibraryList.USER_LIBRARIES);
        }
        return _userLibs;
    }

    public static synchronized AddinLibraryList getAddinLibraries() {
        if (_addinLibs == null) {
            _addinLibs = new AddinLibraryList();
            LibrariesHook librariesHook = (LibrariesHook)ExtensionRegistry.getExtensionRegistry().getHook(LibrariesHook.ELEMENT);
            if (librariesHook != null) {
                for (LibrariesHook.LibraryInfo libraryInfo : librariesHook.getLibraries()) {
                    _addinLibs.loadLibrary(libraryInfo.getName(), libraryInfo.getClassPath(), libraryInfo.getSourcePath(), libraryInfo.getDocPath(), libraryInfo.isDeployed());
                }
                for (LibrariesHook.LibraryAlias libraryAlias : librariesHook.getAliases()) {
                    _addinLibs.addAlias(libraryAlias.getFrom(), libraryAlias.getTo());
                }
            }
        }
        return _addinLibs;
    }

    public Dependable create(Element element, Folder folder) throws IllegalAccessException, InstantiationException {
        if (element == null) {
            return null;
        }
        Class clazz = JLibraryManager.getDerivedLibraryClass(element);
        if (clazz != null) {
            try {
                DerivedLibrary derivedLibrary = (DerivedLibrary)clazz.newInstance();
                if (folder != null) {
                    derivedLibrary.setSourceOwnerURL(((Node)folder).getURL());
                }
                derivedLibrary.setSourceURL(((Node)element).getURL());
                DerivedLibrary derivedLibrary2 = derivedLibrary;
                return derivedLibrary2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean recognize(Element element) {
        return JLibraryManager.getDerivedLibraryClass(element) != null;
    }

    public static void registerDerivedLibrary(Class clazz, Class clazz2) {
        _dependableRegistry.put(clazz, clazz2);
    }

    public static void unregisterDerivedLibrary(Class clazz) {
        _dependableRegistry.remove(clazz);
    }

    static void cacheDerivedLibrary(DerivedLibrary derivedLibrary) {
        ProjectDependencyFactory.cache(derivedLibrary);
    }

    static Class getDerivedLibraryClass(Element element) {
        Class<?> clazz;
        Object object = element != null ? element.getData() : null;
        Class<?> clazz2 = clazz = object != null ? object.getClass() : null;
        if (clazz != null) {
            for (Class clazz3 : _dependableRegistry.keySet()) {
                if (!clazz3.isAssignableFrom(clazz)) continue;
                return (Class)_dependableRegistry.get(clazz3);
            }
        }
        return null;
    }

    public void shutdown() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        if (clientSetting != null) {
            Iterator iterator;
            URLPath uRLPath = new URLPath();
            Collection collection = LISTS.values();
            Iterator iterator2 = iterator = collection != null ? collection.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    JLibraryList jLibraryList = (JLibraryList)iterator.next();
                    uRLPath.add(jLibraryList.getURL());
                }
                clientSetting.putData(SETTINGS_KEY, (Copyable)uRLPath);
            }
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void initialize() {
        URL[] uRLArray;
        _defaultJDK = JLibraryManager.findOrCreateDefaultJDK();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        URLPath uRLPath = (URLPath)(clientSetting != null ? clientSetting.getData(SETTINGS_KEY) : null);
        if (uRLPath != null && (uRLArray = uRLPath.getEntries()) != null) {
            int n = 0;
            while (n < uRLArray.length) {
                LISTS.put(uRLArray[n], new JLibraryList(uRLArray[n]));
                ++n;
            }
        }
        ProjectDependencyFactory.registerFactory(this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private static JDK findOrCreateDefaultJDK() {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("java.version");
        URL uRL = URLFactory.newDirURL((String)string);
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)"bin");
        URL uRL3 = URLFactory.newURL((URL)uRL2, (String)"java.exe");
        if (!URLFileSystem.exists((URL)uRL3)) {
            uRL3 = URLFactory.newURL((URL)uRL2, (String)"java");
        }
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL4 = URLFactory.newURL((URL)extensionRegistry.getSystemDirectory(Ide.getProductID()), (String)(string2 + JDK_EXTENSION));
        JDK jDK = JLibraryManager.getUserLibraries().findJDK(uRL4);
        if (jDK != null) {
            if (!uRL3.equals(jDK.getJavaExecutable())) {
                HashStructure hashStructure = HashStructure.newInstance();
                jDK = new JDKAdapter(hashStructure);
                JDKUtil.initJDK(jDK, uRL3);
            }
        } else {
            jDK = JLibraryManager.getUserLibraries().addJDK(string2, uRL3);
        }
        if (jDK != null) {
            return JLibraryManager.getAddinLibraries().loadJDK(LibraryArb.format(16, new String[]{string2}), jDK.getClassPath(), jDK.getSourcePath(), jDK.getDocPath(), jDK.getJavaExecutable(), jDK.getJavaVersion(), jDK.getSDKBinDir());
        }
        return null;
    }

    private static JLibraryList _createLibraryList(URL uRL) {
        return new JLibraryList(uRL);
    }

    public void attach(Observer observer) {
        _delegate.attach(observer);
    }

    public void detach(Observer observer) {
        _delegate.detach(observer);
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        _delegate.notifyObservers(object, updateMessage);
    }
}

