/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.LibraryArb;

public final class JProjectLibraryList
extends HashStructureAdapter
implements MutableLibraryList {
    private static final String LIB_BASE = LibraryArb.getString(9);
    private static final String JDK_BASE = LibraryArb.getString(10);
    private static final int NAME = 0;
    private static final int ID = 1;

    public JProjectLibraryList(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static JProjectLibraryList getInstance(HashStructure hashStructure) {
        return new JProjectLibraryList(hashStructure);
    }

    public JDK findJDK(Object object) {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        List list = this.getJdkList();
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                JDK jDK = (JDK)iterator.next();
                if (!object.equals(jDK.getID())) continue;
                return jDK;
            }
        }
        return null;
    }

    public JLibrary findLibrary(Object object) {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        List list = this.getLibraryList();
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                JLibrary jLibrary = (JLibrary)iterator.next();
                if (!object.equals(jLibrary.getID())) continue;
                return jLibrary;
            }
        }
        return null;
    }

    public List getJdkList() {
        Iterator iterator;
        ArrayList<JDKAdapter> arrayList = new ArrayList<JDKAdapter>();
        ListStructure listStructure = this._hash.getListStructure("jdkDefinitions");
        Iterator iterator2 = iterator = listStructure != null ? listStructure.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                HashStructure hashStructure = (HashStructure)iterator.next();
                arrayList.add(new JDKAdapter(hashStructure));
            }
        }
        return arrayList;
    }

    public void setJdkList(List list) {
        if (list == null) {
            this._hash.remove("jdkDefinitions");
        } else {
            Iterator iterator = list.iterator();
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    JDKAdapter jDKAdapter = (JDKAdapter)iterator.next();
                    HashStructure hashStructure = HashStructure.newInstance();
                    JDKAdapter jDKAdapter2 = new JDKAdapter(hashStructure);
                    jDKAdapter.copyTo(jDKAdapter2);
                    arrayList.add(hashStructure);
                }
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure("jdkDefinitions");
            listStructure.mirror(arrayList);
        }
    }

    public List getLibraryList() {
        Iterator iterator;
        ArrayList<JLibraryAdapter> arrayList = new ArrayList<JLibraryAdapter>();
        ListStructure listStructure = this._hash.getListStructure("libraryDefinitions");
        Iterator iterator2 = iterator = listStructure != null ? listStructure.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                HashStructure hashStructure = (HashStructure)iterator.next();
                arrayList.add(new JLibraryAdapter(hashStructure));
            }
        }
        return arrayList;
    }

    public void setLibraryList(List list) {
        if (list == null) {
            this._hash.remove("libraryDefinitions");
        } else {
            Iterator iterator = list.iterator();
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    JLibraryAdapter jLibraryAdapter = (JLibraryAdapter)iterator.next();
                    HashStructure hashStructure = HashStructure.newInstance();
                    JLibraryAdapter jLibraryAdapter2 = new JLibraryAdapter(hashStructure);
                    jLibraryAdapter.copyTo(jLibraryAdapter2);
                    arrayList.add(hashStructure);
                }
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure("libraryDefinitions");
            listStructure.mirror(arrayList);
        }
    }

    public String getListName() {
        return LibraryArb.getString(2);
    }

    public void setListName(String string) {
    }

    public boolean isTransient() {
        return false;
    }

    public JLibrary addLibrary(String string) {
        HashStructure hashStructure = HashStructure.newInstance();
        JLibraryAdapter jLibraryAdapter = new JLibraryAdapter(hashStructure);
        ListStructure listStructure = this._hash.getOrCreateListStructure("libraryDefinitions");
        int n = 0;
        if (string == null) {
            n = 1;
            string = LIB_BASE;
        }
        jLibraryAdapter.setName(this.getUniqueValue(string, 0, n, false));
        jLibraryAdapter.setID(this.getUniqueValue(jLibraryAdapter.getName(), 1, 0, false));
        listStructure.add((Object)hashStructure);
        return jLibraryAdapter;
    }

    public JDK addJDK(String string, URL uRL) {
        HashStructure hashStructure = HashStructure.newInstance();
        JDKAdapter jDKAdapter = new JDKAdapter(hashStructure);
        int n = 0;
        JDKUtil.initJDK(jDKAdapter, uRL);
        ListStructure listStructure = this._hash.getOrCreateListStructure("jdkDefinitions");
        if (string == null) {
            n = 1;
            string = JDK_BASE;
        }
        jDKAdapter.setName(this.getUniqueValue(string, 0, n, true));
        jDKAdapter.setID(this.getUniqueValue(jDKAdapter.getName(), 1, 0, true));
        listStructure.add((Object)hashStructure);
        return jDKAdapter;
    }

    public boolean remove(Library library) {
        List list;
        if (library instanceof JDKAdapter) {
            List list2 = this.getJdkList();
            if (list2.remove(library)) {
                this.setJdkList(list2);
                return true;
            }
        } else if (library instanceof JLibraryAdapter && (list = this.getLibraryList()).remove(library)) {
            this.setLibraryList(list);
            return true;
        }
        return false;
    }

    public Object createIDFromName(String string, boolean bl) {
        string = string != null ? string.trim() : null;
        return string != null && string.length() > 0 ? string : null;
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(13);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    private String getUniqueValue(String string, int n, int n2, boolean bl) {
        List list = bl ? this.getJdkList() : this.getLibraryList();
        String[] stringArray = new String[list.size()];
        switch (n) {
            case 0: {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray[n3] = ((Library)list.get(n3)).getName();
                    ++n3;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringArray[n4] = ((Library)list.get(n4)).getID().toString();
                    ++n4;
                }
                break;
            }
            default: {
                return string;
            }
        }
        boolean bl2 = false;
        String string2 = n2 > 0 ? string + n2 : string;
        block6: do {
            bl2 = false;
            int n5 = 0;
            while (n5 < stringArray.length) {
                if (stringArray[n5].equals(string2)) {
                    bl2 = true;
                    string2 = string + ++n2;
                    continue block6;
                }
                ++n5;
            }
        } while (bl2);
        return string2;
    }

    public Icon getDefaultIcon() {
        return LibraryArb.getIcon(6);
    }
}

