/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.LibraryElement;
import oracle.jdeveloper.resource.ControlsArb;

public final class LegacyJDK
extends LibraryElement {
    private static final String CFG_FILE = "jvm.cfg";
    private URLPath _clsPath;
    private URLPath _srcPath;
    private URLPath _docPath;
    private boolean _isLocked;
    private URL _javaExecutable;
    private String[] _installedVMs;
    private VersionNumber _javaVersion;
    private String _name;
    private URL _binDir;

    public String getShortLabel() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    public void setClassPath(URLPath uRLPath) {
        if (ModelUtil.areDifferent((Object)uRLPath, (Object)this._clsPath)) {
            this._clsPath = new URLPath(uRLPath);
            this.markDirty(true);
        }
    }

    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    public void setSourcePath(URLPath uRLPath) {
        if (ModelUtil.areDifferent((Object)uRLPath, (Object)this._srcPath)) {
            this._srcPath = new URLPath(uRLPath);
            this.markDirty(true);
        }
    }

    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    public void setDocPath(URLPath uRLPath) {
        if (ModelUtil.areDifferent((Object)uRLPath, (Object)this._docPath)) {
            this._docPath = new URLPath(uRLPath);
            this.markDirty(true);
        }
    }

    public boolean isLocked() {
        return this._isLocked;
    }

    public void setLocked(boolean bl) {
        if (bl != this._isLocked) {
            this._isLocked = bl;
            this.markDirty(true);
        }
    }

    public URL getJavaExecutable() {
        return this._javaExecutable;
    }

    public void setJavaExecutable(URL uRL) {
        if (ModelUtil.areDifferent((Object)this._javaExecutable, (Object)uRL)) {
            this._javaExecutable = uRL;
            this.markDirty(true);
        }
    }

    public VersionNumber getJavaVersion() {
        return this._javaVersion;
    }

    public void setJavaVersion(VersionNumber versionNumber) {
        if (ModelUtil.areDifferent((Object)this._javaVersion, (Object)versionNumber)) {
            this._javaVersion = versionNumber;
            this.markDirty(true);
        }
    }

    public URL getSDKBinDir() {
        return this._binDir;
    }

    public void setSDKBinDir(URL uRL) {
        if (ModelUtil.areDifferent((Object)this._binDir, (Object)uRL)) {
            this._binDir = uRL;
            this.markDirty(true);
        }
    }

    public String[] getInstalledVMs() throws TransientMarker {
        String[] stringArray = null;
        if (this._installedVMs == null && this._binDir != null) {
            URL uRL = URLFileSystem.getParent((URL)this._binDir);
            URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)"jre");
            if (!URLFileSystem.exists((URL)uRL2)) {
                uRL2 = uRL;
            }
            this._installedVMs = LegacyJDK._getVMChoices(uRL2);
        }
        if (this._installedVMs != null) {
            stringArray = new String[this._installedVMs.length];
            System.arraycopy(this._installedVMs, 0, stringArray, 0, this._installedVMs.length);
        }
        return stringArray;
    }

    private static String[] _getVMChoices(URL uRL) {
        URL uRL2;
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL3 = URLFactory.newURL((URL)uRL, (String)"lib/");
        if (uRL3 == null) {
            uRL3 = uRL;
        }
        if ((uRL2 = LegacyJDK._findJvmCfg(uRL3)) != null) {
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL2.openStream()));
                    while (true) {
                        String string;
                        if ((string = bufferedReader.readLine()) == null) {
                        }
                        if (string.startsWith("#")) continue;
                        String string2 = null;
                        String string3 = null;
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            if (stringTokenizer.hasMoreTokens()) {
                                string3 = stringTokenizer.nextToken();
                            }
                        }
                        if (string2 == null || string3 != null && !string3.equalsIgnoreCase("KNOWN") && !string3.equalsIgnoreCase("ALIASED_TO")) continue;
                        if (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                        }
                        arrayList.add(string2);
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        } else {
            URL[] uRLArray;
            URL uRL4 = URLFactory.newDirURL((URL)uRL, (String)"bin");
            if (URLFileSystem.exists((URL)uRL4) && (uRLArray = URLFileSystem.list((URL)uRL4, (URLFilter)new 2())) != null) {
                int n = 0;
                while (n < uRLArray.length) {
                    String string = URLFileSystem.getFileName((URL)uRLArray[n]);
                    arrayList.add(string);
                    ++n;
                }
                int n2 = arrayList.indexOf("ojvm");
                if (n2 != -1) {
                    Object e = arrayList.remove(n2);
                    arrayList.add(0, (String)e);
                } else {
                    n2 = arrayList.indexOf("classic");
                    if (n2 != -1) {
                        Object e = arrayList.remove(n2);
                        arrayList.add(0, (String)e);
                    }
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private static URL _findJvmCfg(URL uRL) {
        URL uRL2 = LegacyJDK._checkLocation(uRL);
        if (uRL2 != null) {
            return uRL2;
        }
        String string = System.getProperty("os.arch");
        if ("x86".equals(string)) {
            string = "i386";
        }
        if ((uRL2 = LegacyJDK._checkLocation(URLFactory.newDirURL((URL)uRL, (String)string))) != null) {
            return uRL2;
        }
        return LegacyJDK._checkChildren(uRL);
    }

    private static URL _checkLocation(URL uRL) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)CFG_FILE);
        return uRL2 != null && URLFileSystem.exists((URL)uRL2) ? uRL2 : null;
    }

    private static URL _checkChildren(URL uRL) {
        URL[] uRLArray = URLFileSystem.list((URL)uRL, (URLFilter)new 1());
        if (uRLArray != null) {
            int n = uRLArray.length - 1;
            while (n >= 0) {
                URL uRL2 = LegacyJDK._checkLocation(uRLArray[n]);
                if (uRL2 != null) {
                    return uRL2;
                }
                uRL2 = LegacyJDK._checkChildren(uRLArray[n]);
                if (uRL2 != null) {
                    return uRL2;
                }
                --n;
            }
        }
        return null;
    }

    public static final class 2
    implements URLFilter {
        public boolean accept(URL uRL) {
            return URLFileSystem.isDirectory((URL)uRL) && URLFileSystem.exists((URL)URLFactory.newURL((URL)uRL, (String)"jvm.dll"));
        }
    }

    public static final class 1
    implements URLFilter {
        public boolean accept(URL uRL) {
            return URLFileSystem.isDirectory((URL)uRL);
        }
    }

    public static class JDKExeFilter
    implements URLFilter {
        public boolean accept(URL uRL) {
            String string;
            boolean bl = false;
            if (uRL != null && "file".equals(uRL.getProtocol()) && URLFileSystem.isRegularFile((URL)uRL) && (string = URLFileSystem.getFileName((URL)uRL)) != null) {
                bl = (string = string.toLowerCase()).equals("java") || string.equals("java.exe");
            }
            return bl;
        }

        public boolean equals(Object object) {
            return object instanceof JDKExeFilter;
        }

        public String toString() {
            return ControlsArb.getString(53);
        }
    }
}

