/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.LibraryArb;

public abstract class LibraryAdapter
extends HashStructureAdapter
implements Library {
    public LibraryAdapter(HashStructure hashStructure) {
        super(hashStructure);
    }

    public URLPath getClassPath() {
        ListStructure listStructure = this._hash.getListStructure("classPath");
        return new URLPath(listStructure);
    }

    public void setClassPath(URLPath uRLPath) {
        if (uRLPath == null) {
            this._hash.remove("classPath");
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure("classPath");
            listStructure.mirror(uRLPath.asList());
        }
    }

    public URLPath getSourcePath() {
        ListStructure listStructure = this._hash.getListStructure("sourcePath");
        return new URLPath(listStructure);
    }

    public void setSourcePath(URLPath uRLPath) {
        if (uRLPath == null) {
            this._hash.remove("sourcePath");
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure("sourcePath");
            listStructure.mirror(uRLPath.asList());
        }
    }

    public URLPath getDocPath() {
        ListStructure listStructure = this._hash.getListStructure("docPath");
        return new URLPath(listStructure);
    }

    public void setDocPath(URLPath uRLPath) {
        if (uRLPath == null) {
            this._hash.remove("docPath");
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure("docPath");
            listStructure.mirror(uRLPath.asList());
        }
    }

    public boolean isLocked() {
        return this._hash.getBoolean("locked", false);
    }

    public void setLocked(boolean bl) {
        this._hash.putBoolean("locked", bl);
    }

    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    public void initFromLibrary(Library library) {
        if (library != null) {
            URLPath uRLPath = library.getClassPath();
            if (ModelUtil.areDifferent((Object)uRLPath, (Object)this.getClassPath())) {
                this.setClassPath(uRLPath);
            }
            if (ModelUtil.areDifferent((Object)(uRLPath = library.getSourcePath()), (Object)this.getSourcePath())) {
                this.setSourcePath(uRLPath);
            }
            if (ModelUtil.areDifferent((Object)(uRLPath = library.getDocPath()), (Object)this.getDocPath())) {
                this.setDocPath(uRLPath);
            }
            if (library.isLocked() != this.isLocked()) {
                this.setLocked(library.isLocked());
            }
        }
    }

    public String getShortLabel() {
        return this.getName();
    }

    public String getLongLabel() {
        Object object = this.getID();
        return object instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)object)) : object.toString();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(4);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    public String getName() {
        return this._hash.getString("description", "");
    }

    public void setName(String string) {
        if (string == null) {
            this._hash.remove("description");
        } else {
            this._hash.putString("description", string);
        }
    }

    public Object getID() {
        return this._hash.getObject("id");
    }

    public void setID(Object object) {
        if (object == null) {
            this._hash.remove("id");
        } else if (object instanceof URL) {
            this._hash.putURL("id", (URL)object);
        } else {
            this._hash.putString("id", object.toString());
        }
    }

    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    public void setDefaultClassPath(URLPath uRLPath) {
        this.setClassPath(uRLPath);
    }

    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    public void setDefaultSourcePath(URLPath uRLPath) {
        this.setSourcePath(uRLPath);
    }

    public URLPath getDefaultDocPath() {
        return this.getDocPath();
    }

    public void setDefaultDocPath(URLPath uRLPath) {
        this.setDocPath(uRLPath);
    }
}

