/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKNode;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JLibraryNode;
import oracle.jdeveloper.library.LegacyJDK;
import oracle.jdeveloper.library.LegacyLibrary;
import oracle.jdeveloper.library.LegacyLibraryList;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.resource.LibraryArb;

public class LibraryMigrator
extends XMLMigrator {
    private static final int USER_LIBRARIES = 0;
    private static final int USER_J2SES = 1;
    private static final int SYSTEM_LIBRARIES = 2;
    private static final int SYSTEM_J2SES = 3;

    public LibraryMigrator() {
        super(new int[]{0, 1, 2, 3});
    }

    protected String getFileName() {
        return "libraries.xml";
    }

    protected String getNamespaceURI() {
        return LegacyLibraryList.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "JLibraryList";
    }

    public String getDescription(int n) {
        Object var2_2 = null;
        switch (n) {
            case 0: {
                return CommandArb.getString(3);
            }
            case 1: {
                return CommandArb.getString(4);
            }
            case 2: {
                return LibraryArb.getString(17);
            }
            case 3: {
                return LibraryArb.getString(18);
            }
        }
        return null;
    }

    protected void prepareToMigrate() {
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/903/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/904/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/905/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/9051/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/10120/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
    }

    protected Object adjustObject(File file, File file2, Object object) throws Exception {
        LegacyLibraryList legacyLibraryList = (LegacyLibraryList)((Object)object);
        ArrayList<LegacyLibrary> arrayList = new ArrayList<LegacyLibrary>();
        ArrayList<LegacyJDK> arrayList2 = new ArrayList<LegacyJDK>();
        if (this.isSelected(0)) {
            Iterator iterator;
            List list = legacyLibraryList != null ? legacyLibraryList.getLibraryList() : null;
            Iterator iterator2 = iterator = list != null ? list.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    LegacyLibrary legacyLibrary = (LegacyLibrary)((Object)iterator.next());
                    if (!this._isValidLibrary(legacyLibrary)) continue;
                    arrayList.add(legacyLibrary);
                }
            }
        }
        if (this.isSelected(1)) {
            Iterator iterator;
            List list = legacyLibraryList != null ? legacyLibraryList.getJdkList() : null;
            Iterator iterator3 = iterator = list != null ? list.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    LegacyJDK legacyJDK = (LegacyJDK)((Object)iterator.next());
                    if (!this._isValidJDK(legacyJDK)) continue;
                    arrayList2.add(legacyJDK);
                }
            }
        }
        if (this.isSelected(2) || this.isSelected(3)) {
            String string = Ide.getInstallDirectory((File)file);
            legacyLibraryList = null;
            if (string != null && string.length() > 0) {
                try {
                    file = new File(string);
                    file = file.getParentFile();
                    file = new File(file, "lib");
                    legacyLibraryList = (LegacyLibraryList)((Object)this.readObject(file, file2));
                }
                catch (Exception exception) {
                    legacyLibraryList = null;
                    this.getLogger().logInformation(exception.getLocalizedMessage());
                }
            }
            if (this.isSelected(2)) {
                Iterator iterator;
                List list = legacyLibraryList != null ? legacyLibraryList.getLibraryList() : null;
                Iterator iterator4 = iterator = list != null ? list.iterator() : null;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        LegacyLibrary legacyLibrary = (LegacyLibrary)((Object)iterator.next());
                        if (!this._isValidLibrary(legacyLibrary)) continue;
                        arrayList.add(legacyLibrary);
                    }
                }
            }
            if (this.isSelected(3)) {
                Iterator iterator;
                List list = legacyLibraryList != null ? legacyLibraryList.getJdkList() : null;
                Iterator iterator5 = iterator = list != null ? list.iterator() : null;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        LegacyJDK legacyJDK = (LegacyJDK)((Object)iterator.next());
                        if (!this._isValidJDK(legacyJDK)) continue;
                        arrayList2.add(legacyJDK);
                    }
                }
            }
        }
        Ide.addIdeListener((IdeListener)new 1(this, arrayList, arrayList2));
        return null;
    }

    private boolean _isValidLibrary(LegacyLibrary legacyLibrary) {
        boolean bl = false;
        URLPath uRLPath = legacyLibrary.getClassPath();
        if (uRLPath.size() > 0) {
            bl = this._pathContainsValidEntry(uRLPath);
        } else {
            uRLPath = legacyLibrary.getSourcePath();
            if (uRLPath.size() > 0) {
                bl = this._pathContainsValidEntry(uRLPath);
            } else {
                uRLPath = legacyLibrary.getDocPath();
                if (uRLPath.size() > 0) {
                    bl = this._pathContainsValidEntry(uRLPath);
                }
            }
        }
        return bl;
    }

    private boolean _pathContainsValidEntry(URLPath uRLPath) {
        Iterator iterator;
        Iterator iterator2 = iterator = uRLPath != null ? uRLPath.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                if (!URLFileSystem.exists((URL)uRL)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isValidJDK(LegacyJDK legacyJDK) {
        if (legacyJDK != null) {
            URL uRL = legacyJDK.getJavaExecutable();
            return uRL != null && URLFileSystem.exists((URL)uRL);
        }
        return false;
    }

    static XMLMigrator.MigrationLogger mav$getLogger(LibraryMigrator libraryMigrator) {
        return libraryMigrator.getLogger();
    }

    public final class 1
    implements IdeListener {
        private final /* synthetic */ List v$libraries;
        private final /* synthetic */ List v$jdks;
        final /* synthetic */ LibraryMigrator this$0;

        public void addinsLoaded(IdeEvent ideEvent) {
            JLibraryList jLibraryList = JLibraryManager.getUserLibraries();
            if (jLibraryList != null) {
                if (this.v$libraries.size() > 0) {
                    for (LegacyLibrary legacyLibrary : this.v$libraries) {
                        if (JLibraryManager.findLibrary(legacyLibrary.getName()) == null) {
                            try {
                                URL uRL = URLFactory.newURL((URL)jLibraryList.getURL(), (String)(legacyLibrary.getName() + ".library"));
                                JLibrary jLibrary = jLibraryList.addLibrary(legacyLibrary.getName(), uRL);
                                if (jLibrary == null) continue;
                                jLibrary.setClassPath(legacyLibrary.getClassPath());
                                jLibrary.setSourcePath(legacyLibrary.getSourcePath());
                                jLibrary.setDocPath(legacyLibrary.getDocPath());
                                jLibrary.setLocked(legacyLibrary.isLocked());
                                jLibrary.setDeployedByDefault(legacyLibrary.getDeployedByDefault());
                                ((JLibraryNode)jLibrary).save();
                            }
                            catch (Exception exception) {
                                LibraryMigrator.mav$getLogger(this.this$0).logInformation(LibraryArb.format(11, new String[]{legacyLibrary.getName()}));
                            }
                            continue;
                        }
                        LibraryMigrator.mav$getLogger(this.this$0).logInformation(LibraryArb.format(15, new String[]{LibraryArb.getString(9), legacyLibrary.getName()}));
                    }
                }
                if (this.v$jdks.size() > 0) {
                    for (LegacyJDK legacyJDK : this.v$jdks) {
                        if (JLibraryManager.findJDK(legacyJDK.getName()) == null) {
                            try {
                                URL uRL = URLFactory.newURL((URL)jLibraryList.getURL(), (String)(legacyJDK.getName() + ".jdk"));
                                JDK jDK = jLibraryList.addJDK(legacyJDK.getName(), legacyJDK.getJavaExecutable(), uRL);
                                if (jDK == null) continue;
                                jDK.setClassPath(legacyJDK.getClassPath());
                                jDK.setSourcePath(legacyJDK.getSourcePath());
                                jDK.setDocPath(legacyJDK.getDocPath());
                                jDK.setLocked(legacyJDK.isLocked());
                                jDK.setJavaExecutable(legacyJDK.getJavaExecutable());
                                jDK.setInstalledVMs(legacyJDK.getInstalledVMs());
                                jDK.setJavaVersion(legacyJDK.getJavaVersion());
                                jDK.setSDKBinDir(legacyJDK.getSDKBinDir());
                                ((JDKNode)jDK).save();
                            }
                            catch (Exception exception) {
                                LibraryMigrator.mav$getLogger(this.this$0).logInformation(LibraryArb.format(11, new String[]{legacyJDK.getName()}));
                            }
                            continue;
                        }
                        LibraryMigrator.mav$getLogger(this.this$0).logInformation(LibraryArb.format(15, new String[]{LibraryArb.getString(10), legacyJDK.getName()}));
                    }
                }
            }
            Ide.removeIdeListener((IdeListener)this);
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }

        public 1(LibraryMigrator libraryMigrator, List list, List list2) {
            this.v$jdks = list2;
            this.v$libraries = list;
            this.this$0 = libraryMigrator;
        }
    }
}

