/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;

public class ListWrapper
implements MutableLibraryList {
    public static final int LIBRARY_LIST = 0;
    public static final int JDK_LIST = 1;
    public static final int BOTH_LISTS = 2;
    private LibraryList _list;
    private List _initialLibStates;
    private int _initialLibCount;
    private HashMap _masterLibMap;
    private HashMap _redirectLibMap;
    private List _initialJDKStates;
    private int _initialJDKCount;
    private HashMap _masterJDKMap;
    private HashMap _redirectJDKMap;

    public ListWrapper(LibraryList libraryList) {
        this(libraryList, 2);
    }

    public ListWrapper(LibraryList libraryList, int n) {
        this._list = libraryList;
        if (n == 0 || n == 2) {
            this._initialLibStates = this._list.getLibraryList();
            if (this._initialLibStates == null) {
                this._initialLibStates = new ArrayList();
            }
            this._initialLibCount = this._initialLibStates.size();
            this._masterLibMap = new HashMap();
            this._redirectLibMap = new HashMap();
            int n2 = 0;
            while (n2 < this._initialLibCount) {
                JLibrary jLibrary = (JLibrary)this._initialLibStates.get(n2);
                this._masterLibMap.put(new Integer(n2), jLibrary.getID());
                this._redirectLibMap.put(jLibrary.getID(), jLibrary);
                ++n2;
            }
        }
        if (n == 1 || n == 2) {
            this._initialJDKStates = this._list.getJdkList();
            if (this._initialJDKStates == null) {
                this._initialJDKStates = new ArrayList();
            }
            this._initialJDKCount = this._initialJDKStates.size();
            this._masterJDKMap = new HashMap();
            this._redirectJDKMap = new HashMap();
            int n3 = 0;
            while (n3 < this._initialJDKCount) {
                JDK jDK = (JDK)this._initialJDKStates.get(n3);
                this._masterJDKMap.put(new Integer(n3), jDK.getID());
                this._redirectJDKMap.put(jDK.getID(), jDK);
                ++n3;
            }
        }
    }

    public JDK findJDK(Object object) {
        return this._redirectJDKMap != null ? (JDK)this._redirectJDKMap.get(object) : null;
    }

    public JLibrary findLibrary(Object object) {
        return this._redirectLibMap != null ? (JLibrary)this._redirectLibMap.get(object) : null;
    }

    public List getJdkList() {
        if (this._redirectJDKMap != null) {
            ArrayList arrayList = new ArrayList();
            Collection collection = this._redirectJDKMap.values();
            arrayList.addAll(collection);
            return arrayList;
        }
        return null;
    }

    public List getLibraryList() {
        if (this._redirectLibMap != null) {
            ArrayList arrayList = new ArrayList();
            Collection collection = this._redirectLibMap.values();
            arrayList.addAll(collection);
            return arrayList;
        }
        return null;
    }

    public String getListName() {
        return this._list != null ? this._list.getListName() : null;
    }

    public boolean isTransient() {
        return this._list != null ? this._list.isTransient() : true;
    }

    public String getShortLabel() {
        return this._list != null ? this._list.getShortLabel() : null;
    }

    public String getLongLabel() {
        return this._list != null ? this._list.getLongLabel() : null;
    }

    public Icon getIcon() {
        return this._list != null ? this._list.getIcon() : null;
    }

    public String getToolTipText() {
        return this._list != null ? this._list.getToolTipText() : null;
    }

    public void setJdkList(List list) {
    }

    public void setLibraryList(List list) {
    }

    public void setListName(String string) {
    }

    public JDK addJDK(String string, URL uRL) {
        JDK jDK = null;
        if (this._list instanceof MutableLibraryList && this._redirectJDKMap != null) {
            Object object = ((MutableLibraryList)this._list).createIDFromName(string, true);
            jDK = (JDK)this._redirectJDKMap.get(object);
            if (jDK == null) {
                HashStructure hashStructure = HashStructure.newInstance();
                jDK = new JDKAdapter(hashStructure);
                jDK.setName(string);
                ((JDKAdapter)jDK).setID(object);
                this._initialJDKStates.add(null);
                this._masterJDKMap.put(new Integer(this._initialJDKStates.size() - 1), object);
                this._redirectJDKMap.put(object, jDK);
            } else {
                jDK.setName(string);
            }
            JDKUtil.initJDK(jDK, uRL);
        }
        return jDK;
    }

    public JLibrary addLibrary(String string) {
        JLibrary jLibrary = null;
        if (this._list instanceof MutableLibraryList && this._redirectLibMap != null) {
            Object object = ((MutableLibraryList)this._list).createIDFromName(string, false);
            jLibrary = (JLibrary)this._redirectLibMap.get(object);
            if (jLibrary == null) {
                HashStructure hashStructure = HashStructure.newInstance();
                jLibrary = new JLibraryAdapter(hashStructure);
                jLibrary.setName(string);
                ((JLibraryAdapter)jLibrary).setIcon(((MutableLibraryList)this._list).getDefaultIcon());
                ((JLibraryAdapter)jLibrary).setID(object);
                this._initialLibStates.add(null);
                this._masterLibMap.put(new Integer(this._initialLibStates.size() - 1), object);
                this._redirectLibMap.put(object, jLibrary);
            } else {
                jLibrary.setName(string);
            }
        }
        return jLibrary;
    }

    public boolean remove(Library library) {
        block8: {
            Object object;
            block7: {
                Iterator iterator;
                Object object2 = object = library != null ? library.getID() : null;
                if (object == null) {
                    return false;
                }
                if (!(this._list instanceof MutableLibraryList)) {
                    return false;
                }
                if (!(library instanceof JDK)) break block7;
                if (this._redirectJDKMap == null) break block8;
                Set set = this._masterJDKMap.keySet();
                Iterator iterator2 = iterator = set != null ? set.iterator() : null;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        if (!object.equals(this._masterJDKMap.get(k))) continue;
                        this._masterJDKMap.put(k, null);
                        this._redirectJDKMap.remove(object);
                        return true;
                    }
                }
                break block8;
            }
            if (library instanceof JLibrary && this._redirectLibMap != null) {
                Iterator iterator;
                Set set = this._masterLibMap.keySet();
                Iterator iterator3 = iterator = set != null ? set.iterator() : null;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        if (!object.equals(this._masterLibMap.get(k))) continue;
                        this._masterLibMap.put(k, null);
                        this._redirectLibMap.remove(object);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Object createIDFromName(String string, boolean bl) {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).createIDFromName(string, bl) : null;
    }

    public LibraryList getWrappedList() {
        return this._list;
    }

    public void commit(boolean bl) {
        if (this._list instanceof MutableLibraryList) {
            if (this._redirectLibMap != null) {
                this.commit(this._masterLibMap, this._redirectLibMap, this._initialLibStates, this._initialLibCount, bl, false);
            }
            if (this._redirectJDKMap != null) {
                this.commit(this._masterJDKMap, this._redirectJDKMap, this._initialJDKStates, this._initialJDKCount, bl, true);
            }
        }
    }

    public String toString() {
        return this._list.toString();
    }

    private void commit(HashMap hashMap, HashMap hashMap2, List list, int n, boolean bl, boolean bl2) {
        if (hashMap2 != null) {
            MutableLibraryList mutableLibraryList = (MutableLibraryList)this._list;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Library> arrayList3 = new ArrayList<Library>();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                Integer n4 = new Integer(n3);
                Object v = hashMap.get(n4);
                if (n3 >= n) {
                    if (v != null) {
                        arrayList.add(hashMap2.get(v));
                    }
                } else if (v == null) {
                    arrayList2.add(list.get(n3));
                } else {
                    Library library;
                    Library library2 = (Library)list.get(n3);
                    if (library2 != null && !library2.equivalent(library = (Library)hashMap2.get(v))) {
                        library2.initFromLibrary(library);
                        arrayList3.add(library2);
                    }
                }
                ++n3;
            }
            n2 = arrayList2.size();
            if (n2 > 0) {
                int n5 = 0;
                while (n5 < n2) {
                    mutableLibraryList.remove((Library)arrayList2.get(n5));
                    ++n5;
                }
                if (bl) {
                    UpdateMessage.fireChildrenRemoved((Subject)JLibraryManager.getInstance(), arrayList2);
                }
            }
            if ((n2 = arrayList.size()) > 0) {
                int n6 = n2 - 1;
                while (n6 >= 0) {
                    Library library = (Library)arrayList.get(n6);
                    Library library3 = null;
                    library3 = bl2 ? mutableLibraryList.addJDK(library.getName(), ((JDK)library).getJavaExecutable()) : mutableLibraryList.addLibrary(library.getName());
                    if (library3 != null) {
                        library3.initFromLibrary(library);
                        if (library3 instanceof Node) {
                            try {
                                ((Node)library3).save();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        arrayList.set(n6, library3);
                    } else {
                        arrayList.remove(n6);
                    }
                    --n6;
                }
                if (bl) {
                    UpdateMessage.fireChildrenAdded((Subject)JLibraryManager.getInstance(), arrayList);
                }
            }
            if ((n2 = arrayList3.size()) > 0) {
                int n7 = n2 - 1;
                while (n7 >= 0) {
                    Library library = (Library)arrayList3.get(n7);
                    if (library instanceof Node) {
                        try {
                            ((Node)library).save();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    --n7;
                }
                if (bl) {
                    UpdateMessage.fireStructureChanged((Subject)JLibraryManager.getInstance(), arrayList3);
                }
            }
        }
    }

    public Icon getDefaultIcon() {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).getDefaultIcon() : null;
    }
}

