/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.icons.IdeIcons;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.jdeveloper.merge.MergeController;
import oracle.jdeveloper.merge.RestartMergeCommand;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdeveloper.resource.MergeArb;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdevimpl.compare.CompareViewOwner;

public abstract class AbstractMergeEditor
extends Editor
implements CompareViewOwner,
PopupManager,
FindableEditor,
DynamicStatusProvider {
    static final int ATTRIBUTE_MERGE_SAVEABLE = ElementAttributes.nextMutableAttribute();
    static final int ATTRIBUTE_MERGE_DIRTY = ElementAttributes.nextMutableAttribute();
    private JPanel _gui;
    private JLabel _statusLabel;
    private Toolbar _toolbar;
    private JPanel _horizontalScrollContainer;
    private Component _northComponent;
    private CompareView _view;
    private boolean _completeState;
    private Collection _statusChangeListeners;
    private JPanel _nodeChangePanel;
    private NodeWatcher _nodeWatcher;

    void $init$() {
        this._gui = new JPanel();
        this._statusLabel = null;
        this._toolbar = new Toolbar();
        this._horizontalScrollContainer = new JPanel();
        this._statusChangeListeners = new ArrayList();
        this._gui.setLayout(new BorderLayout());
        this._horizontalScrollContainer.setLayout(new BorderLayout());
    }

    public CompareView getCompareView() {
        return this._view;
    }

    private void merge(CompareModel compareModel) {
        this._completeState = false;
        if (this._view instanceof EditorPaneView) {
            ((EditorPaneView)this._view).removePopupManager((PopupManager)this);
        }
        if (compareModel == null || compareModel.getDifferenceCount() <= 0) {
            this.moveToCompleteState();
            return;
        }
        this.removeGUI();
        this._northComponent = this.layoutNorthComponent(this._toolbar);
        this._gui.add(this._northComponent, "North");
        this._view = CompareViewFactory.createMergeView((CompareModel)compareModel);
        this.installUndoableEditListener();
        if (this._view instanceof NavigableView) {
            ((NavigableView)this._view).goToFirstDifference();
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigatePrevious")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateNext")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
        }
        this.initializeToolbar(this._toolbar);
        if (this._view instanceof EditorPaneView) {
            ((EditorPaneView)this._view).addPopupManager((PopupManager)this);
        }
        this.initializeMergeView(this._view);
        this._gui.add(this._view.getGUI(), "Center");
        this.updateStatusLabel();
        if (this._view instanceof CustomHorizontalScrollView) {
            this._horizontalScrollContainer.add(((CustomHorizontalScrollView)this._view).getHorizontalScrollComponent(), "Center");
        }
        this.validateGUI();
    }

    protected IdeAction createLocalAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        return ideAction.newLocalAction((View)this);
    }

    protected void updateStatusLabel() {
        this.setStatusText("");
        if (this._view == null) {
            return;
        }
        if (this._completeState) {
            this.setStatusText(MergeArb.getString(8));
            return;
        }
        int n = this._view.getModel().getConflictCount();
        int n2 = this._view.getModel().getResolvedCount();
        if (n == 0) {
            this.setStatusText(MergeArb.getString(6));
            return;
        }
        this.setStatusText(MessageFormat.format(MergeArb.getString(7), String.valueOf(n), String.valueOf(n2), String.valueOf(n - n2)));
    }

    private void setStatusText(String string) {
        this._statusLabel = null;
        this.fireStatusStateChanged();
        this._statusLabel = new JLabel(string);
        this.fireStatusStateChanged();
    }

    private void fireStatusStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this._statusChangeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    public boolean restartMerge() throws IOException {
        if (!MessageDialog.confirm((Component)this.owner().getGUI(), (Object)MergeArb.getString(9), (String)MergeArb.getString(10), null, (boolean)true)) {
            return false;
        }
        return this.restartMergeImpl();
    }

    public boolean restartMergeImpl() throws IOException {
        try {
            boolean bl = this.restartMergeImpl(this.getContext());
            this._nodeWatcher.resetNodeDirty();
            return bl;
        }
        catch (Throwable throwable) {
            this._nodeWatcher.resetNodeDirty();
            throw throwable;
        }
    }

    public boolean saveMerge() throws IOException {
        if (!MessageDialog.confirm((Component)this.owner().getGUI(), (Object)MergeArb.format(11, this.getContext().getNode().getShortLabel()), (String)MergeArb.getString(12), null, (boolean)true)) {
            return false;
        }
        return this.saveMergeImpl();
    }

    public boolean saveMergeImpl() throws IOException {
        if (!this.saveMergeImpl(this.getContext(), this._view.getModel())) {
            return false;
        }
        this.clearMergeAttributes();
        return true;
    }

    public void moveToCompleteState() {
        this.closeGUI();
        FocusableLabel focusableLabel = new FocusableLabel(MergeArb.getString(13));
        this._gui.add((Component)focusableLabel, "Center");
        this.repaintGUI();
        this._completeState = true;
        this.updateStatusLabel();
    }

    public boolean isCompleteState() {
        return this._completeState;
    }

    private void removeGUI() {
        this._gui.removeAll();
        this._toolbar.removeAll();
        this._horizontalScrollContainer.removeAll();
        this._gui.setSize(0, 0);
        this._gui.setPreferredSize(new Dimension(0, 0));
        this.validateGUI();
        this._northComponent = null;
    }

    private void validateGUI() {
        if (this._gui == null || !this._gui.isVisible()) {
            return;
        }
        EventQueue.invokeLater(new 5());
    }

    private void repaintGUI() {
        if (this._gui == null || !this._gui.isVisible()) {
            return;
        }
        EventQueue.invokeLater(new 4());
    }

    public Component getBottomComponent() {
        return this._horizontalScrollContainer;
    }

    public Object getEditorAttribute(String string) {
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        if (string == "horizontal_scrollbar_policy") {
            return new Integer(31);
        }
        if (string == "vertical_scrollbar_policy") {
            return new Integer(21);
        }
        if ("menu_id".equals(string)) {
            return MergeArb.getString(1);
        }
        return super.getEditorAttribute(string);
    }

    public void open() {
        this._nodeWatcher = new TimestampNodeWatcher(this.getContext().getNode());
        this._nodeWatcher.attach();
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        BaseStyle baseStyle = styleRegistry.lookupStyle("base-plain-style");
        if (baseStyle != null) {
            this._gui.setBackground(baseStyle.getBackgroundColor());
        }
        try {
            this.getContext().getNode().open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        3 var5_5 = new 3();
        var5_5.start();
        this._nodeWatcher.addChangeListener(new 2());
        this._nodeWatcher.resetNodeDirty();
        IdeAction.find((int)RestartMergeCommand.RESTART_MERGE_CMD_ID).updateAction();
    }

    public void close() {
        super.close();
        EventQueue.invokeLater(new 1());
        this.closeGUI();
        this.setNodeChangedWarningVisible(false);
        this._nodeChangePanel = null;
        this._nodeWatcher.detach();
        this._nodeWatcher = null;
    }

    private void closeGUI() {
        this.deinstallUndoableEditListener();
        this.removeGUI();
        this.repaintGUI();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scsmergewindow_html");
    }

    public Component getGUI() {
        return this._gui;
    }

    public Controller getController() {
        return MergeController.getDefaultMergeController();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._statusChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._statusChangeListeners.remove(changeListener);
    }

    public JComponent[] getCustomCells() {
        JComponent[] jComponentArray;
        if (this._statusLabel != null) {
            JComponent[] jComponentArray2 = new JComponent[1];
            jComponentArray = jComponentArray2;
            jComponentArray2[0] = this._statusLabel;
        } else {
            jComponentArray = new JComponent[]{};
        }
        return jComponentArray;
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._view instanceof EditorPaneView) {
            return ((EditorPaneView)this._view).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu == null) {
            return;
        }
        Context context = new Context(this.getContext());
        Node node = context.getNode();
        context.setSelection(new Element[]{node});
        context.setElement((Element)node);
        context.setEvent((EventObject)mouseEvent);
        contextMenu.show(context);
    }

    public void hidePopup(BasicEditorPane basicEditorPane) {
    }

    protected void installUndoableEditListener() {
    }

    protected void deinstallUndoableEditListener() {
    }

    protected Component layoutNorthComponent(Toolbar toolbar) {
        return toolbar;
    }

    protected void initializeToolbar(Toolbar toolbar) {
        toolbar.addSeparator();
        toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)SaveMergeCommand.SAVE_MERGE_CMD)));
        this.initializeToolbarImpl(toolbar);
        toolbar.addSeparator();
        this._nodeChangePanel = new JPanel(new CardLayout());
        JLabel jLabel = new JLabel(MergeArb.getString(14));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setIcon(IdeIcons.getIcon((int)3));
        jLabel.setToolTipText(jLabel.getText());
        jLabel.setAlignmentY(1.0f);
        this._nodeChangePanel.add((Component)new JPanel(), "");
        this._nodeChangePanel.add((Component)jLabel, "");
        toolbar.add((Component)this._nodeChangePanel);
    }

    protected void initializeToolbarImpl(Toolbar toolbar) {
    }

    protected void initializeMergeView(CompareView compareView) {
    }

    protected CompareModel createMergeModel(Context context) {
        this.clearMergeAttributes();
        return this.createMergeModelImpl(context);
    }

    protected abstract CompareModel createMergeModelImpl(Context var1);

    protected abstract boolean restartMergeImpl(Context var1) throws IOException;

    protected void reopen() {
        this.clearMergeAttributes();
        this.close();
        this.open();
    }

    protected abstract boolean saveMergeImpl(Context var1, CompareModel var2) throws IOException;

    protected boolean isNodeDirty() {
        return this._nodeWatcher.isNodeDirty();
    }

    protected Reader createReader() throws IOException {
        return this._nodeWatcher.createReader();
    }

    private void setNodeChangedWarningVisible(boolean bl) {
        if (this._nodeChangePanel == null) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this._nodeChangePanel.getLayout();
        if (bl) {
            cardLayout.last(this._nodeChangePanel);
        } else {
            cardLayout.first(this._nodeChangePanel);
        }
        this.getToolbar().validate();
        this.getToolbar().invalidate();
        this.getToolbar().repaint();
    }

    private void clearMergeAttributes() {
        Attributes attributes = this.getContext().getNode().getAttributes();
        attributes.unset(ATTRIBUTE_MERGE_DIRTY);
        attributes.unset(ATTRIBUTE_MERGE_SAVEABLE);
    }

    public AbstractMergeEditor() {
        this.$init$();
    }

    static JPanel ra$_gui(AbstractMergeEditor abstractMergeEditor) {
        return abstractMergeEditor._gui;
    }

    static JPanel ra$_horizontalScrollContainer(AbstractMergeEditor abstractMergeEditor) {
        return abstractMergeEditor._horizontalScrollContainer;
    }

    static void mav$merge(AbstractMergeEditor abstractMergeEditor, CompareModel compareModel) {
        abstractMergeEditor.merge(compareModel);
    }

    static void mav$repaintGUI(AbstractMergeEditor abstractMergeEditor) {
        abstractMergeEditor.repaintGUI();
    }

    static void mav$setNodeChangedWarningVisible(AbstractMergeEditor abstractMergeEditor, boolean bl) {
        abstractMergeEditor.setNodeChangedWarningVisible(bl);
    }

    static void mav$clearMergeAttributes(AbstractMergeEditor abstractMergeEditor) {
        abstractMergeEditor.clearMergeAttributes();
    }

    public final class 5
    implements Runnable {
        public void run() {
            AbstractMergeEditor.ra$_gui(AbstractMergeEditor.this).invalidate();
            AbstractMergeEditor.ra$_gui(AbstractMergeEditor.this).validate();
            AbstractMergeEditor.ra$_horizontalScrollContainer(AbstractMergeEditor.this).invalidate();
            AbstractMergeEditor.ra$_horizontalScrollContainer(AbstractMergeEditor.this).validate();
        }
    }

    public final class 4
    implements Runnable {
        public void run() {
            AbstractMergeEditor.ra$_gui(AbstractMergeEditor.this).repaint();
            AbstractMergeEditor.ra$_horizontalScrollContainer(AbstractMergeEditor.this).repaint();
        }
    }

    public final class 3
    extends SwingWorker {
        public Object construct() {
            try {
                CompareModel compareModel = AbstractMergeEditor.this.createMergeModel(AbstractMergeEditor.this.getContext());
                try {
                    if (AbstractMergeEditor.this.getContext().getNode() instanceof TextNode) {
                        ((TextNode)AbstractMergeEditor.this.getContext().getNode()).acquireTextBuffer().writeUnlock();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return compareModel;
            }
            catch (Throwable throwable) {
                try {
                    if (AbstractMergeEditor.this.getContext().getNode() instanceof TextNode) {
                        ((TextNode)AbstractMergeEditor.this.getContext().getNode()).acquireTextBuffer().writeUnlock();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public void finished() {
            AbstractMergeEditor.ra$_gui(AbstractMergeEditor.this).setBackground(null);
            if (this.getValue() == null) {
                return;
            }
            AbstractMergeEditor.mav$merge(AbstractMergeEditor.this, (CompareModel)this.getValue());
            AbstractMergeEditor.mav$repaintGUI(AbstractMergeEditor.this);
        }
    }

    public final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractMergeEditor.mav$setNodeChangedWarningVisible(AbstractMergeEditor.this, ((NodeWatcher)((Object)changeEvent.getSource())).isNodeDirty());
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            AbstractMergeEditor.mav$clearMergeAttributes(AbstractMergeEditor.this);
        }
    }

    private abstract class NodeWatcher
    extends ChangeEventSource {
        protected boolean _dirty;
        protected Node _node;

        NodeWatcher(Node node) {
            this._node = node;
        }

        void resetNodeDirty() {
            this._dirty = false;
            this.fireChangeEvent();
        }

        boolean isNodeDirty() {
            return this._dirty;
        }

        abstract void attach();

        abstract void detach();

        abstract Reader createReader() throws IOException;
    }

    private class TimestampNodeWatcher
    extends NodeWatcher
    implements VCSEBComponent {
        private final long _initialTimestamp;

        TimestampNodeWatcher(Node node) {
            super(node);
            this._initialTimestamp = URLFileSystem.lastModified((URL)node.getURL());
        }

        public void handleMessage(VCSEBMessage vCSEBMessage) {
            if (!(vCSEBMessage instanceof VCSNodeUpdate)) {
                return;
            }
            VCSNodeUpdate vCSNodeUpdate = (VCSNodeUpdate)vCSEBMessage;
            if (vCSNodeUpdate.getWhat() == VCSNodeUpdate.RELOADED || vCSNodeUpdate.getWhat() == VCSNodeUpdate.SAVED) {
                this._dirty = URLFileSystem.lastModified((URL)this._node.getURL()) != this._initialTimestamp;
                this.fireChangeEvent();
            }
        }

        void attach() {
            VCSEventBus.addToBus((VCSEBComponent)this);
        }

        void detach() {
            VCSEventBus.removeFromBus((VCSEBComponent)this);
        }

        Reader createReader() throws IOException {
            if (this._node instanceof TextNode) {
                return ((TextNode)this._node).getReader();
            }
            return new FileReader(URLFileSystem.getPlatformPathName((URL)this._node.getURL()));
        }
    }
}

