/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.javatools.compare.CompareView;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.merge.RestartMergeCommand;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdevimpl.compare.CompareController;

public class MergeController
extends CompareController {
    private static MergeController _singleton;

    public static final MergeController getDefaultMergeController() {
        if (_singleton == null) {
            _singleton = new MergeController();
        }
        return _singleton;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this._update(ideAction, context)) {
            if (context.getView() instanceof AbstractMergeEditor && ((AbstractMergeEditor)context.getView()).isCompleteState()) {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return super.handleEvent(ideAction, context);
    }

    private boolean _update(IdeAction ideAction, Context context) {
        if (super.update(ideAction, context)) {
            return true;
        }
        CompareView compareView = this.getCompareView(context);
        if (ideAction.getCommandId() == SaveMergeCommand.SAVE_MERGE_CMD_ID) {
            if (compareView == null) {
                ideAction.setEnabled(false);
            } else {
                int n = compareView.getModel().getConflictCount();
                ideAction.setEnabled(n > 0 && n <= compareView.getModel().getResolvedCount());
            }
            return true;
        }
        if (ideAction.getCommandId() == RestartMergeCommand.RESTART_MERGE_CMD_ID) {
            ideAction.setEnabled(compareView != null);
            return true;
        }
        return false;
    }
}

