/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Attributes;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.compare.view.wedge.WedgeCompareView;
import oracle.javatools.compare.view.wedge.WedgeEditEvent;
import oracle.javatools.compare.view.wedge.WedgeEditListener;
import oracle.javatools.editor.BasicDocument;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdeveloper.merge.TextMergeContributor;
import oracle.jdeveloper.merge.TextMergeNode;

public abstract class TextMergeEditor
extends AbstractMergeEditor
implements WedgeEditListener {
    private NodeUpdater _ancestorUpdater;
    private TextMergeNode _textMergeNode;

    protected void installUndoableEditListener() {
        Node node;
        Document document;
        if (this.getCompareView() instanceof WedgeCompareView) {
            ((WedgeCompareView)this.getCompareView()).addWedgeEditListener(ContributorKind.ANCESTOR, (WedgeEditListener)this);
        }
        Document document2 = document = this.getCompareView() != null && this.getCompareView() instanceof WedgeCompareView ? ((WedgeCompareView)this.getCompareView()).getDocument(ContributorKind.ANCESTOR) : null;
        if (document instanceof BasicDocument && (node = this.getContext().getNode()) != null) {
            this._ancestorUpdater = NodeUpdater.getUpdater((Subject)node, (TextBuffer)((BasicDocument)document).getTextBuffer());
        }
    }

    protected void deinstallUndoableEditListener() {
        if (this.getCompareView() instanceof WedgeCompareView) {
            ((WedgeCompareView)this.getCompareView()).removeWedgeEditListener(ContributorKind.ANCESTOR, (WedgeEditListener)this);
        }
        this._ancestorUpdater = null;
    }

    public void wedgeEditHappened(WedgeEditEvent wedgeEditEvent) {
        this.updateMergeAttributes(null);
        UndoWrapperCommand undoWrapperCommand = new UndoWrapperCommand(wedgeEditEvent.getUndoableEdit(), (Object)this._ancestorUpdater);
        undoWrapperCommand.setContext(this.getContext());
        try {
            CommandProcessor.getInstance().invoke((Command)undoWrapperCommand);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatusLabel();
        IdeAction.find((int)SaveMergeCommand.SAVE_MERGE_CMD_ID).updateAction();
    }

    protected CompareModel createMergeModelImpl(Context context) {
        TextCompareModel textCompareModel = null;
        try {
            textCompareModel = this.createTextMergeModel(context);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            TextMergeContributor textMergeContributor = new TextMergeContributor(TextBufferFactory.createTextBuffer(), "", "");
            TextCompareModel textCompareModel2 = new TextCompareModel((CompareContributor)textMergeContributor, (CompareContributor)textMergeContributor, (CompareContributor)textMergeContributor, new DifferenceBlock[0]);
            return textCompareModel2;
        }
        TextMergeNode textMergeNode = this.getTextMergeNode();
        TextBuffer textBuffer = textMergeNode.acquireTextBuffer();
        textMergeNode.acquireTextBuffer().addTextBufferListener((TextBufferListener)new 1(this, textBuffer));
        textCompareModel.evaluateOffsets();
        if (textCompareModel.getDifferenceCount() <= 0 || URLFileSystem.isReadOnly((URL)context.getNode().getURL())) {
            textMergeNode.acquireTextBuffer().setReadOnly(true);
        }
        return textCompareModel;
    }

    protected boolean restartMergeImpl(Context context) throws IOException {
        if (this.getCompareView() instanceof WedgeCompareView && !this.isCompleteState()) {
            this.deinstallUndoableEditListener();
            ((WedgeCompareView)this.getCompareView()).setModel(this.createMergeModel(context));
            this.installUndoableEditListener();
        } else {
            this.reopen();
        }
        return true;
    }

    protected boolean saveMergeImpl(Context context, CompareModel compareModel) throws IOException {
        return this.saveTextMerge(context, (TextCompareModel)compareModel);
    }

    protected abstract TextCompareModel createTextMergeModel(Context var1) throws IOException;

    protected void setTextMergeNode(TextMergeNode textMergeNode) {
        this._textMergeNode = textMergeNode;
    }

    protected TextMergeNode getTextMergeNode() {
        return this._textMergeNode;
    }

    protected boolean saveTextMerge(Context context, TextCompareModel textCompareModel) throws IOException {
        URL uRL = context.getNode().getURL();
        if (URLFileSystem.isReadOnly((URL)uRL)) {
            return false;
        }
        TextBuffer textBuffer = ((TextCompareContributor)textCompareModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer();
        textBuffer.write((Writer)new FileWriter(URLFileSystem.getPlatformPathName((URL)uRL)));
        new File(URLFileSystem.getPlatformPathName((URL)uRL)).setLastModified(System.currentTimeMillis());
        VirtualFileSystemHelper.invalidateDirectory((URL)URLFileSystem.getParent((URL)uRL));
        if (context.getNode() != null) {
            RevertNodeCommand.reload((Node)context.getNode());
        }
        return true;
    }

    private void updateMergeAttributes(TextBuffer textBuffer) {
        if (this.getCompareView() == null || this.getCompareView().getModel() == null) {
            return;
        }
        Attributes attributes = this.getContext().getNode().getAttributes();
        if (textBuffer != null) {
            if (textBuffer.isModified()) {
                attributes.set(AbstractMergeEditor.ATTRIBUTE_MERGE_DIRTY);
            } else {
                attributes.unset(AbstractMergeEditor.ATTRIBUTE_MERGE_DIRTY);
            }
        }
        if (this.getCompareView() == null || this.getCompareView().getModel() == null) {
            return;
        }
        int n = this.getCompareView().getModel().getResolvedCount();
        if (n > 0) {
            attributes.set(AbstractMergeEditor.ATTRIBUTE_MERGE_DIRTY);
        }
        if (this.getCompareView().getModel().getConflictCount() - n <= 0) {
            attributes.set(AbstractMergeEditor.ATTRIBUTE_MERGE_SAVEABLE);
        } else {
            attributes.unset(AbstractMergeEditor.ATTRIBUTE_MERGE_SAVEABLE);
        }
    }

    static void mav$updateMergeAttributes(TextMergeEditor textMergeEditor, TextBuffer textBuffer) {
        textMergeEditor.updateMergeAttributes(textBuffer);
    }

    public final class 1
    implements TextBufferListener {
        private final /* synthetic */ TextBuffer v$mergeTextBuffer;
        final /* synthetic */ TextMergeEditor this$0;

        public void attributeUpdate(TextBuffer textBuffer, int n) {
            if (n == 5) {
                TextMergeEditor.mav$updateMergeAttributes(this.this$0, this.v$mergeTextBuffer);
            }
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        }

        public 1(TextMergeEditor textMergeEditor, TextBuffer textBuffer) {
            this.v$mergeTextBuffer = textBuffer;
            this.this$0 = textMergeEditor;
        }
    }
}

