/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;

public class ContentFolder {
    private final URL ROOT_URL;
    private final URL CONTENT_FOLDER_URL;
    private final String RELATIVE_PATH;
    private ArrayList _filters;
    private boolean _includeSubfolders;
    private static final int INCLUDE_FILTERS = 0;
    private static final int EXCLUDE_FILTERS = 1;

    public ContentFolder(URL uRL) {
        this(null, uRL, null);
    }

    public ContentFolder(URL uRL, PatternFilter[] patternFilterArray) {
        this(null, uRL, patternFilterArray);
    }

    public ContentFolder(URL uRL, URL uRL2) {
        this(uRL, uRL2, null);
    }

    public ContentFolder(URL uRL, URL uRL2, PatternFilter[] patternFilterArray) {
        if (uRL2 == null) {
            throw new IllegalArgumentException("The srcRootURL cannot be null.");
        }
        if (uRL != null && URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true) == null) {
            throw new IllegalArgumentException("The content folder is not under the specified source root.");
        }
        this._includeSubfolders = true;
        this.ROOT_URL = uRL2;
        this.CONTENT_FOLDER_URL = uRL == null ? uRL2 : uRL;
        String string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true);
        this.RELATIVE_PATH = string == null || "".equals(string) ? "" : (string.endsWith("/") ? string : string + "/");
        this.setFilters(patternFilterArray);
    }

    public PatternFilter getPrimaryIncludeFilter() {
        if (this.isIncludeSubfolders()) {
            return PatternFilter.newInclude((String)this.recursivePattern());
        }
        return PatternFilter.newInclude((String)this.nonRecursivePattern());
    }

    private String recursivePattern() {
        return this.RELATIVE_PATH.length() == 0 ? "**" : this.RELATIVE_PATH;
    }

    private String nonRecursivePattern() {
        return this.RELATIVE_PATH.length() == 0 ? "*" : this.RELATIVE_PATH + "*";
    }

    void addRelativeExcludeFilter(String string) {
        PatternFilter patternFilter = PatternFilter.newExclude((String)(this.RELATIVE_PATH + string));
        this.addFilter(patternFilter);
    }

    void removeRelativeExcludeFilter(String string) {
        if (this._filters != null) {
            String string2 = this.RELATIVE_PATH + string;
            PatternFilter patternFilter = PatternFilter.newExclude((String)string2);
            this._filters.remove(patternFilter);
        }
    }

    void addFilter(PatternFilter patternFilter) {
        if (patternFilter == null) {
            throw new IllegalArgumentException();
        }
        if (this._filters == null) {
            this._filters = new ArrayList();
        }
        if (!this._filters.contains(patternFilter)) {
            if (patternFilter.isInclude()) {
                this._filters.remove(PatternFilter.newInclude((String)"**"));
                this._filters.remove(PatternFilter.newInclude((String)this.RELATIVE_PATH));
                this._filters.add(patternFilter);
            } else {
                this._filters.add(0, patternFilter);
            }
        }
    }

    void addRelativeIncludeFilter(String string) {
        PatternFilter patternFilter = PatternFilter.newInclude((String)(this.RELATIVE_PATH + string));
        this.addFilter(patternFilter);
    }

    void removeRelativeIncludeFilter(String string) {
        if (this._filters != null) {
            String string2 = this.RELATIVE_PATH + string;
            PatternFilter patternFilter = PatternFilter.newInclude((String)string2);
            this._filters.remove(patternFilter);
            if (this._filters.size() == 0) {
                this._filters.add(this.getPrimaryIncludeFilter());
            }
        }
    }

    public URL getRootURL() {
        return this.ROOT_URL;
    }

    public URL getContentFolderURL() {
        return this.CONTENT_FOLDER_URL;
    }

    boolean isIncludeSubfolders() {
        return this._includeSubfolders;
    }

    void setIncludeSubfolders(boolean bl) {
        this._includeSubfolders = bl;
    }

    ArrayList getIncludeFilters() {
        return this.getDisplayedFilters(0);
    }

    ArrayList getExcludeFilters() {
        return this.getDisplayedFilters(1);
    }

    boolean isExcludeAll() {
        return this._filters != null && this._filters.size() == 0;
    }

    public PatternFilter[] getAllFilters() {
        PatternFilter patternFilter;
        if (this._filters == null) {
            this._filters = new ArrayList();
            this._filters.add(this.getPrimaryIncludeFilter());
        }
        if (this._filters.size() == 0) {
            return new PatternFilter[0];
        }
        PatternFilter patternFilter2 = PatternFilter.newInclude((String)this.nonRecursivePattern());
        if (this._filters.contains(patternFilter2)) {
            this._filters.remove(patternFilter2);
        }
        if (this._filters.contains(patternFilter = PatternFilter.newInclude((String)"**"))) {
            this._filters.remove(patternFilter);
        }
        boolean bl = false;
        int n = this._filters.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            PatternFilter patternFilter3 = (PatternFilter)this._filters.get(n2);
            if (patternFilter3.isInclude()) {
                bl = true;
                break;
            }
            --n2;
        }
        if (!bl) {
            this._filters.add(this.getPrimaryIncludeFilter());
        }
        PatternFilter[] patternFilterArray = new PatternFilter[this._filters.size()];
        this._filters.toArray(patternFilterArray);
        if (patternFilterArray[0].isInclude()) {
            return patternFilterArray;
        }
        if (patternFilterArray.length == 1 || patternFilterArray[patternFilterArray.length - 1].isExclude()) {
            PatternFilter[] patternFilterArray2 = new PatternFilter[patternFilterArray.length + 1];
            System.arraycopy(patternFilterArray, 0, patternFilterArray2, 0, patternFilterArray.length);
            patternFilterArray2[patternFilterArray.length] = this.getPrimaryIncludeFilter();
            return patternFilterArray2;
        }
        return patternFilterArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentFolder)) {
            return false;
        }
        ContentFolder contentFolder = (ContentFolder)object;
        this._includeSubfolders = contentFolder._includeSubfolders && URLFileSystem.equals((URL)this.ROOT_URL, (URL)contentFolder.ROOT_URL) && URLFileSystem.equals((URL)this.CONTENT_FOLDER_URL, (URL)contentFolder.CONTENT_FOLDER_URL) && (this._filters != null && contentFolder._filters != null && this._filters.equals(contentFolder._filters) || this._filters == null && contentFolder._filters == null);
        return this._includeSubfolders;
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName((URL)this.CONTENT_FOLDER_URL);
    }

    private void setFilters(PatternFilter[] patternFilterArray) {
        if (patternFilterArray == null) {
            return;
        }
        if (this._filters == null) {
            this._filters = new ArrayList();
        }
        int n = 0;
        while (n < patternFilterArray.length) {
            this._filters.add(patternFilterArray[n]);
            ++n;
        }
        this._includeSubfolders = this._filters.contains(PatternFilter.newInclude((String)this.nonRecursivePattern())) ^ true;
    }

    private ArrayList getDisplayedFilters(int n) {
        ArrayList<PatternFilter> arrayList = new ArrayList<PatternFilter>();
        if (this._filters != null) {
            for (PatternFilter patternFilter : this._filters) {
                PatternFilter patternFilter2;
                String string;
                String string2 = patternFilter.getPattern();
                if (string2.startsWith(this.RELATIVE_PATH)) {
                    if (string2.equals(this.RELATIVE_PATH)) continue;
                    string = string2.substring(this.RELATIVE_PATH.length());
                } else {
                    string = string2;
                }
                if (string.length() <= 0 || string.endsWith("*")) continue;
                if (patternFilter.isInclude() && n == 0) {
                    patternFilter2 = PatternFilter.newInclude((String)string);
                    arrayList.add(patternFilter2);
                    continue;
                }
                if (!patternFilter.isExclude() || n != 1) continue;
                patternFilter2 = PatternFilter.newExclude((String)string);
                arrayList.add(patternFilter2);
            }
        }
        return arrayList;
    }
}

