/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetFilterChooser
extends DefaultTraversablePanel {
    static final int FOLDERS_ONLY = 0;
    static final int FOLDERS_AND_FILES = 1;
    static final int APPROVE_OPTION = 0;
    static final int CANCEL_OPTION = 1;
    static final int ERROR_OPTION = 2;
    private final int SCOPE;
    private final URLPath PATH;
    private final Icon FOLDER_ICON;
    private final Icon FILE_ICON;
    private final URLNode ROOT_NODE;
    private final DefaultTreeModel TREE_MODEL;
    private final JScrollPane SCROLLER;
    private JDevDialogHeader _header;
    private static URLFilter _filter = GlobalIgnoreList.getURLFilter();
    private JTree _tree;
    private KeyNavigationManager keyMgr;
    private transient JEWTDialog _dialog;

    void $init$() {
        this.FOLDER_ICON = IdeIcons.getIcon((int)4);
        this.FILE_ICON = IdeIcons.getIcon((int)2);
        this.ROOT_NODE = new URLNode("", true);
        this.TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
        this.SCROLLER = new JScrollPane();
        this._header = new JDevDialogHeader();
    }

    ContentSetFilterChooser(int n, URLPath uRLPath) {
        this.$init$();
        this.SCOPE = n;
        this.PATH = uRLPath;
        this.ROOT_NODE.buildChildren();
        this.getTree();
        this.TREE_MODEL.nodeStructureChanged(this.ROOT_NODE);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new TCR(null));
        TreeHandler treeHandler = new TreeHandler(null);
        this._tree.addTreeSelectionListener(treeHandler);
        this._tree.addTreeWillExpandListener(treeHandler);
        this.SCROLLER.getViewport().add((Component)this._tree, null);
        this._tree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add(this.SCROLLER, "Center");
    }

    String[] getSelections() {
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        int n = treePathArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            URLNode uRLNode = (URLNode)treePathArray[n2].getLastPathComponent();
            if (uRLNode != null) {
                arrayList.add(uRLNode.getRelPath());
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    int showDialog(Component component, boolean bl) {
        String string;
        String string2;
        String string3;
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), this.getHelpId(bl));
        String string4 = string3 = bl ? ModelArb.getString(108) : ModelArb.getString(109);
        if (this.SCOPE == 1) {
            string2 = ModelArb.getString(111);
            string = bl ? ModelArb.getString(113) : ModelArb.getString(115);
        } else {
            string2 = ModelArb.getString(110);
            string = bl ? ModelArb.getString(112) : ModelArb.getString(114);
        }
        try {
            TreeSelectionModel treeSelectionModel = this._tree.getSelectionModel();
            treeSelectionModel.setSelectionMode(4);
            Frame frame = IdeUtil.findFrame((Component)component);
            this._dialog = new JEWTDialog(frame, string3, 7);
            this._header.setHeaderTitle(string2);
            this._header.setHeaderDescription(string);
            this._dialog.setDialogHeader((Component)this._header);
            this._dialog.setContent((Component)((Object)this));
            this._dialog.setResizable(true);
            this._dialog.setInitialFocus((Component)this._tree);
            this.updateOKButton();
            boolean bl2 = WizardLauncher.runDialog((JDialog)this._dialog);
            this._dialog.dispose();
            this._dialog = null;
            int n = bl2 ? 0 : 1;
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int n = 2;
            return n;
        }
    }

    JTree getTree() {
        if (this._tree == null) {
            this._tree = new 2(this.TREE_MODEL);
            this.keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TreeKeyAdapter(this._tree));
            this._tree.setExpandsSelectedPaths(true);
            this._tree.setScrollsOnExpand(true);
            this._tree.addMouseListener(new 1());
        }
        return this._tree;
    }

    private void updateOKButton() {
        if (this._dialog != null) {
            URLNode uRLNode;
            TreePath treePath = this._tree.getSelectionPath();
            if (treePath != null && (uRLNode = (URLNode)treePath.getLastPathComponent()) != null) {
                this._dialog.setOKButtonEnabled(this.SCOPE == 1 || this.SCOPE == 0 && uRLNode.isPackage());
                return;
            }
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private String getHelpId(boolean bl) {
        if (bl) {
            return "f1_idedaddincludefilters_html";
        }
        return "f1_idedaddexcludefilters_html";
    }

    static KeyNavigationManager ra$keyMgr(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.keyMgr;
    }

    static JEWTDialog ra$_dialog(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser._dialog;
    }

    static URLPath ra$PATH(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.PATH;
    }

    static int ra$SCOPE(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.SCOPE;
    }

    static URLFilter ra$_filter() {
        return _filter;
    }

    static DefaultTreeModel ra$TREE_MODEL(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.TREE_MODEL;
    }

    static Icon ra$FOLDER_ICON(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.FOLDER_ICON;
    }

    static Icon ra$FILE_ICON(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.FILE_ICON;
    }

    static void mav$updateOKButton(ContentSetFilterChooser contentSetFilterChooser) {
        contentSetFilterChooser.updateOKButton();
    }

    public final class 2
    extends JTree {
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this) != null) {
                ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this).preProcessKeyEvent(keyEvent);
            }
            super.processKeyEvent(keyEvent);
            if (ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this) != null) {
                ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this).postProcessKeyEvent(keyEvent);
            }
        }

        public 2(TreeModel treeModel) {
            super(treeModel);
        }
    }

    public final class 1
    extends MouseAdapter {
        int y;

        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            int n = mouseEvent.getClickCount();
            if (n == 1) {
                this.y = mouseEvent.getY();
            }
            if (this.y == mouseEvent.getY() && n == 2 && (treePath = ((JTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && ((DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                ContentSetFilterChooser.ra$_dialog(ContentSetFilterChooser.this).closeDialog(false);
            }
        }
    }

    private class URLNode
    extends DefaultMutableTreeNode {
        private final String _relPath;
        private final boolean _isPackage;
        private String _name;
        private boolean _isExpanded;

        URLNode(String string, boolean bl) {
            this._relPath = string;
            this._isPackage = bl;
        }

        public String toString() {
            if (this._name == null) {
                int n = this._relPath.lastIndexOf("/");
                this._name = n >= 0 ? this._relPath.substring(n + 1) : this._relPath;
            }
            return this._name;
        }

        public boolean isLeaf() {
            return this._isPackage ^ true;
        }

        boolean isPackage() {
            return this._isPackage;
        }

        Icon getIcon() {
            return this._isPackage ? ContentSetFilterChooser.ra$FOLDER_ICON(ContentSetFilterChooser.this) : ContentSetFilterChooser.ra$FILE_ICON(ContentSetFilterChooser.this);
        }

        boolean isExpanded() {
            return this._isExpanded;
        }

        String getRelPath() {
            return this._isPackage ? this._relPath + "/" : this._relPath;
        }

        URLNode findChild(String string) {
            if (string == null) {
                return null;
            }
            if (!this._isExpanded) {
                this.buildChildren();
            }
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                URLNode uRLNode = (URLNode)enumeration.nextElement();
                if (!string.equals(uRLNode.toString())) continue;
                return uRLNode;
            }
            return null;
        }

        void buildChildren() {
            List list = ContentSetFilterChooser.ra$PATH(ContentSetFilterChooser.this).getDirectories(this._relPath);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                URLNode uRLNode = new URLNode(string, true);
                this.add(uRLNode);
            }
            if (ContentSetFilterChooser.ra$SCOPE(ContentSetFilterChooser.this) == 1) {
                List list2 = ContentSetFilterChooser.ra$PATH(ContentSetFilterChooser.this).getFiles(this._relPath);
                for (URL uRL : list2) {
                    if (!ContentSetFilterChooser.ra$_filter().accept(uRL)) continue;
                    String string = ContentSetFilterChooser.ra$PATH(ContentSetFilterChooser.this).toRelativePath(uRL);
                    URLNode uRLNode = new URLNode(string, false);
                    this.add(uRLNode);
                }
            }
            ContentSetFilterChooser.ra$TREE_MODEL(ContentSetFilterChooser.this).nodeStructureChanged(this);
            this._isExpanded = true;
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            URLNode uRLNode = (URLNode)object;
            jLabel.setIcon(uRLNode.getIcon());
            return jLabel;
        }

        private TCR() {
        }

        TCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeHandler
    implements TreeWillExpandListener,
    TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ContentSetFilterChooser.mav$updateOKButton(ContentSetFilterChooser.this);
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            URLNode uRLNode = (URLNode)treePath.getLastPathComponent();
            if (uRLNode != null && !uRLNode.isExpanded()) {
                uRLNode.buildChildren();
            }
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }

        private TreeHandler() {
        }

        TreeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

