/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterChooser;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;

public class ContentSetFilterPanel
extends JTabbedPane {
    private static final String EMPTY_FILTER_LIST = ModelArb.getString(104);
    private static final String NO_EXCLUSIONS = ModelArb.getString(100);
    private static final String NO_COMMON_EXCLUSIONS = ModelArb.getString(101);
    private static final String NO_INCLUSIONS = ModelArb.getString(102);
    private static final String NO_COMMON_INCLUSIONS = ModelArb.getString(103);
    private static final Icon ICON_INCLUDE = ModelArb.getIcon(106);
    private static final Icon ICON_EXCLUDE = ModelArb.getIcon(107);
    private FilterPanel _inclusionsTab;
    private FilterPanel _exclusionsTab;
    private ContentFolder[] _activeContentFlders;

    public ContentSetFilterPanel() {
        try {
            this._inclusionsTab = new FilterPanel(true);
            this._exclusionsTab = new FilterPanel(false);
            this.add(ModelArb.getString(98), this._inclusionsTab);
            this.add(ModelArb.getString(99), this._exclusionsTab);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setData(ContentFolder[] contentFolderArray) {
        this._inclusionsTab.loadFrom(contentFolderArray);
        this._exclusionsTab.loadFrom(contentFolderArray);
    }

    void refreshAllFilters() {
        FilterPanel.mav$refreshFilters(this._inclusionsTab);
        FilterPanel.mav$refreshFilters(this._exclusionsTab);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        FilterPanel.mav$enableControls(this._inclusionsTab);
        FilterPanel.mav$enableControls(this._exclusionsTab);
    }

    static ContentFolder[] ra$_activeContentFlders(ContentSetFilterPanel contentSetFilterPanel) {
        return contentSetFilterPanel._activeContentFlders;
    }

    static String ra$EMPTY_FILTER_LIST() {
        return EMPTY_FILTER_LIST;
    }

    static Icon ra$ICON_EXCLUDE() {
        return ICON_EXCLUDE;
    }

    static Icon ra$ICON_INCLUDE() {
        return ICON_INCLUDE;
    }

    static String ra$NO_EXCLUSIONS() {
        return NO_EXCLUSIONS;
    }

    static String ra$NO_COMMON_EXCLUSIONS() {
        return NO_COMMON_EXCLUSIONS;
    }

    static String ra$NO_INCLUSIONS() {
        return NO_INCLUSIONS;
    }

    static String ra$NO_COMMON_INCLUSIONS() {
        return NO_COMMON_INCLUSIONS;
    }

    static void wa$_activeContentFlders(ContentSetFilterPanel contentSetFilterPanel, ContentFolder[] contentFolderArray) {
        contentSetFilterPanel._activeContentFlders = contentFolderArray;
    }

    private class FilterPanel
    extends JPanel
    implements ListSelectionListener,
    ItemListener,
    ActionListener {
        private final JButton _addFilterButton;
        private final JButton _removeFilterButton;
        private final DefaultListModel _filterListModel;
        private final JList _filterList;
        private final JScrollPane _scroller;
        private final GridBagLayout layout;
        private final JCheckBox _includeSubFolders;
        private FilterListCellRenderer _cellRenderer;
        private boolean _includeExcludeMode;

        void $init$() {
            this._addFilterButton = new JButton();
            this._removeFilterButton = new JButton();
            this._filterListModel = new DefaultListModel();
            this._filterList = new JList(this._filterListModel);
            this._scroller = new JScrollPane(this._filterList);
            this.layout = new GridBagLayout();
            this._includeSubFolders = new JCheckBox();
        }

        FilterPanel(boolean bl) throws Exception {
            this.$init$();
            ContentSetFilterPanel.wa$_activeContentFlders(ContentSetFilterPanel.this, new ContentFolder[0]);
            this._includeExcludeMode = bl;
            this.jbInit();
        }

        public void loadFrom(ContentFolder[] contentFolderArray) {
            ContentSetFilterPanel.wa$_activeContentFlders(ContentSetFilterPanel.this, contentFolderArray);
            this.refreshInclude();
            this.refreshFilters();
        }

        private FilterListCellRenderer getCellRenderer(Icon icon) {
            if (this._cellRenderer == null) {
                this._cellRenderer = new FilterListCellRenderer(icon);
            }
            return this._cellRenderer;
        }

        private void enableControls() {
            if (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 0) {
                this._filterList.setEnabled(false);
                this._includeSubFolders.setEnabled(false);
                this._addFilterButton.setEnabled(false);
                this._removeFilterButton.setEnabled(false);
            } else {
                this._filterList.setEnabled(true);
                this._addFilterButton.setEnabled(true);
                this._includeSubFolders.setEnabled(true);
                int n = this._filterList.getSelectedIndices().length;
                Object e = this._filterList.getSelectedValue();
                if (e == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                    this._removeFilterButton.setEnabled(true);
                } else if (n > 1 || n == 1 && ContentSetFilterPanel.ra$NO_EXCLUSIONS() != e && ContentSetFilterPanel.ra$NO_COMMON_EXCLUSIONS() != e && ContentSetFilterPanel.ra$NO_COMMON_INCLUSIONS() != e && ContentSetFilterPanel.ra$NO_INCLUSIONS() != e) {
                    this._removeFilterButton.setEnabled(true);
                    this._includeSubFolders.setEnabled(false);
                } else {
                    this._removeFilterButton.setEnabled(false);
                    this._includeSubFolders.setEnabled(true);
                }
            }
        }

        private void setCheckboxState(TriStateBoolean triStateBoolean) {
            boolean bl = triStateBoolean.isTriState();
            if (!bl) {
                this._includeSubFolders.setSelected(triStateBoolean.isTrue());
            }
            ButtonModel buttonModel = this._includeSubFolders.getModel();
            buttonModel.setArmed(bl);
            buttonModel.setPressed(bl);
        }

        private void refreshInclude() {
            if (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this) == null || ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 0) {
                return;
            }
            boolean bl = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[0].isIncludeSubfolders();
            TriStateBoolean triStateBoolean = bl ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
            int n = 0;
            while (n < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                if (bl != ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n].isIncludeSubfolders()) {
                    triStateBoolean = TriStateBoolean.TRI_STATE;
                    break;
                }
                ++n;
            }
            this.setCheckboxState(triStateBoolean);
        }

        private void refreshFilters() {
            this._filterListModel.clear();
            ArrayList arrayList = null;
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                ContentFolder contentFolder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n];
                ArrayList arrayList3 = this.isExclude() ? contentFolder.getExcludeFilters() : contentFolder.getIncludeFilters();
                for (PatternFilter patternFilter : arrayList3) {
                    this.addFilterToGroup(arrayList2, patternFilter.getPattern(), contentFolder);
                }
                if (arrayList != null) {
                    arrayList.retainAll(arrayList2);
                } else {
                    arrayList = new ArrayList(arrayList2);
                }
                arrayList2.clear();
                ++n;
            }
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this._filterListModel.addElement(iterator.next());
                }
            }
            if (this._filterListModel.size() == 0) {
                String string = this.isExclude() ? (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 1 ? (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[0].isExcludeAll() ? ContentSetFilterPanel.ra$EMPTY_FILTER_LIST() : ContentSetFilterPanel.ra$NO_EXCLUSIONS()) : ContentSetFilterPanel.ra$NO_COMMON_EXCLUSIONS()) : (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 1 ? ContentSetFilterPanel.ra$NO_INCLUSIONS() : ContentSetFilterPanel.ra$NO_COMMON_INCLUSIONS());
                this._filterListModel.addElement(string);
            }
            this._filterList.setSelectedIndex(0);
        }

        private void addFilterToGroup(ArrayList arrayList, String string, ContentFolder contentFolder) {
            for (FilterGroup filterGroup : arrayList) {
                if (!filterGroup._pattern.equals(string)) continue;
                filterGroup._contentFolders.add(contentFolder);
                return;
            }
            FilterGroup filterGroup = new FilterGroup(contentFolder, string);
            filterGroup._contentFolders.add(contentFolder);
            arrayList.add(filterGroup);
        }

        private boolean isInclude() {
            return true == this._includeExcludeMode;
        }

        private boolean isExclude() {
            return false == this._includeExcludeMode;
        }

        private void jbInit() throws Exception {
            ResourceUtils.resButton((AbstractButton)this._includeSubFolders, (String)ModelArb.getString(89));
            ResourceUtils.resButton((AbstractButton)this._addFilterButton, (String)ModelArb.getString(96));
            ResourceUtils.resButton((AbstractButton)this._removeFilterButton, (String)ModelArb.getString(97));
            this._includeSubFolders.addItemListener(this);
            this._addFilterButton.addActionListener(this);
            this._removeFilterButton.addActionListener(this);
            this._filterList.addListSelectionListener(this);
            this._filterList.setCellRenderer(this.getCellRenderer(this.isExclude() ? ContentSetFilterPanel.ra$ICON_EXCLUDE() : ContentSetFilterPanel.ra$ICON_INCLUDE()));
            this._filterList.getSelectionModel().setSelectionMode(2);
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Insets insets = new Insets(0, 0, 0, 0);
            Insets insets2 = new Insets(0, 0, 4, 0);
            Insets insets3 = new Insets(0, 8, 5, 0);
            Insets insets4 = new Insets(0, 8, 0, 0);
            int n = -1;
            if (this.isInclude()) {
                this.add((Component)this._includeSubFolders, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
            }
            this.add((Component)this._scroller, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 10, 1, insets, 0, 0));
            this.add((Component)this._addFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, insets3, 0, 0));
            this.add((Component)this._removeFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 12, 2, insets4, 0, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._addFilterButton) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetFilterPanel.this);
                waitCursor.show();
                URL[] uRLArray = new URL[ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length];
                int n = 0;
                while (n < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    uRLArray[n] = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n].getContentFolderURL();
                    ++n;
                }
                URLPath uRLPath = new URLPath(uRLArray);
                int n2 = uRLArray.length > 1 ? 0 : 1;
                ContentSetFilterChooser contentSetFilterChooser = new ContentSetFilterChooser(n2, uRLPath);
                contentSetFilterChooser.setPreferredSize(new Dimension(300, 225));
                waitCursor.hide();
                int[] nArray = new int[]{};
                if (contentSetFilterChooser.showDialog(this.getParent(), this.isInclude()) == 0) {
                    String[] stringArray = contentSetFilterChooser.getSelections();
                    nArray = new int[stringArray.length];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string = stringArray[n3];
                        int n4 = 0;
                        while (n4 < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                            ContentFolder contentFolder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n4];
                            if (this.isExclude()) {
                                contentFolder.addRelativeExcludeFilter(string);
                            } else {
                                contentFolder.addRelativeIncludeFilter(string);
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ContentSetFilterPanel.this.refreshAllFilters();
                    int n5 = this._filterListModel.size();
                    int n6 = n5 - nArray.length;
                    int n7 = 0;
                    while (n7 < nArray.length) {
                        nArray[n7] = n6++;
                        ++n7;
                    }
                    this._filterList.setSelectedIndices(nArray);
                }
            } else if (object == this._removeFilterButton) {
                int n = this._filterList.getSelectedIndex();
                int n8 = 0;
                while (n8 < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    ContentFolder contentFolder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n8];
                    Object[] objectArray = this._filterList.getSelectedValues();
                    int n9 = 0;
                    while (n9 < objectArray.length) {
                        if (objectArray[n9] == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                            contentFolder.addFilter(contentFolder.getPrimaryIncludeFilter());
                        } else {
                            FilterGroup filterGroup = (FilterGroup)objectArray[n9];
                            if (this.isExclude()) {
                                contentFolder.removeRelativeExcludeFilter(filterGroup._pattern);
                            } else {
                                contentFolder.removeRelativeIncludeFilter(filterGroup._pattern);
                            }
                        }
                        ++n9;
                    }
                    ++n8;
                }
                ContentSetFilterPanel.this.refreshAllFilters();
                int n10 = this._filterListModel.size();
                if (n10 > 0 && n <= n10) {
                    if (n == n10) {
                        --n;
                    }
                    this._filterList.setSelectedIndex(n);
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.enableControls();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this._includeSubFolders) {
                boolean bl = this._includeSubFolders.isSelected();
                int n = 0;
                while (n < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    ContentFolder contentFolder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[n];
                    contentFolder.setIncludeSubfolders(bl);
                    ++n;
                }
                this.refreshInclude();
            }
        }

        static void mav$enableControls(FilterPanel filterPanel) {
            filterPanel.enableControls();
        }

        static void mav$refreshFilters(FilterPanel filterPanel) {
            filterPanel.refreshFilters();
        }
    }

    private static class FilterGroup {
        private final char SEPARATOR_CHAR;
        final boolean _isFolderFilter;
        final String _pattern;
        final String _displayPattern;
        final ArrayList _contentFolders;

        void $init$() {
            this.SEPARATOR_CHAR = File.separatorChar;
        }

        FilterGroup(ContentFolder contentFolder, String string) {
            URLPath uRLPath;
            this.$init$();
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this._pattern = string;
            this._contentFolders = new ArrayList();
            this._isFolderFilter = !string.endsWith("/") ? URLFileSystem.isDirectory((URL)(uRLPath = new URLPath(contentFolder.getRootURL())).toQualifiedURL(string)) : true;
            String string2 = this._pattern.endsWith("/") ? this._pattern.substring(0, this._pattern.length() - 1) : this._pattern;
            this._displayPattern = string2.replace('/', this.SEPARATOR_CHAR);
        }

        public String toString() {
            return this._displayPattern;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            return this._pattern.equals(((FilterGroup)object)._pattern);
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }
    }

    private static class FilterListCellRenderer
    extends DefaultListCellRenderer {
        private OverlayedIcon _folderIcon;
        private OverlayedIcon _fileIcon;
        private Icon _warningIcon;

        void $init$() {
            this._warningIcon = CommonIconsUtils.getWarningIcon();
        }

        FilterListCellRenderer(Icon icon) {
            this.$init$();
            this._folderIcon = new OverlayedIcon(icon, IdeIcons.getIcon((int)4));
            this._fileIcon = new OverlayedIcon(icon, IdeIcons.getIcon((int)2));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof FilterGroup) {
                if (((FilterGroup)object)._isFolderFilter) {
                    jLabel.setIcon(this._folderIcon);
                } else {
                    jLabel.setIcon(this._fileIcon);
                }
            } else if (object == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                jLabel.setIcon(this._warningIcon);
            } else if (!(object instanceof String)) {
                System.err.println("**** Warning. Unrecognized list item type: " + (object != null ? object.getClass() : null));
            }
            return jLabel;
        }
    }
}

