/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterPanel;
import oracle.jdeveloper.model.ContentSetValidator;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetPanel
extends JPanel {
    private final JButton ADD_CONTENT_BUTTON;
    private final JButton REMOVE_CONTENT_BUTTON;
    private final JButton MOVE_UP_BUTTON;
    private final JButton MOVE_DOWN_BUTTON;
    private final JLabel CONTENT_SET_LABEL;
    private final DefaultListModel CONTENT_LIST_MODEL;
    private final JList _contentList;
    private final ContentSetFilterPanel FILTER_TABS;
    private final InteractionListener INTERACTION_LISTENER;
    private final LCR CELL_RENDERER;
    private URLChooser _contentChooser;
    private boolean _updating;
    private ContentSet _contentSet;
    private ContentSetValidator _validator;
    private URL _projectURL;
    private ContentFolder[] _activeContentFlders;
    private static final Icon FOLDER_ICON = IdeIcons.getIcon((int)4);

    void $init$() {
        this.ADD_CONTENT_BUTTON = new JButton();
        this.REMOVE_CONTENT_BUTTON = new JButton();
        this.MOVE_UP_BUTTON = new JButton();
        this.MOVE_DOWN_BUTTON = new JButton();
        this.CONTENT_SET_LABEL = new JLabel();
        this.CONTENT_LIST_MODEL = new DefaultListModel();
        this._contentList = new JList(this.CONTENT_LIST_MODEL);
        this.FILTER_TABS = new ContentSetFilterPanel();
        this.INTERACTION_LISTENER = new InteractionListener(null);
        this.CELL_RENDERER = new LCR(null);
    }

    public ContentSetPanel() {
        this((ContentSetValidator)null);
    }

    public ContentSetPanel(ContentSetValidator contentSetValidator) {
        this.$init$();
        this._validator = contentSetValidator;
        this._activeContentFlders = new ContentFolder[0];
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setContentSetLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.CONTENT_SET_LABEL, (Component)this._contentList, (String)string);
    }

    public void setValidator(ContentSetValidator contentSetValidator) {
        this._validator = contentSetValidator;
    }

    public ContentSetValidator getValidator() {
        return this._validator;
    }

    public void loadFrom(Project project, ContentSet contentSet) {
        this._projectURL = project.getURL();
        this._contentSet = contentSet;
        this.CONTENT_LIST_MODEL.clear();
        URLPath uRLPath = this._contentSet.getURLPath();
        if (uRLPath.size() > 0) {
            this.populateContentList(this._contentSet);
        }
        int n = this._contentSet.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            ContentSet contentSet2 = this._contentSet.getContentSet(n2);
            this.populateContentList(contentSet2);
            ++n2;
        }
        if (this.CONTENT_LIST_MODEL.size() > 0) {
            this._contentList.setSelectedIndex(0);
        }
        this.enableControls();
    }

    public void saveContentSet() throws EmptyContentSetException {
        Object[] objectArray = this.CONTENT_LIST_MODEL.toArray();
        ContentSet contentSet = new ContentSet(HashStructure.newInstance());
        this._contentSet.copyTo((Object)contentSet);
        if (objectArray.length == 0) {
            throw new EmptyContentSetException();
        }
        if (objectArray.length == 1) {
            ContentFolder contentFolder = (ContentFolder)objectArray[0];
            contentSet.removeAllContentSets();
            this.persistContentSet(contentFolder, contentSet);
        } else {
            contentSet.getURLPath().setEntries(null);
            contentSet.getPatternFilters().setFilters(null);
            contentSet.removeAllContentSets();
            int n = 0;
            while (n < objectArray.length) {
                ContentFolder contentFolder = (ContentFolder)objectArray[n];
                ContentSet contentSet2 = new ContentSet(HashStructure.newInstance());
                contentSet.addContentSet(contentSet2);
                this.persistContentSet(contentFolder, contentSet2);
                ++n;
            }
        }
        if (!contentSet.equals((Object)this._contentSet)) {
            this._contentSet.getURLPath().setEntries(null);
            this._contentSet.getPatternFilters().setFilters(null);
            this._contentSet.removeAllContentSets();
            contentSet.copyTo((Object)this._contentSet);
        }
    }

    public void hideUpDownButtons() {
        this.MOVE_UP_BUTTON.setVisible(false);
        this.MOVE_DOWN_BUTTON.setVisible(false);
    }

    boolean addFolderToContentSet(URL uRL) {
        return this.addFolderToContentSet(uRL, uRL);
    }

    boolean addFolderToContentSet(URL uRL, URL uRL2) {
        String string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true);
        if (string == null) {
            return false;
        }
        if (this.contentSetContainsURL(uRL)) {
            return false;
        }
        ContentFolder contentFolder = new ContentFolder(uRL, uRL2);
        this.CONTENT_LIST_MODEL.addElement(contentFolder);
        return true;
    }

    URLPath getURLPath() {
        URLPath uRLPath = new URLPath();
        Object[] objectArray = this.CONTENT_LIST_MODEL.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ContentFolder contentFolder = (ContentFolder)objectArray[n];
            URL uRL = contentFolder.getRootURL();
            uRLPath.add(uRL);
            ++n;
        }
        return uRLPath;
    }

    public boolean contentSetContainsURL(URL uRL) {
        Object[] objectArray = this.CONTENT_LIST_MODEL.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ContentFolder contentFolder = (ContentFolder)objectArray[n];
            if (URLFileSystem.equals((URL)uRL, (URL)contentFolder.getContentFolderURL())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void populateContentList(ContentSet contentSet) {
        URL uRL = contentSet.getContentFolderURL();
        URLPath uRLPath = contentSet.getURLPath();
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL2 = uRLArray[n];
            PatternFilter[] patternFilterArray = contentSet.getPatternFilters().getFilters();
            ContentFolder contentFolder = new ContentFolder(uRL, uRL2, patternFilterArray);
            this.CONTENT_LIST_MODEL.addElement(contentFolder);
            ++n;
        }
    }

    private void persistContentSet(ContentFolder contentFolder, ContentSet contentSet) {
        URL uRL = contentFolder.getRootURL();
        URLPath uRLPath = contentSet.getURLPath();
        if (uRLPath.size() != 1 || !URLFileSystem.equals((URL)uRLPath.getEntries()[0], (URL)uRL)) {
            URL[] uRLArray = new URL[]{uRL};
            uRLPath.setEntries(uRLArray);
        }
        if (!contentFolder.getContentFolderURL().equals(uRL)) {
            contentSet.setContentFolderURL(contentFolder.getContentFolderURL());
        } else {
            contentSet.setContentFolderURL(null);
        }
        PatternFilter[] patternFilterArray = contentFolder.getAllFilters();
        contentSet.getPatternFilters().setFilters(patternFilterArray);
    }

    private int getIndexOfURL(URL uRL) {
        Object[] objectArray = this.CONTENT_LIST_MODEL.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ContentFolder contentFolder = (ContentFolder)objectArray[n];
            if (URLFileSystem.equals((URL)uRL, (URL)contentFolder.getContentFolderURL())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private URLChooser getContentChooser() {
        if (this._contentChooser == null) {
            this._contentChooser = DialogUtil.newURLChooser();
            this._contentChooser.setShowJarsAsDirs(false);
            this._contentChooser.setSelectionScope(1);
            this._contentChooser.setSelectionMode(2);
        }
        return this._contentChooser;
    }

    private void enableControls() {
        if (!this._updating) {
            int n = this._contentList.getSelectedIndex();
            boolean bl = n != -1;
            this.REMOVE_CONTENT_BUTTON.setEnabled(bl);
            this.FILTER_TABS.setEnabled(bl);
            int n2 = this._contentList.getSelectedIndices().length;
            this.MOVE_UP_BUTTON.setEnabled(n2 == 1 && n > 0);
            this.MOVE_DOWN_BUTTON.setEnabled(n2 == 1 && n < this.CONTENT_LIST_MODEL.size() - 1);
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.ADD_CONTENT_BUTTON, (String)ModelArb.getString(91));
        ResourceUtils.resButton((AbstractButton)this.REMOVE_CONTENT_BUTTON, (String)ModelArb.getString(92));
        ResourceUtils.resButton((AbstractButton)this.MOVE_UP_BUTTON, (String)ModelArb.getString(94));
        ResourceUtils.resButton((AbstractButton)this.MOVE_DOWN_BUTTON, (String)ModelArb.getString(95));
        ResourceUtils.resLabel((JLabel)this.CONTENT_SET_LABEL, (Component)this._contentList, (String)ModelArb.getString(88));
        this.ADD_CONTENT_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.REMOVE_CONTENT_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.MOVE_UP_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.MOVE_DOWN_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this._contentList.addListSelectionListener(this.INTERACTION_LISTENER);
        this._contentList.setCellRenderer(this.CELL_RENDERER);
        this._contentList.getSelectionModel().setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this._contentList);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 2, 0);
        Insets insets2 = new Insets(5, 0, 0, 0);
        Insets insets3 = new Insets(0, 0, 0, 0);
        Insets insets4 = new Insets(0, 8, 5, 0);
        int n = -1;
        this.add((Component)this.CONTENT_SET_LABEL, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, -1, 1, 4, 1.0, 1.0, 10, 1, insets3, 0, 0));
        this.add((Component)this.ADD_CONTENT_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 10, 2, insets4, 0, 0));
        this.add((Component)this.REMOVE_CONTENT_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, insets4, 0, 0));
        this.add((Component)this.MOVE_UP_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, insets4, 0, 0));
        insets4.bottom = 0;
        this.add((Component)this.MOVE_DOWN_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, insets4, 0, 0));
        this.add((Component)this.FILTER_TABS, new GridBagConstraints(0, -1, 2, 1, 1.0, 5.0, 17, 1, insets2, 0, 0));
    }

    static JList ra$_contentList(ContentSetPanel contentSetPanel) {
        return contentSetPanel._contentList;
    }

    static void wa$_activeContentFlders(ContentSetPanel contentSetPanel, ContentFolder[] contentFolderArray) {
        contentSetPanel._activeContentFlders = contentFolderArray;
    }

    static ContentFolder[] ra$_activeContentFlders(ContentSetPanel contentSetPanel) {
        return contentSetPanel._activeContentFlders;
    }

    static ContentSetFilterPanel ra$FILTER_TABS(ContentSetPanel contentSetPanel) {
        return contentSetPanel.FILTER_TABS;
    }

    static void mav$enableControls(ContentSetPanel contentSetPanel) {
        contentSetPanel.enableControls();
    }

    static void wa$_updating(ContentSetPanel contentSetPanel, boolean bl) {
        contentSetPanel._updating = bl;
    }

    static JButton ra$ADD_CONTENT_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.ADD_CONTENT_BUTTON;
    }

    static URLChooser mav$getContentChooser(ContentSetPanel contentSetPanel) {
        return contentSetPanel.getContentChooser();
    }

    static URL ra$_projectURL(ContentSetPanel contentSetPanel) {
        return contentSetPanel._projectURL;
    }

    static ContentSetValidator ra$_validator(ContentSetPanel contentSetPanel) {
        return contentSetPanel._validator;
    }

    static DefaultListModel ra$CONTENT_LIST_MODEL(ContentSetPanel contentSetPanel) {
        return contentSetPanel.CONTENT_LIST_MODEL;
    }

    static int mav$getIndexOfURL(ContentSetPanel contentSetPanel, URL uRL) {
        return contentSetPanel.getIndexOfURL(uRL);
    }

    static JButton ra$REMOVE_CONTENT_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.REMOVE_CONTENT_BUTTON;
    }

    static JButton ra$MOVE_UP_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.MOVE_UP_BUTTON;
    }

    static JButton ra$MOVE_DOWN_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.MOVE_DOWN_BUTTON;
    }

    static Icon ra$FOLDER_ICON() {
        return FOLDER_ICON;
    }

    private class InteractionListener
    implements ListSelectionListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            int n;
            ContentSetPanel.wa$_updating(ContentSetPanel.this, true);
            Object object = actionEvent.getSource();
            if (object == ContentSetPanel.ra$ADD_CONTENT_BUTTON(ContentSetPanel.this)) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetPanel.this);
                waitCursor.show();
                URLChooser uRLChooser = ContentSetPanel.mav$getContentChooser(ContentSetPanel.this);
                uRLChooser.setRoots(URLFileSystem.listRoots());
                uRLChooser.setSelectedURL(ContentSetPanel.ra$_projectURL(ContentSetPanel.this));
                if (ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length > 0) {
                    uRLChooser.setSelectedURL(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this)[0].getContentFolderURL());
                }
                waitCursor.hide();
                if (uRLChooser.showOpenDialog((Component)ContentSetPanel.this.getParent()) == 0) {
                    URL[] uRLArray = uRLChooser.getSelectedURLs();
                    if (ContentSetPanel.ra$_validator(ContentSetPanel.this) != null) {
                        ContentSetPanel.ra$_validator(ContentSetPanel.this).validateAndProcessURLs(ContentSetPanel.this, uRLArray);
                        ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size() - 1);
                    } else {
                        int n2 = 0;
                        while (n2 < uRLArray.length) {
                            URL uRL = uRLArray[n2];
                            ContentSetPanel.this.addFolderToContentSet(uRL, uRL);
                            int n3 = ContentSetPanel.mav$getIndexOfURL(ContentSetPanel.this, uRLArray[n2]);
                            ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(n3);
                            ++n2;
                        }
                    }
                }
                uRLChooser.flush();
            } else if (object == ContentSetPanel.ra$REMOVE_CONTENT_BUTTON(ContentSetPanel.this)) {
                if (ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length == ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size()) {
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).clear();
                    ContentSetPanel.ra$ADD_CONTENT_BUTTON(ContentSetPanel.this).requestFocus();
                } else {
                    int n4 = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndex();
                    int n5 = ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length - 1;
                    while (n5 >= 0) {
                        ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).removeElement(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this)[n5]);
                        --n5;
                    }
                    int n6 = ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size();
                    if (n6 > 0 && n4 <= n6) {
                        if (n4 == n6) {
                            --n4;
                        }
                        ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(n4);
                    }
                }
            } else if (object == ContentSetPanel.ra$MOVE_UP_BUTTON(ContentSetPanel.this)) {
                int[] nArray2 = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndices();
                int n7 = nArray2.length;
                if (n7 == 1) {
                    int n8 = nArray2[0];
                    ContentFolder contentFolder = (ContentFolder)ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).getElementAt(n8);
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).remove(n8);
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).add(--n8, contentFolder);
                    ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(n8);
                }
            } else if (object == ContentSetPanel.ra$MOVE_DOWN_BUTTON(ContentSetPanel.this) && (n = (nArray = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndices()).length) == 1) {
                int n9 = nArray[0];
                ContentFolder contentFolder = (ContentFolder)ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).getElementAt(n9);
                ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).remove(n9);
                ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).add(++n9, contentFolder);
                ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(n9);
            }
            ContentSetPanel.wa$_updating(ContentSetPanel.this, false);
            ContentSetPanel.mav$enableControls(ContentSetPanel.this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == ContentSetPanel.ra$_contentList(ContentSetPanel.this) && !listSelectionEvent.getValueIsAdjusting()) {
                Object[] objectArray = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedValues();
                ContentSetPanel.wa$_activeContentFlders(ContentSetPanel.this, new ContentFolder[objectArray.length]);
                int n = 0;
                while (n < objectArray.length) {
                    ContentSetPanel.ra$_activeContentFlders((ContentSetPanel)ContentSetPanel.this)[n] = (ContentFolder)objectArray[n];
                    ++n;
                }
                ContentSetPanel.ra$FILTER_TABS(ContentSetPanel.this).setData(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this));
            }
            ContentSetPanel.mav$enableControls(ContentSetPanel.this);
        }

        private InteractionListener() {
        }

        InteractionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static class EmptyContentSetException
    extends Exception {
        EmptyContentSetException() {
            super("The ContentSet is empty.");
        }
    }

    private static class LCR
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ContentFolder) {
                jLabel.setIcon(ContentSetPanel.ra$FOLDER_ICON());
                jLabel.setText(URLFileSystem.getPlatformPathName((URL)((ContentFolder)object).getContentFolderURL()));
            } else if (!(object instanceof String)) {
                System.err.println("**** Warning: unrecognized list item type: " + (object != null ? object.getClass() : null));
            }
            return jLabel;
        }

        private LCR() {
        }

        LCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

