/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import oracle.ide.model.ContentSet;
import oracle.ide.model.NodeIdentityUtils;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CopyOnWriteList;

public class J2eeSettings
extends HashStructureAdapter {
    public static final String DATA_KEY = J2eeSettings.class.getName();
    public static final String WEB_CONTENT_SET_LOCAL_KEY = "webContentSet";
    public static final String WEB_CONTENT_SET_KEY = DATA_KEY + "/" + "webContentSet";
    static final String DEFAULT_HTML_ROOT = "public_html";
    private URL _prjURL;
    public static final String HTML_SOURCE_ROOT = "webContentSet/url-path";
    static final String J2EE_WEB_APP_NAME = "j2eeWebAppName";
    static final String J2EE_WEB_CONTEXT_ROOT = "j2eeWebContextRoot";
    private static CopyOnWriteList jspTypes = new CopyOnWriteList(Class.class);
    private static CopyOnWriteList jspCompilableTypes = new CopyOnWriteList(Class.class);

    private J2eeSettings(Project project, HashStructure hashStructure) {
        super(hashStructure);
        this._prjURL = project.getURL();
    }

    public static J2eeSettings getInstance(Project project) {
        return J2eeSettings.getInstance(project, (PropertyStorage)project);
    }

    public static J2eeSettings getInstance(Project project, PropertyStorage propertyStorage) {
        HashStructure hashStructure = propertyStorage.getProperties();
        return new J2eeSettings(project, hashStructure.getOrCreateHashStructure(DATA_KEY));
    }

    public URL getHtmlRootDirectory() {
        URL uRL = URLPath.getURLPath((HashStructure)this._hash, (String)HTML_SOURCE_ROOT).getFirstEntry();
        if (uRL == null && this._prjURL != null) {
            uRL = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)this._prjURL), (String)DEFAULT_HTML_ROOT);
        }
        return uRL;
    }

    public void setHtmlRootDirectory(URL uRL) {
        if (uRL != null) {
            URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)"");
            URLPath.setURLPath((HashStructure)this._hash, (String)HTML_SOURCE_ROOT, (URLPath)new URLPath(uRL2));
        } else {
            this._hash.remove(HTML_SOURCE_ROOT);
        }
    }

    public ContentSet getHtmlContentSet() {
        this.getHtmlRootDirectory();
        return new ContentSet(this._hash.getOrCreateHashStructure(WEB_CONTENT_SET_LOCAL_KEY));
    }

    public String getJ2eeWebAppName() {
        String string = this._hash.getString(J2EE_WEB_APP_NAME);
        if (string == null && this._prjURL != null) {
            string = URLFileSystem.getName((URL)this._prjURL);
        }
        return string;
    }

    public void setJ2eeWebAppName(String string) {
        this._hash.putString(J2EE_WEB_APP_NAME, string);
    }

    public String getJ2eeWebContextRoot() {
        return this.getJ2eeWebContextRoot(false);
    }

    public String getJ2eeWebContextRoot(boolean bl) {
        String string = this._hash.getString(J2EE_WEB_CONTEXT_ROOT);
        if (string == null && this._prjURL != null) {
            string = URLFileSystem.getName((URL)this._prjURL);
        }
        if (bl && !string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    public void setJ2eeWebContextRoot(String string) {
        this._hash.putString(J2EE_WEB_CONTEXT_ROOT, string);
    }

    public static boolean isJsp(String string) {
        return NodeIdentityUtils.isNodeClass((String)string, (Class[])((Class[])jspTypes.getItems()), (boolean)false);
    }

    public static void addJspType(Class clazz) {
        jspTypes.add((Object)clazz);
    }

    public static boolean isCompilableJsp(String string) {
        return NodeIdentityUtils.isNodeClass((String)string, (Class[])((Class[])jspCompilableTypes.getItems()), (boolean)true);
    }

    public static void addCompilableJspType(Class clazz) {
        jspCompilableTypes.add((Object)clazz);
    }
}

