/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.LibraryModel;
import oracle.jdeveloper.resource.ControlsArb;

public class JDKModel
extends LibraryModel {
    private URL exeURL;
    private URL sdkURL;
    private String[] vms;
    private VersionNumber version;

    public JDKModel(JDK jDK, MutableLibraryList mutableLibraryList, Component component) {
        super(jDK, mutableLibraryList, component);
    }

    public void setExecutable(URL uRL) {
        this.exeURL = uRL;
    }

    public void setVMs(String[] stringArray) {
        this.vms = stringArray;
    }

    public void setSDKDir(URL uRL) {
        this.sdkURL = uRL;
    }

    public void setJavaVersion(VersionNumber versionNumber) {
        this.version = versionNumber;
    }

    public Library commit() throws Exception {
        VersionNumber versionNumber;
        URL uRL;
        Object[] objectArray;
        super.commit();
        JDK jDK = (JDK)this.lib;
        if (this.exeURL == null || !URLFileSystem.isRegularFile((URL)this.exeURL)) {
            this.showError(ControlsArb.format(60, URLFileSystem.getPlatformPathName((URL)this.exeURL)), ControlsArb.getString(72));
            throw new Exception();
        }
        URL uRL2 = jDK.getJavaExecutable();
        if (ModelUtil.areDifferent((Object)uRL2, (Object)this.exeURL)) {
            jDK.setJavaExecutable(this.exeURL);
        }
        if (!Arrays.equals(this.vms, objectArray = jDK.getInstalledVMs())) {
            jDK.setInstalledVMs(this.vms);
        }
        if (ModelUtil.areDifferent((Object)this.sdkURL, (Object)(uRL = jDK.getSDKBinDir()))) {
            jDK.setSDKBinDir(this.sdkURL);
        }
        if (ModelUtil.areDifferent((Object)(versionNumber = jDK.getJavaVersion()), (Object)this.version)) {
            jDK.setJavaVersion(this.version);
        }
        return this.lib;
    }
}

