/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.model.ProjectDependencyFactory;
import oracle.jdeveloper.resource.JProjectArb;

public class JProjectDependencyPanel
extends ProjectSettingsTraversablePanel {
    private JMutableTreeNode _rootNode;
    private final DefaultTreeModel _treeModel;
    private final CustomJTree _depsTree;
    private final JButton _btnOrdering;
    private Project _curProject;
    private List _deps;
    private transient Workspace _curWorkspace;
    private static final String[] PROPERTY_KEYS = new String[]{"dependencyList"};

    void $init$() {
        this._rootNode = new JMutableTreeNode();
        this._treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
        this._depsTree = new CustomJTree((TreeModel)this._treeModel);
        this._btnOrdering = new JButton();
        this._curProject = null;
    }

    public JProjectDependencyPanel() {
        this.$init$();
        JLabel jLabel = new JLabel(JProjectArb.getString(169));
        jLabel.setDisplayedMnemonic(JProjectArb.getMnemonic(170));
        jLabel.setLabelFor((Component)this._depsTree);
        ResourceUtils.resButton((AbstractButton)this._btnOrdering, (String)JProjectArb.getString(171));
        this._depsTree.setRootVisible(false);
        this._depsTree.setShowsRootHandles(true);
        this._depsTree.setScrollsOnExpand(true);
        this._depsTree.setPropagateCheckState(false);
        L l = new L(null);
        this._btnOrdering.addActionListener(l);
        this._depsTree.addTreeExpansionListener((TreeExpansionListener)l);
        this._depsTree.addTreeCellCheckedListener((TreeCellCheckedListener)l);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this._depsTree, null);
        this.setLayout(new GridBagLayout());
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._btnOrdering, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setHelpID("f1_idedprojsetdependencies_html");
    }

    public String getDataKey() {
        return DependencyConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        boolean bl = JProjectDependencyPanel.isDefaultProject((Namespace)traversableContext);
        if (bl) {
            this._deps = null;
            this._rootNode = new JMutableTreeNode();
            this._treeModel.setRoot((TreeNode)this._rootNode);
            this._curWorkspace = null;
        } else {
            this._depsTree.setVisible(true);
            PropertyStorage propertyStorage = JProjectDependencyPanel.getPropertyData((Namespace)traversableContext);
            DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
            this._deps = dependencyConfiguration.getDependencyList();
            this._curWorkspace = Ide.getActiveWorkspace();
            this._curProject = (Project)traversableContext.find("Project");
            this.initTree(this._curWorkspace);
        }
        this.updateOrderingButton();
    }

    public void onExit(TraversableContext traversableContext) {
        PropertyStorage propertyStorage = JProjectDependencyPanel.getPropertyData((Namespace)traversableContext);
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
        dependencyConfiguration.setDependencyList(this._deps);
    }

    private void updateOrderingButton() {
        this._btnOrdering.setEnabled(this._deps != null && this._deps.size() > 1);
    }

    private static URL tryGetURL(Object object) {
        return object instanceof Locatable ? ((Locatable)object).getURL() : null;
    }

    private boolean matches(Dependable dependable, URL uRL, URL uRL2) {
        Element element = dependable.getSource();
        Folder folder = dependable.getSourceOwner();
        if (folder == null && element instanceof Project) {
            folder = this._curWorkspace;
        }
        return URLFileSystem.equals((URL)JProjectDependencyPanel.tryGetURL(element), (URL)uRL) && URLFileSystem.equals((URL)JProjectDependencyPanel.tryGetURL(folder), (URL)uRL2);
    }

    private static Element getDepSource(JMutableTreeNode jMutableTreeNode) {
        return (Element)jMutableTreeNode.getUserObject();
    }

    private void initTree(Workspace workspace) {
        Enumeration enumeration = this._depsTree.getExpandedDescendants(new TreePath(this._rootNode));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = (TreePath)enumeration.nextElement();
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
                arrayList.add(jMutableTreeNode.getUserObject());
            }
        }
        this._rootNode = this.createTreeNode((Element)workspace, false);
        this.addChildren(this._rootNode, true);
        this._treeModel.setRoot((TreeNode)this._rootNode);
        this.restoreOrInitExpandedTreeNodes(this._rootNode, enumeration != null, arrayList);
    }

    private void restoreOrInitExpandedTreeNodes(JMutableTreeNode jMutableTreeNode, boolean bl, ArrayList arrayList) {
        Enumeration enumeration = jMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
            Element element = (Element)jMutableTreeNode2.getUserObject();
            if (bl && arrayList.contains(element) || !bl && this.depsListContains(element)) {
                this._depsTree.expandPath(new TreePath(jMutableTreeNode2.getPath()));
            }
            if (jMutableTreeNode2.isLeaf()) continue;
            this.restoreOrInitExpandedTreeNodes(jMutableTreeNode2, bl, arrayList);
        }
    }

    private boolean depsListContains(Element element) {
        if (this._deps != null) {
            for (Dependable dependable : this._deps) {
                if (dependable == null || dependable.getSource() != element && dependable.getSourceOwner() != element) continue;
                return true;
            }
        }
        return false;
    }

    private JMutableTreeNode createTreeNode(Element element, boolean bl) {
        TriStateBoolean triStateBoolean = TriStateBoolean.getState((bl && this.isSelected(element) ? 1 : 0) != 0);
        JTreeCellData jTreeCellData = new JTreeCellData(element.getIcon(), element.getShortLabel(), bl, triStateBoolean);
        2 var5_5 = new 2(jTreeCellData, element.mayHaveChildren());
        var5_5.setUserObject(element);
        return var5_5;
    }

    private boolean isSelected(Element element) {
        URL uRL;
        if (this._deps != null && (uRL = JProjectDependencyPanel.tryGetURL(element)) != null) {
            for (Dependable dependable : this._deps) {
                if (dependable == null || !URLFileSystem.equals((URL)uRL, (URL)JProjectDependencyPanel.tryGetURL(dependable.getSource()))) continue;
                return true;
            }
        }
        return false;
    }

    private void addChildren(JMutableTreeNode jMutableTreeNode, boolean bl) {
        block9: {
            Iterator iterator;
            Element element;
            block10: {
                element = (Element)jMutableTreeNode.getUserObject();
                if (!element.mayHaveChildren()) break block9;
                URL uRL = this._curProject.getURL();
                if (!(element instanceof Workspace)) break block10;
                Iterator iterator2 = element.getChildren();
                ArrayList<Element> arrayList = new ArrayList<Element>();
                while (iterator2.hasNext()) {
                    arrayList.add((Element)iterator2.next());
                }
                Collections.sort(arrayList, new 1());
                for (Element element2 : arrayList) {
                    if (!JProjectDependencyPanel.isShownInTree(element2, bl) || JProjectDependencyPanel.isCurrentProject(element2, uRL)) continue;
                    jMutableTreeNode.add((MutableTreeNode)this.createTreeNode(element2, bl));
                }
                break block9;
            }
            if (element instanceof Project) {
                ResourcePaths resourcePaths = ResourcePaths.getInstance((PropertyStorage)((Project)element));
                iterator = resourcePaths.getResourcesContentSet().nodeIterator("");
            } else {
                iterator = element.getChildren();
            }
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                if (JProjectDependencyPanel.isShownInTree(element3, bl)) {
                    jMutableTreeNode.add((MutableTreeNode)this.createTreeNode(element3, bl));
                    continue;
                }
                if (!Deployment.isDeploymentContainerProfile((Element)element3)) continue;
                jMutableTreeNode.add((MutableTreeNode)this.createTreeNode(element3, false));
                Iterator iterator3 = element3.getChildren();
                while (iterator3.hasNext()) {
                    arrayList.add(iterator3.next());
                }
            }
            if (arrayList.isEmpty()) break block9;
            int n = jMutableTreeNode.getChildCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getChildAt(n2);
                Object object = jMutableTreeNode2.getUserObject();
                if (arrayList.contains(object)) {
                    jMutableTreeNode.remove((MutableTreeNode)jMutableTreeNode2);
                }
                --n2;
            }
        }
    }

    private static boolean isShownInTree(Element element, boolean bl) {
        return !bl || ProjectDependencyFactory.hasFactory(element);
    }

    private static boolean isCurrentProject(Element element, URL uRL) {
        return element instanceof Project && URLFileSystem.equals((URL)uRL, (URL)((Project)element).getURL());
    }

    static List ra$_deps(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._deps;
    }

    static Element maS$getDepSource(JMutableTreeNode jMutableTreeNode) {
        return JProjectDependencyPanel.getDepSource(jMutableTreeNode);
    }

    static URL maS$tryGetURL(Object object) {
        return JProjectDependencyPanel.tryGetURL(object);
    }

    static boolean mav$matches(JProjectDependencyPanel jProjectDependencyPanel, Dependable dependable, URL uRL, URL uRL2) {
        return jProjectDependencyPanel.matches(dependable, uRL, uRL2);
    }

    static void mav$updateOrderingButton(JProjectDependencyPanel jProjectDependencyPanel) {
        jProjectDependencyPanel.updateOrderingButton();
    }

    static void wa$_deps(JProjectDependencyPanel jProjectDependencyPanel, List list) {
        jProjectDependencyPanel._deps = list;
    }

    static JButton ra$_btnOrdering(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._btnOrdering;
    }

    static void mav$addChildren(JProjectDependencyPanel jProjectDependencyPanel, JMutableTreeNode jMutableTreeNode, boolean bl) {
        jProjectDependencyPanel.addChildren(jMutableTreeNode, bl);
    }

    static DefaultTreeModel ra$_treeModel(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._treeModel;
    }

    private class L
    implements TreeCellCheckedListener,
    TreeExpansionListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JProjectDependencyPanel.ra$_btnOrdering(JProjectDependencyPanel.this)) {
                Object[] objectArray;
                Ordering ordering = new Ordering();
                Namespace namespace = new Namespace();
                namespace.put("deps-array", JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) != null ? JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).toArray() : null);
                TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)((Object)JProjectDependencyPanel.this), JProjectArb.getString(172), (Traversable)ordering, namespace);
                tDialogLauncher.setPackDialog(true);
                boolean bl = tDialogLauncher.showDialog();
                if (bl && (objectArray = (Object[])namespace.find("deps-array")) != null) {
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).clear();
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).addAll(Arrays.asList(objectArray));
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
            if (!jMutableTreeNode.isLeaf()) {
                Ide.getWaitCursor().show();
                SwingUtilities.invokeLater(new 1(this, jMutableTreeNode));
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeCellCheckedEvent.getSource();
            Element element = JProjectDependencyPanel.maS$getDepSource(jMutableTreeNode);
            Folder folder = this.getDepSourceOwner(jMutableTreeNode);
            try {
                Dependable dependable = ProjectDependencyFactory.findOrCreate(element, folder);
                if (dependable != null) {
                    if (JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) == null) {
                        JProjectDependencyPanel.wa$_deps(JProjectDependencyPanel.this, new ArrayList());
                    }
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).add(dependable);
                    JProjectDependencyPanel.mav$updateOrderingButton(JProjectDependencyPanel.this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            if (JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) != null) {
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeCellCheckedEvent.getSource();
                URL uRL = JProjectDependencyPanel.maS$tryGetURL(JProjectDependencyPanel.maS$getDepSource(jMutableTreeNode));
                URL uRL2 = JProjectDependencyPanel.maS$tryGetURL(this.getDepSourceOwner(jMutableTreeNode));
                int n = 0;
                while (n < JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).size()) {
                    Dependable dependable = (Dependable)JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).get(n);
                    if (JProjectDependencyPanel.mav$matches(JProjectDependencyPanel.this, dependable, uRL, uRL2)) {
                        JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).remove(n);
                    }
                    ++n;
                }
                JProjectDependencyPanel.mav$updateOrderingButton(JProjectDependencyPanel.this);
            }
        }

        private Folder getDepSourceOwner(JMutableTreeNode jMutableTreeNode) {
            Object object;
            JMutableTreeNode jMutableTreeNode2 = jMutableTreeNode;
            do {
                if ((jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode2.getParent()) != null) continue;
                return null;
            } while (!((object = jMutableTreeNode2.getUserObject()) instanceof Project) && !(object instanceof Workspace));
            return (Folder)object;
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ JMutableTreeNode v$node;
            final /* synthetic */ L this$0;

            public void run() {
                if (this.v$node.getChildCount() == 0) {
                    JProjectDependencyPanel.mav$addChildren(this.this$0.JProjectDependencyPanel.this, this.v$node, true);
                    JProjectDependencyPanel.ra$_treeModel(this.this$0.JProjectDependencyPanel.this).reload((TreeNode)this.v$node);
                }
                Ide.getWaitCursor().hide();
            }

            public 1(L l, JMutableTreeNode jMutableTreeNode) {
                this.v$node = jMutableTreeNode;
                this.this$0 = l;
            }
        }
    }

    private static class Ordering
    extends DefaultTraversablePanel
    implements ListSelectionListener,
    ActionListener {
        private static final String DEPS_ARRAY = "deps-array";
        private final JList _list;
        private final JButton _btnUp;
        private final JButton _btnDown;
        private Object[] _depsArray;

        void $init$() {
            this._list = new JList();
            this._btnUp = new JButton();
            this._btnDown = new JButton();
        }

        Ordering() {
            this.$init$();
            this._btnUp.setIcon(ComponentArb.getIcon((int)0));
            this._btnUp.setDisabledIcon(ComponentArb.getIcon((int)2));
            this._btnDown.setIcon(ComponentArb.getIcon((int)1));
            this._btnDown.setDisabledIcon(ComponentArb.getIcon((int)3));
            this._list.addListSelectionListener(this);
            this._btnUp.addActionListener(this);
            this._btnDown.addActionListener(this);
            Insets insets = new Insets(2, 2, 2, 2);
            this._btnUp.setMargin(insets);
            this._btnDown.setMargin(insets);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add((Component)this._list, null);
            this.setLayout(new GridBagLayout());
            this.add(jScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._btnUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 8, 5, 0), 0, 0));
            this.add(this._btnDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 8, 0, 0), 0, 0));
            this.setHelpID("f1_idedprojectdependenciesordering_html");
        }

        public void onEntry(TraversableContext traversableContext) {
            this._depsArray = (Object[])traversableContext.find(DEPS_ARRAY);
            this._list.setListData(this._depsArray != null ? this._depsArray : new Object[]{});
            this.enableButtons();
        }

        public void onExit(TraversableContext traversableContext) {
            traversableContext.findAndReplace(DEPS_ARRAY, (Object)this._depsArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.enableButtons();
        }

        private void enableButtons() {
            int n = this._list.getSelectedIndex();
            this._btnUp.setEnabled(n > 0);
            this._btnDown.setEnabled(n >= 0 && n < this._depsArray.length - 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = this._list.getSelectedIndex();
            if (object == this._btnUp) {
                this.swapAndSet(n, n - 1);
            } else if (object == this._btnDown) {
                this.swapAndSet(n, n + 1);
            }
        }

        private void swapAndSet(int n, int n2) {
            Object object = this._depsArray[n];
            this._depsArray[n] = this._depsArray[n2];
            this._depsArray[n2] = object;
            this._list.setListData(this._depsArray);
            this._list.setSelectedIndex(n2);
        }
    }

    public final class 2
    extends JMutableTreeNode {
        public boolean isLeaf() {
            return this.allowsChildren ^ true;
        }

        public 2(JTreeCellData jTreeCellData, boolean bl) {
            super(jTreeCellData, bl);
        }
    }

    public final class 1
    implements Comparator {
        public int compare(Element element, Element element2) {
            return element.getShortLabel().compareTo(element2.getShortLabel());
        }
    }
}

