/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.LibraryReference;

public class JProjectLibraries
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdevimpl.config.JProjectLibraries";
    public static final String JDK_NAME = "jdkReference";
    public static final String LIBRARIES = "libraryReferences";
    public static final String LIB_LIST = "internalDefinitions";
    public static final String EXPORTS = "exportedReferences";

    public JProjectLibraries(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static JProjectLibraries getInstance(PropertyStorage propertyStorage) {
        boolean bl = propertyStorage != null && propertyStorage == Ide.getDefaultProject() ? ((Project)propertyStorage).isDirty() ^ true : false;
        HashStructure hashStructure = JProjectLibraries.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY);
        JProjectLibraries jProjectLibraries = new JProjectLibraries(hashStructure);
        if (bl && ((Project)propertyStorage).isDirty()) {
            try {
                ((Project)propertyStorage).save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return jProjectLibraries;
    }

    public JDK getJDK() {
        LibraryReference libraryReference;
        JDK jDK = null;
        HashStructure hashStructure = this._hash.getHashStructure(JDK_NAME);
        LibraryReference libraryReference2 = libraryReference = hashStructure != null ? new LibraryReference(hashStructure) : null;
        if (libraryReference != null && libraryReference.isJDK()) {
            JProjectLibraryList jProjectLibraryList = this.getProjectLibraryList();
            JDK jDK2 = jDK = jProjectLibraryList != null ? jProjectLibraryList.findJDK(libraryReference.getID()) : null;
            if (jDK == null) {
                jDK = (JDK)libraryReference.getLibrary();
            }
        }
        return jDK != null ? jDK : JLibraryManager.getDefaultJDK();
    }

    public void setJDK(JDK jDK) {
        if (jDK == null || jDK == JLibraryManager.getDefaultJDK()) {
            this._hash.remove(JDK_NAME);
        } else {
            this._hash.applyBatchChanges((Runnable)new 1(this, jDK));
        }
    }

    public VersionNumber getJdkVersionNumber() {
        JDK jDK = this.getJDK();
        return jDK != null ? jDK.getJavaVersion() : null;
    }

    public String[] getLibraryList() {
        JLibrary[] jLibraryArray = this.getLibraries();
        String[] stringArray = new String[jLibraryArray != null ? jLibraryArray.length : 0];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = jLibraryArray[n].getID().toString();
            ++n;
        }
        return stringArray;
    }

    public JLibrary[] getLibraries() {
        ListStructure listStructure = this._hash.getListStructure(LIBRARIES);
        List list = this.getLibraries(listStructure);
        return list.toArray(new JLibrary[list.size()]);
    }

    public void setLibraries(JLibrary[] jLibraryArray) {
        if (jLibraryArray == null) {
            this._hash.remove(LIBRARIES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(LIBRARIES);
            this.setLibraries(listStructure, jLibraryArray);
        }
    }

    public JLibrary[] getExports() {
        ListStructure listStructure = this._hash.getListStructure(EXPORTS);
        List list = this.getLibraries(listStructure);
        return list.toArray(new JLibrary[list.size()]);
    }

    public void setExports(JLibrary[] jLibraryArray) {
        if (jLibraryArray == null) {
            this._hash.remove(EXPORTS);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(EXPORTS);
            this.setLibraries(listStructure, jLibraryArray);
        }
    }

    public JProjectLibraryList getProjectLibraryList() {
        return JProjectLibraryList.getInstance(this._hash.getOrCreateHashStructure(LIB_LIST));
    }

    public void setProjectLibraryList(JProjectLibraryList jProjectLibraryList) {
        if (jProjectLibraryList == null) {
            this._hash.remove(LIB_LIST);
        } else {
            JProjectLibraryList jProjectLibraryList2 = this.getProjectLibraryList();
            jProjectLibraryList.copyTo(jProjectLibraryList2);
        }
    }

    public boolean addLibrary(Object object) {
        return this.addLibrary(object, true);
    }

    public boolean addLibrary(Object object, boolean bl) {
        ListStructure listStructure;
        List list;
        JLibrary jLibrary = this.resolveLibrary(object);
        if (jLibrary != null && !(list = this.getLibraries(listStructure = this._hash.getOrCreateListStructure(LIBRARIES))).contains(jLibrary)) {
            list.add(jLibrary);
            this.setLibraries(listStructure, list.toArray(new JLibrary[list.size()]));
            if (bl && !(list = this.getLibraries(listStructure = this._hash.getOrCreateListStructure(EXPORTS))).contains(jLibrary)) {
                list.add(jLibrary);
                this.setLibraries(listStructure, list.toArray(new JLibrary[list.size()]));
            }
            return true;
        }
        return false;
    }

    public boolean removeLibrary(Object object) {
        JLibrary jLibrary = this.resolveLibrary(object);
        if (jLibrary != null) {
            List list;
            ListStructure listStructure = this._hash.getListStructure(LIBRARIES);
            List list2 = list = listStructure != null ? this.getLibraries(listStructure) : null;
            if (list != null && list.contains(jLibrary)) {
                list.remove(jLibrary);
                this.setLibraries(listStructure, list.toArray(new JLibrary[list.size()]));
                return true;
            }
        }
        return false;
    }

    public JLibrary resolveLibrary(Object object) {
        JLibrary jLibrary;
        JProjectLibraryList jProjectLibraryList = this.getProjectLibraryList();
        JLibrary jLibrary2 = jLibrary = jProjectLibraryList != null ? jProjectLibraryList.findLibrary(object) : null;
        if (jLibrary == null) {
            jLibrary = JLibraryManager.findLibrary(object);
        }
        return jLibrary;
    }

    public JDK resolveJDK(Object object) {
        JDK jDK;
        JProjectLibraryList jProjectLibraryList = this.getProjectLibraryList();
        JDK jDK2 = jDK = jProjectLibraryList != null ? jProjectLibraryList.findJDK(object) : null;
        if (jDK == null) {
            jDK = JLibraryManager.findJDK(object);
        }
        return jDK;
    }

    private List getLibraries(ListStructure listStructure) {
        Iterator iterator = listStructure != null ? listStructure.iterator() : null;
        ArrayList<JLibrary> arrayList = new ArrayList<JLibrary>();
        if (iterator != null) {
            JProjectLibraryList jProjectLibraryList = this.getProjectLibraryList();
            while (iterator.hasNext()) {
                JLibrary jLibrary;
                HashStructure hashStructure = (HashStructure)iterator.next();
                LibraryReference libraryReference = new LibraryReference(hashStructure);
                Object object = libraryReference.getID();
                JLibrary jLibrary2 = jLibrary = jProjectLibraryList != null ? jProjectLibraryList.findLibrary(object) : null;
                if (jLibrary == null && (jLibrary = (JLibrary)libraryReference.getLibrary()) == null) {
                    jLibrary = new UnresolvedLibrary(HashStructure.newInstance());
                    ((JLibraryAdapter)jLibrary).setID(object);
                    if (object instanceof URL) {
                        ((JLibraryAdapter)jLibrary).setName(URLFileSystem.getPlatformPathName((URL)((URL)object)));
                    } else if (object != null) {
                        jLibrary.setName(object.toString());
                    }
                }
                arrayList.add(jLibrary);
            }
        }
        return arrayList;
    }

    private void setLibraries(ListStructure listStructure, JLibrary[] jLibraryArray) {
        ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
        int n = 0;
        while (n < jLibraryArray.length) {
            HashStructure hashStructure = HashStructure.newInstance();
            LibraryReference libraryReference = new LibraryReference(hashStructure);
            libraryReference.setLibrary(jLibraryArray[n]);
            arrayList.add(hashStructure);
            ++n;
        }
        listStructure.mirror(arrayList);
    }

    static HashStructure ra$_hash(JProjectLibraries jProjectLibraries) {
        return jProjectLibraries._hash;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ JDK v$jdk;
        final /* synthetic */ JProjectLibraries this$0;

        public void run() {
            HashStructure hashStructure = JProjectLibraries.ra$_hash(this.this$0).getOrCreateHashStructure(JProjectLibraries.JDK_NAME);
            LibraryReference libraryReference = new LibraryReference(hashStructure);
            libraryReference.setLibrary(this.v$jdk);
        }

        public 1(JProjectLibraries jProjectLibraries, JDK jDK) {
            this.v$jdk = jDK;
            this.this$0 = jProjectLibraries;
        }
    }

    public static class UnresolvedLibrary
    extends JLibraryAdapter {
        UnresolvedLibrary(HashStructure hashStructure) {
            super(hashStructure);
        }
    }
}

