/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryPanel;

public class JProjectLibrariesPanel
extends ProjectSettingsTraversablePanel {
    private static final LocalChangeListener LISTENER = new LocalChangeListener(null);
    private static final LocalChangeListener2 LISTENER2 = new LocalChangeListener2(null);
    private static final String[] COLUMN_NAMES = new String[]{ControlsArb.getString(12), ControlsArb.getString(11)};
    private static final String[] PROPERTYKEYS = new String[]{"jdkReference", "libraryReferences", "internalDefinitions", "exportedReferences"};
    private static URL DEF_DIR = URLFactory.newDirURL((String)Ide.getWorkDirectory());
    private GridBagLayout mainLayout;
    private JLabel jdkPrompt;
    private JTextField jdkField;
    private JLabel libsPrompt;
    private JScrollPane libsScrollPane;
    private LibraryTableModel tableModel;
    private JTable libTable;
    private JButton editJDKButton;
    private JButton addPathButton;
    private JButton addLibButton;
    private JButton editLibButton;
    private JButton removeLibButton;
    private JButton shareLibButton;
    private JButton upButton;
    private JButton downButton;
    private LibraryList[] libLists;
    private JProjectLibraryList prjLibList;
    private JProjectLibraries projectLibraries;
    private ButtonHandler buttonHandler;
    private ListHandler listHandler;

    void $init$() {
        this.mainLayout = new GridBagLayout();
        this.jdkPrompt = new JLabel();
        this.jdkField = new JTextField();
        this.libsPrompt = new JLabel();
        this.libsScrollPane = new JScrollPane();
        this.tableModel = new LibraryTableModel(COLUMN_NAMES, 0, null);
        this.libTable = new JTable(this.tableModel);
        this.editJDKButton = new JButton();
        this.addPathButton = new JButton();
        this.addLibButton = new JButton();
        this.editLibButton = new JButton();
        this.removeLibButton = new JButton();
        this.shareLibButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.buttonHandler = new ButtonHandler(null);
        this.listHandler = new ListHandler(null);
    }

    public JProjectLibrariesPanel() {
        this.$init$();
        try {
            TableColumnModel tableColumnModel = this.libTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            tableColumn.setCellEditor(new DefaultCellEditor(jCheckBox));
            tableColumn.setCellRenderer(new BooleanCellRenderer());
            tableColumn = tableColumnModel.getColumn(1);
            tableColumn.setCellRenderer(new LibraryCellRenderer(null));
            JTableHeader jTableHeader = this.libTable.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTableHeader.setResizingColumn(tableColumn);
            this.setHelpID("f1_idedprojsetlibrariesdpp_html");
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.jdkField.setEnabled(false);
        this.jdkField.setEditable(false);
        this.editJDKButton.addActionListener(this.buttonHandler);
        this.libTable.setColumnSelectionAllowed(false);
        this.libTable.setAutoResizeMode(3);
        this.libTable.getSelectionModel().addListSelectionListener(this.listHandler);
        this.libTable.addKeyListener(this.listHandler);
        this.addPathButton.addActionListener(this.buttonHandler);
        this.addLibButton.addActionListener(this.buttonHandler);
        this.editLibButton.addActionListener(this.buttonHandler);
        this.removeLibButton.addActionListener(this.buttonHandler);
        this.shareLibButton.addActionListener(this.buttonHandler);
        this.upButton.addActionListener(this.buttonHandler);
        this.downButton.addActionListener(this.buttonHandler);
        this.libsScrollPane.getViewport().add((Component)this.libTable, null);
        this.libsScrollPane.getViewport().setBackground(this.libTable.getBackground());
        this.add(this.jdkPrompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.jdkField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.libsPrompt, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.libsScrollPane, new GridBagConstraints(0, 3, 1, 9, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editJDKButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.addLibButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.addPathButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.removeLibButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.editLibButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.shareLibButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.upButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.downButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.jdkPrompt, (Component)this.editJDKButton, (String)JProjectArb.getString(151));
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString(10));
        ResourceUtils.resLabel((JLabel)this.libsPrompt, (Component)this.libTable, (String)ControlsArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.addPathButton, (String)ControlsArb.getString(81));
        ResourceUtils.resButton((AbstractButton)this.addLibButton, (String)ControlsArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this.editLibButton, (String)ControlsArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.removeLibButton, (String)ControlsArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.shareLibButton, (String)ControlsArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this.upButton, (String)ControlsArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this.downButton, (String)ControlsArb.getString(8));
    }

    public String getDataKey() {
        return "oracle.jdevimpl.config.JProjectLibraries";
    }

    public String[] getPropertyKeys() {
        return PROPERTYKEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(traversableContext);
        this.reload();
        this.listHandler.valueChanged(null);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(traversableContext);
        this.commit();
    }

    public void hideShareButton() {
        if (this.shareLibButton.getParent() != null) {
            this.remove(this.shareLibButton);
        }
    }

    private static JProjectLibraries getJProjectLibraries(TraversableContext traversableContext) {
        if (traversableContext.getWizardCallbacks() != null) {
            return (JProjectLibraries)((Object)traversableContext.find("oracle.jdevimpl.config.JProjectLibraries"));
        }
        PropertyStorage propertyStorage = JProjectLibrariesPanel.getPropertyData((Namespace)traversableContext);
        return JProjectLibraries.getInstance(propertyStorage);
    }

    protected Component getDefaultFocusComponent() {
        return this.addLibButton;
    }

    private void reload() {
        LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
        this.prjLibList = this.projectLibraries.getProjectLibraryList();
        this.libLists = new LibraryList[libraryListArray.length + 1];
        System.arraycopy(libraryListArray, 0, this.libLists, 0, libraryListArray.length);
        this.libLists[this.libLists.length - 1] = this.prjLibList;
        JDK jDK = this.projectLibraries.getJDK();
        if (jDK != null) {
            this.jdkField.setText(jDK.toString());
        }
        this.tableModel.setRowCount(0);
        JLibrary[] jLibraryArray = this.projectLibraries.getLibraries();
        JLibrary[] jLibraryArray2 = this.projectLibraries.getExports();
        if (jLibraryArray != null) {
            int n = 0;
            while (n < jLibraryArray.length) {
                block6: {
                    if (jLibraryArray2 != null) {
                        int n2 = 0;
                        while (n2 < jLibraryArray2.length) {
                            if (jLibraryArray2[n2].equals(jLibraryArray[n])) {
                                this.tableModel.addRow(new Object[]{Boolean.TRUE, jLibraryArray[n]});
                                break block6;
                            }
                            ++n2;
                        }
                    }
                    this.tableModel.addRow(new Object[]{Boolean.FALSE, jLibraryArray[n]});
                }
                ++n;
            }
        }
    }

    private void commit() throws TraversalException {
        ArrayList<JLibrary> arrayList = new ArrayList<JLibrary>();
        ArrayList<JLibrary> arrayList2 = new ArrayList<JLibrary>();
        int n = this.tableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = (Boolean)this.tableModel.getValueAt(n2, 0);
            JLibrary jLibrary = (JLibrary)this.tableModel.getValueAt(n2, 1);
            if (bl) {
                arrayList2.add(jLibrary);
            }
            arrayList.add(jLibrary);
            ++n2;
        }
        JLibrary[] jLibraryArray = new JLibrary[arrayList2.size()];
        arrayList2.toArray(jLibraryArray);
        this.projectLibraries.setExports(jLibraryArray);
        jLibraryArray = new JLibrary[arrayList.size()];
        arrayList.toArray(jLibraryArray);
        this.projectLibraries.setLibraries(jLibraryArray);
    }

    private void syncProjectLibraries(JProjectLibraryList jProjectLibraryList) {
        List list = jProjectLibraryList != null ? jProjectLibraryList.getLibraryList() : null;
        Iterator iterator = list != null ? list.iterator() : null;
        JProjectLibraryList jProjectLibraryList2 = this.projectLibraries.getProjectLibraryList();
        if (iterator != null && jProjectLibraryList2 != null) {
            while (iterator.hasNext()) {
                int n;
                JLibrary jLibrary = (JLibrary)iterator.next();
                if (jProjectLibraryList2.findLibrary(jLibrary.getID()) != null || (n = this.findRow(jLibrary)) < 0) continue;
                this.tableModel.removeRow(n);
            }
        }
        list = jProjectLibraryList2 != null ? jProjectLibraryList2.getLibraryList() : null;
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null && jProjectLibraryList != null) {
            while (iterator.hasNext()) {
                int n;
                JLibrary jLibrary = (JLibrary)iterator.next();
                if (jProjectLibraryList.findLibrary(jLibrary.getID()) != null || (n = this.findRow(jLibrary)) >= 0) continue;
                this.tableModel.addRow(new Object[]{Boolean.TRUE, jLibrary});
            }
        }
    }

    private int findRow(Library library) {
        Object object;
        Object object2 = object = library != null ? library.getID() : null;
        if (object != null) {
            int n = this.libTable.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                if (((Library)this.libTable.getValueAt(n2, 1)).equivalent(library)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    private String capitalize(String string) {
        if (string != null && !Character.isUpperCase(string.charAt(0))) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private void deleteSelection() {
        int n;
        int[] nArray = this.libTable.getSelectedRows();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2 + 1;
                while (n3 < nArray.length) {
                    if (nArray[n3] < nArray[n2]) {
                        int n4 = nArray[n2];
                        nArray[n2] = nArray[n3];
                        nArray[n3] = n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            int n5 = nArray.length - 1;
            while (n5 >= 0) {
                this.prjLibList.remove((Library)this.libTable.getValueAt(nArray[n5], 1));
                this.tableModel.removeRow(nArray[n5]);
                --n5;
            }
        }
        if ((n = this.libTable.getRowCount()) != 0) {
            int n6 = nArray[nArray.length - 1];
            int n7 = n > n6 ? n6 : n - 1;
            this.selectRow(n7);
        }
    }

    private void selectRow(int n) {
        SwingUtilities.invokeLater(new 2(this, n));
    }

    private void selectRows(Library[] libraryArray) {
        SwingUtilities.invokeLater(new 1(this, libraryArray));
    }

    static JTable ra$libTable(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.libTable;
    }

    static int mav$findRow(JProjectLibrariesPanel jProjectLibrariesPanel, Library library) {
        return jProjectLibrariesPanel.findRow(library);
    }

    static JProjectLibraryList ra$prjLibList(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.prjLibList;
    }

    static JButton ra$editJDKButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.editJDKButton;
    }

    static JProjectLibraries ra$projectLibraries(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.projectLibraries;
    }

    static LibraryList[] ra$libLists(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.libLists;
    }

    static LocalChangeListener ra$LISTENER() {
        return LISTENER;
    }

    static void mav$commit(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.commit();
    }

    static void mav$reload(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.reload();
    }

    static JButton ra$addPathButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.addPathButton;
    }

    static URL ra$DEF_DIR() {
        return DEF_DIR;
    }

    static String mav$capitalize(JProjectLibrariesPanel jProjectLibrariesPanel, String string) {
        return jProjectLibrariesPanel.capitalize(string);
    }

    static LibraryTableModel ra$tableModel(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.tableModel;
    }

    static void wa$DEF_DIR(URL uRL) {
        DEF_DIR = uRL;
    }

    static void mav$selectRows(JProjectLibrariesPanel jProjectLibrariesPanel, Library[] libraryArray) {
        jProjectLibrariesPanel.selectRows(libraryArray);
    }

    static JButton ra$addLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.addLibButton;
    }

    static void mav$syncProjectLibraries(JProjectLibrariesPanel jProjectLibrariesPanel, JProjectLibraryList jProjectLibraryList) {
        jProjectLibrariesPanel.syncProjectLibraries(jProjectLibraryList);
    }

    static JButton ra$editLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.editLibButton;
    }

    static LocalChangeListener2 ra$LISTENER2() {
        return LISTENER2;
    }

    static void mav$selectRow(JProjectLibrariesPanel jProjectLibrariesPanel, int n) {
        jProjectLibrariesPanel.selectRow(n);
    }

    static JButton ra$removeLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.removeLibButton;
    }

    static void mav$deleteSelection(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.deleteSelection();
    }

    static JButton ra$shareLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.shareLibButton;
    }

    static JButton ra$upButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.upButton;
    }

    static JButton ra$downButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.downButton;
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ int v$row;
        final /* synthetic */ JProjectLibrariesPanel this$0;

        public void run() {
            JProjectLibrariesPanel.ra$libTable(this.this$0).setRowSelectionInterval(this.v$row, this.v$row);
        }

        public 2(JProjectLibrariesPanel jProjectLibrariesPanel, int n) {
            this.v$row = n;
            this.this$0 = jProjectLibrariesPanel;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Library[] v$elems;
        final /* synthetic */ JProjectLibrariesPanel this$0;

        public void run() {
            if (this.v$elems == null) {
                return;
            }
            JProjectLibrariesPanel.ra$libTable(this.this$0).clearSelection();
            int n = 0;
            while (n < this.v$elems.length) {
                int n2 = JProjectLibrariesPanel.mav$findRow(this.this$0, this.v$elems[n]);
                if (n2 >= 0) {
                    JProjectLibrariesPanel.ra$libTable(this.this$0).addRowSelectionInterval(n2, n2);
                }
                ++n;
            }
            JProjectLibrariesPanel.ra$libTable(this.this$0).requestFocus();
        }

        public 1(JProjectLibrariesPanel jProjectLibrariesPanel, Library[] libraryArray) {
            this.v$elems = libraryArray;
            this.this$0 = jProjectLibrariesPanel;
        }
    }

    private final class ButtonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            if (object == JProjectLibrariesPanel.ra$editJDKButton(JProjectLibrariesPanel.this)) {
                JDK jDK = JProjectLibrariesPanel.ra$projectLibraries(JProjectLibrariesPanel.this).getJDK();
                JDKPanel jDKPanel = new JDKPanel();
                ListWrapper[] listWrapperArray = new ListWrapper[JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length];
                int n2 = 0;
                while (n2 < JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length) {
                    listWrapperArray[n2] = new ListWrapper(JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this)[n2]);
                    ++n2;
                }
                jDKPanel.initPanel(listWrapperArray, jDK);
                jDKPanel.setSelectionMode(1);
                LocalChangeListener.wa$_panel(JProjectLibrariesPanel.ra$LISTENER(), jDKPanel);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)jDKPanel, null, (String)ControlsArb.getString(45), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER())) {
                    listWrapperArray = jDKPanel.getLibraryLists();
                    int n3 = 0;
                    while (n3 < listWrapperArray.length) {
                        listWrapperArray[n3].commit(listWrapperArray[n3].getWrappedList() != JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this));
                        ++n3;
                    }
                    Library[] libraryArray = jDKPanel.getSelection();
                    if (libraryArray != null && libraryArray.length > 0) {
                        jDK = (JDK)libraryArray[0];
                    }
                    JProjectLibrariesPanel.ra$projectLibraries(JProjectLibrariesPanel.this).setJDK(jDK);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                }
            } else if (object == JProjectLibrariesPanel.ra$addPathButton(JProjectLibrariesPanel.this)) {
                URLChooser uRLChooser = DialogUtil.newURLChooser((URL)JProjectLibrariesPanel.ra$DEF_DIR());
                uRLChooser.setSelectionMode(2);
                uRLChooser.setSelectionScope(1);
                uRLChooser.setShowJarsAsDirs(true);
                int n4 = uRLChooser.showOpenDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(82));
                if (n4 == 0) {
                    URL[] uRLArray = uRLChooser.getSelectedURLs();
                    int n5 = uRLArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        URL uRL = uRLArray[n6];
                        String string = URLFileSystem.getSuffix((URL)uRL);
                        if ((string.equals(".jar") || string.equals(".zip")) && URLFileSystem.exists((URL)uRL) && !URLFileSystem.isDirectory((URL)uRL)) {
                            uRLArray[n6] = URLFactory.newJarURL((URL)uRL, (String)"");
                        }
                        ++n6;
                    }
                    ArrayList<JLibrary> arrayList = new ArrayList<JLibrary>();
                    int n7 = 0;
                    while (n7 < n5) {
                        String string = URLFileSystem.getFileName((URL)uRLArray[n7]);
                        if (!URLFileSystem.isDirectory((URL)uRLArray[0])) {
                            string = string.substring(0, string.lastIndexOf(46));
                        }
                        string = JProjectLibrariesPanel.mav$capitalize(JProjectLibrariesPanel.this, string);
                        JLibrary jLibrary = JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).addLibrary(string);
                        if (jLibrary != null) {
                            jLibrary.setClassPath(new URLPath(uRLArray[n7]));
                            jLibrary.setDeployedByDefault(Boolean.TRUE);
                            jLibrary.setLocked(true);
                            JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).addRow(new Object[]{Boolean.TRUE, jLibrary});
                            arrayList.add(jLibrary);
                            JProjectLibrariesPanel.wa$DEF_DIR(URLFileSystem.getParent((URL)uRLArray[n7]));
                        }
                        ++n7;
                    }
                    if (arrayList.size() > 0) {
                        Library[] libraryArray = new JLibrary[arrayList.size()];
                        arrayList.toArray(libraryArray);
                        JProjectLibrariesPanel.mav$selectRows(JProjectLibrariesPanel.this, libraryArray);
                    }
                }
            } else if (object == JProjectLibrariesPanel.ra$addLibButton(JProjectLibrariesPanel.this)) {
                LibrariesPanel librariesPanel = new LibrariesPanel();
                ListWrapper[] listWrapperArray = new ListWrapper[JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length];
                int n8 = 0;
                while (n8 < listWrapperArray.length) {
                    listWrapperArray[n8] = new ListWrapper(JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this)[n8]);
                    ++n8;
                }
                librariesPanel.setSplit(false);
                librariesPanel.initPanel(listWrapperArray);
                LocalChangeListener.wa$_panel(JProjectLibrariesPanel.ra$LISTENER(), librariesPanel);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)librariesPanel, null, (String)ControlsArb.getString(14), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER())) {
                    HashStructure hashStructure = HashStructure.newInstance();
                    JProjectLibraryList jProjectLibraryList = new JProjectLibraryList(hashStructure);
                    JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).copyTo(jProjectLibraryList);
                    listWrapperArray = librariesPanel.getLibraryLists();
                    int n9 = 0;
                    while (n9 < listWrapperArray.length) {
                        listWrapperArray[n9].commit(listWrapperArray[n9].getWrappedList() != JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this));
                        ++n9;
                    }
                    Library[] libraryArray = librariesPanel.getSelection();
                    if (libraryArray != null) {
                        int n10 = 0;
                        while (n10 < libraryArray.length) {
                            if (JProjectLibrariesPanel.mav$findRow(JProjectLibrariesPanel.this, libraryArray[n10]) < 0) {
                                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).addRow(new Object[]{Boolean.TRUE, libraryArray[n10]});
                            }
                            ++n10;
                        }
                    }
                    JProjectLibrariesPanel.mav$syncProjectLibraries(JProjectLibrariesPanel.this, jProjectLibraryList);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                    JProjectLibrariesPanel.mav$selectRows(JProjectLibrariesPanel.this, libraryArray);
                }
            } else if (object == JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this)) {
                int n11 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary jLibrary = n11 >= 0 ? (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n11, 1) : null;
                LibraryList libraryList = null;
                if (jLibrary instanceof JProjectLibraries.UnresolvedLibrary) {
                    Object object2 = jLibrary.getID();
                    JLibraryList jLibraryList = JLibraryManager.getUserLibraries();
                    if (object2 instanceof URL) {
                        URL uRL = URLFileSystem.getParent((URL)((URL)object2));
                        jLibraryList = JLibraryManager.addLibraryList(uRL);
                        if (((String)(object2 = URLFileSystem.getFileName((URL)((URL)object2)))).endsWith(".library")) {
                            object2 = ((String)object2).substring(0, ((String)object2).length() - ".library".length());
                        }
                    }
                    libraryList = new ListWrapper(jLibraryList);
                    jLibrary = ((ListWrapper)libraryList).addLibrary(object2.toString());
                }
                LibraryEditPanel libraryEditPanel = new LibraryEditPanel(jLibrary);
                LibraryList libraryList2 = libraryList != null ? libraryList : this.findOwningList(jLibrary);
                libraryEditPanel.setListsVisible(false);
                libraryEditPanel.setLibraryList(libraryList2);
                JProjectLibrariesPanel.ra$LISTENER2().initialize(libraryEditPanel, jLibrary, libraryList2);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)libraryEditPanel, null, (String)ControlsArb.getString(24), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER2())) {
                    JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).setValueAt(JProjectLibrariesPanel.ra$LISTENER2().getLibrary(), n11, 1);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                    if (n11 >= 0) {
                        JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, n11);
                    }
                }
            } else if (object == JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this)) {
                JProjectLibrariesPanel.mav$deleteSelection(JProjectLibrariesPanel.this);
            } else if (object == JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this)) {
                JLibrary jLibrary;
                int n12 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary jLibrary2 = jLibrary = n12 >= 0 ? (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n12, 1) : null;
                if (jLibrary != null) {
                    URL uRL;
                    URLChooser uRLChooser = DialogUtil.newURLChooser((URL)JProjectLibrariesPanel.ra$DEF_DIR());
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setURLFilter(JLibraryList.LIB_FILTER);
                    int n13 = uRLChooser.showSaveDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(17));
                    if (n13 == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
                        JLibrary jLibrary3;
                        JLibraryList jLibraryList;
                        URL uRL2;
                        if (URLFileSystem.exists((URL)(uRL = URLFileSystem.ensureSuffix((URL)uRL, (String)".library")))) {
                            if (MessageDialog.confirm((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)30, (Object[])new String[]{ComponentArb.getString((int)38), URLFileSystem.getPlatformPathName((URL)uRL)}), (String)ComponentArb.getString((int)25), null, (boolean)true)) {
                                if (URLFileSystem.isReadOnly((URL)uRL)) {
                                    MessageDialog.error((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)29, (Object[])new String[]{URLFileSystem.getPlatformPathName((URL)uRL)}), (String)ComponentArb.getString((int)35), null);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        if ((uRL2 = URLFileSystem.getParent((URL)uRL)) != null && (jLibraryList = JLibraryManager.addLibraryList(uRL2)) != null && (jLibrary3 = jLibraryList.addLibrary(null, uRL)) != null) {
                            jLibrary3.setClassPath(jLibrary.getClassPath());
                            jLibrary3.setSourcePath(jLibrary.getSourcePath());
                            jLibrary3.setDocPath(jLibrary.getDocPath());
                            jLibrary3.setDeployedByDefault(jLibrary.getDeployedByDefault());
                            JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).remove(jLibrary);
                            JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).setValueAt(jLibrary3, n12, 1);
                            try {
                                JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                            if (jLibrary != null && (n12 = JProjectLibrariesPanel.mav$findRow(JProjectLibrariesPanel.this, jLibrary3)) >= 0) {
                                JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, n12);
                            }
                        }
                    }
                }
            } else if (object == JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this)) {
                int n14 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                if (n14 > 0) {
                    Object object3 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n14, 0);
                    Object object4 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n14, 1);
                    JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).removeRow(n14);
                    JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).insertRow(--n14, new Object[]{object3, object4});
                    JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, n14);
                }
            } else if (object == JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this) && (n = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow()) < JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getRowCount() - 1) {
                Object object5 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n, 0);
                Object object6 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n, 1);
                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).removeRow(n);
                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).insertRow(++n, new Object[]{object5, object6});
                JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, n);
            }
        }

        private LibraryList findOwningList(JLibrary jLibrary) {
            Object object = jLibrary.getID();
            if (JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).findLibrary(object) != null) {
                return JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this);
            }
            LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
            int n = 0;
            while (n < libraryListArray.length) {
                if (libraryListArray[n].findLibrary(object) != null) {
                    if (libraryListArray[n] instanceof JLibraryList && object instanceof URL) {
                        URL uRL = URLFileSystem.getParent((URL)((URL)object));
                        return JLibraryManager.addLibraryList(uRL);
                    }
                    return libraryListArray[n];
                }
                ++n;
            }
            return null;
        }

        private ButtonHandler() {
        }

        ButtonHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ListHandler
    extends KeyAdapter
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRows();
            if (nArray == null || nArray.length != 1) {
                JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).setEnabled(nArray != null && nArray.length > 0);
            } else {
                int n = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary jLibrary = (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(n, 1);
                if (jLibrary != null && !jLibrary.isLocked()) {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this), (String)ControlsArb.getString(4));
                } else {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this), (String)ControlsArb.getString(83));
                }
                JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this).setEnabled(true);
                JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).setEnabled(true);
                JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this).setEnabled(jLibrary instanceof HashStructureAdapter);
                JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this).setEnabled(n > 0);
                JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this).setEnabled(n < JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getRowCount() - 1);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u007f') {
                if (JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).isEnabled()) {
                    JProjectLibrariesPanel.mav$deleteSelection(JProjectLibrariesPanel.this);
                }
                keyEvent.consume();
            }
        }

        private ListHandler() {
        }

        ListHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class LibraryCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        public void setForeground(Color color) {
            super.setForeground(color);
            this.unselectedForeground = color;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.unselectedBackground = color;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            }
            this.setDisabledIcon(null);
            this.setIcon(this.getIcon(object));
            if (object instanceof Library) {
                this.setToolTipText(((Library)object).getToolTipText());
            }
            return this;
        }

        public boolean isOpaque() {
            Color color = this.getBackground();
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
            return !bl && super.isOpaque();
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text") {
                super.firePropertyChange(string, object, object2);
            }
        }

        private Icon getIcon(Object object) {
            if (object instanceof JLibrary) {
                Library library = (Library)object;
                URLPath uRLPath = library.getClassPath();
                if (uRLPath.size() == 0 && (uRLPath = library.getSourcePath()).size() == 0 && (uRLPath = library.getDocPath()).size() == 0) {
                    super.setForeground(Color.red);
                    return LibraryArb.getIcon(65);
                }
                return library.getIcon();
            }
            return null;
        }

        private LibraryCellRenderer() {
        }

        LibraryCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class BooleanCellRenderer
    extends JCheckBox
    implements Serializable,
    TableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground;

        BooleanCellRenderer() {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setBorder(noFocusBorder);
            this.setHorizontalAlignment(0);
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.unselectedForeground = color;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.unselectedBackground = color;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(object);
            return this;
        }

        public boolean isOpaque() {
            Color color = this.getBackground();
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
            return !bl && super.isOpaque();
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text") {
                super.firePropertyChange(string, object, object2);
            }
        }

        protected void setValue(Object object) {
            boolean bl = object instanceof Boolean ? (Boolean)object : false;
            this.setSelected(bl);
        }
    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }

        private LocalChangeListener() {
        }

        LocalChangeListener(1 var1_1) {
            this();
        }

        static void wa$_panel(LocalChangeListener localChangeListener, LibraryPanel libraryPanel) {
            localChangeListener._panel = libraryPanel;
        }

        public final class 1 {
        }
    }

    private static final class LocalChangeListener2
    implements VetoableChangeListener {
        private boolean _vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;
        private LibraryList _list;

        public void initialize(LibraryEditPanel libraryEditPanel, Library library, LibraryList libraryList) {
            this._newPanel = libraryEditPanel;
            this._lib = library;
            this._list = libraryList;
        }

        public Library getLibrary() {
            return this._lib;
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            try {
                if (!(this._list instanceof MutableLibraryList)) {
                    return;
                }
                JLibraryModel jLibraryModel = new JLibraryModel((JLibrary)this._lib, (MutableLibraryList)this._list, (Component)this._newPanel);
                jLibraryModel.setName(this._newPanel.getLibraryName());
                jLibraryModel.setClassPath(this._newPanel.getClassPath());
                jLibraryModel.setSourcePath(this._newPanel.getSourcePath());
                jLibraryModel.setDocPath(this._newPanel.getDocPath());
                jLibraryModel.setDeployedByDefault(this._newPanel.isDeployByDefault());
                this._lib = jLibraryModel.commit();
                if (this._list instanceof ListWrapper) {
                    ((ListWrapper)this._list).commit(true);
                }
            }
            catch (Exception exception) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }

        private LocalChangeListener2() {
        }

        LocalChangeListener2(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class LibraryTableModel
    extends DefaultTableModel {
        private LibraryTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 && n >= 0 && n < this.getRowCount();
        }

        LibraryTableModel(String[] stringArray, int n, 1 var3_3) {
            this(stringArray, n);
        }

        public final class 1 {
        }
    }
}

