/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.model.ContentSetPanel;
import oracle.jdeveloper.model.JavaContentValidator;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.ModelArb;

public class JProjectPanel
extends ProjectSettingsTraversablePanel
implements GridBagConstants {
    private final ContentSetPanel projectContentPanel;
    private JLabel packageLabel;
    private JTextField packageTextField;
    private JLabel outputDirLabel;
    private URLTextField outputDirTextField;
    private JButton outputDirButton;
    private JavaContentValidator contentSetValidator;
    private JLabel defaultSourceDirLabel;
    private URLTextField defaultSourceDirTextField;
    private static final String[] PROPERTY_KEYS = new String[]{PathsConfiguration.JAVA_CONTENT_SET_KEY, JavaProject.OUTPUT_DIRECTORY, "defaultPackage"};

    void $init$() {
        this.projectContentPanel = new ContentSetPanel();
        this.packageLabel = new JLabel();
        this.packageTextField = new JTextField();
        this.outputDirLabel = new JLabel();
        this.outputDirTextField = new URLTextField(null, true, false);
        this.outputDirButton = new JButton();
        this.defaultSourceDirLabel = new JLabel();
        this.defaultSourceDirTextField = new URLTextField();
    }

    public JProjectPanel() {
        this.$init$();
        this.setHelpID("f1_idedprojectcontentmaindpp_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDataKey() {
        return null;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        boolean bl = JProjectPanel.isDefaultProject((Namespace)traversableContext);
        Project project = (Project)traversableContext.find("Project");
        PropertyStorage propertyStorage = JProjectPanel.getPropertyData((Namespace)traversableContext);
        if (this.contentSetValidator == null) {
            this.contentSetValidator = new JavaContentValidator();
            this.projectContentPanel.setValidator(this.contentSetValidator);
        }
        this.loadFrom(project, propertyStorage, bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() != 2) {
            Project project = (Project)traversableContext.find("Project");
            PropertyStorage propertyStorage = JProjectPanel.getPropertyData((Namespace)traversableContext);
            boolean bl = JProjectPanel.isDefaultProject((Namespace)traversableContext);
            this.commitTo(project, propertyStorage, bl);
        }
    }

    protected ContentSetPanel getContentSetPanel() {
        return this.projectContentPanel;
    }

    private void loadFrom(Project project, PropertyStorage propertyStorage, boolean bl) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project, propertyStorage);
        ContentSet contentSet = pathsConfiguration.getJavaContentSet();
        JavaProject javaProject = JavaProject.getInstance(project, propertyStorage.getProperties());
        this.packageTextField.setText(javaProject.getDefaultPackage());
        if (bl) {
            this.projectContentPanel.setVisible(false);
            this.packageTextField.setVisible(false);
            this.packageLabel.setVisible(false);
            this.defaultSourceDirLabel.setVisible(true);
            this.defaultSourceDirTextField.setVisible(true);
            URL uRL = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.defaultSourceDirTextField.setBaseURL(uRL);
            URL uRL2 = pathsConfiguration.getProjectSourcePath().getFirstEntry();
            if (uRL2 == null) {
                String string = oracle.ide.resource.ModelArb.getString((int)17);
                uRL2 = URLFactory.newDirURL((URL)uRL, (String)string);
            }
            this.defaultSourceDirTextField.setURL(uRL2);
            this.outputDirButton.setVisible(false);
            this.outputDirTextField.setBaseURL(uRL);
            URL uRL3 = javaProject.getOutputDirectory();
            if (uRL3 == null) {
                String string = oracle.ide.resource.ModelArb.getString((int)18);
                uRL3 = URLFactory.newDirURL((URL)uRL, (String)string);
            }
            this.outputDirTextField.setURL(uRL3);
        } else {
            this.defaultSourceDirLabel.setVisible(false);
            this.defaultSourceDirTextField.setVisible(false);
            this.projectContentPanel.setVisible(true);
            this.projectContentPanel.loadFrom(project, contentSet);
            URL uRL = javaProject.getOutputDirectory();
            this.outputDirTextField.setBaseURL(null);
            this.outputDirTextField.setURL(uRL);
        }
        this.validate();
    }

    private void commitTo(Project project, PropertyStorage propertyStorage, boolean bl) throws TraversalException {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project, propertyStorage);
        JavaProject javaProject = JavaProject.getInstance(project, propertyStorage.getProperties());
        URL uRL = this.outputDirTextField.getURL();
        String string = this.packageTextField.getText();
        if (bl) {
            this.validateDefaultProjectProperties();
            URL uRL2 = this.defaultSourceDirTextField.getURL();
            ContentSet contentSet = pathsConfiguration.getJavaContentSet();
            contentSet.getURLPath().setEntries(new URL[]{uRL2});
        } else {
            this.validateProjectProperties();
            try {
                this.projectContentPanel.saveContentSet();
            }
            catch (ContentSetPanel.EmptyContentSetException emptyContentSetException) {
                throw new TraversalException(ModelArb.getString(105), ModelArb.getString(128));
            }
        }
        javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)uRL));
        javaProject.setDefaultPackage(string);
    }

    private void validateProjectProperties() throws TraversalException {
        URLPath uRLPath = this.projectContentPanel.getURLPath();
        if (uRLPath.size() <= 0) {
            throw new TraversalException(ModelArb.getString(105), ModelArb.getString(128));
        }
        URL uRL = this.outputDirTextField.getURL();
        if (uRL == null) {
            if (!ModelUtil.hasLength((String)this.outputDirTextField.getText())) {
                throw new TraversalException(JProjectArb.getString(146), JProjectArb.getString(143));
            }
            throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(144), this.outputDirTextField.getText().trim()), JProjectArb.getString(143));
        }
        if (URLFileSystem.isReadOnly((URL)uRL)) {
            throw new TraversalException(JProjectArb.getString(147), JProjectArb.getString(143));
        }
        if (!URLFileSystem.isValid((URL)uRL)) {
            String string = URLFileSystem.getPlatformPathName((URL)uRL);
            if (string.length() > 80) {
                string = StringUtil.truncateFileNameForMessage((String)string);
            }
            this.outputDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(144), string), JProjectArb.getString(143));
        }
        String string = this.packageTextField.getText();
        if (ModelUtil.hasLength((String)string) && !IdeUtil.isPackageIdentifier((String)string)) {
            this.packageTextField.requestFocus();
            throw new TraversalException(JProjectArb.format(125, string), JProjectArb.getString(124));
        }
    }

    private void validateDefaultProjectProperties() throws TraversalException {
        URL uRL = this.defaultSourceDirTextField.getURL();
        URL uRL2 = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
        if (uRL == null || URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true) == null || !URLFileSystem.isValid((URL)uRL)) {
            this.defaultSourceDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format(135, JProjectArb.getString(47), this.defaultSourceDirTextField.getText()), JProjectArb.getString(126));
        }
        URL uRL3 = this.outputDirTextField.getURL();
        if (uRL3 == null || URLFileSystem.toRelativeSpec((URL)uRL3, (URL)uRL2, (boolean)true) == null || !URLFileSystem.isValid((URL)uRL3)) {
            this.outputDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format(135, JProjectArb.getString(136), this.outputDirTextField.getText()));
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.packageLabel, (Component)this.packageTextField, (String)JProjectArb.getString(45));
        ResourceUtils.resLabel((JLabel)this.outputDirLabel, (Component)this.outputDirTextField, (String)JProjectArb.getString(140));
        ResourceUtils.resLabel((JLabel)this.defaultSourceDirLabel, (Component)this.defaultSourceDirTextField, (String)JProjectArb.getString(42));
        ResourceUtils.resButton((AbstractButton)this.outputDirButton, (String)JProjectArb.getString(41));
        this.projectContentPanel.setContentSetLabel(ModelArb.getString(124));
        this.outputDirTextField.setDialogTitle(JProjectArb.getString(141));
        this.outputDirButton.addActionListener((ActionListener)this.outputDirTextField);
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 5, 0, 0);
        int n = -1;
        this.setLayout(new GridBagLayout());
        this.add(this.defaultSourceDirLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.defaultSourceDirTextField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, insets2, 0, 0));
        this.add(this.projectContentPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 10.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.outputDirLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.outputDirTextField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.outputDirButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 0, 0), 0, 0));
        this.add(this.packageLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.packageTextField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
    }
}

