/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cmd.NewInterfaceCommand;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JDevTechnologies;
import oracle.jdeveloper.model.JProjectTechnologyNotifier;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.JDevMenus;

class JProjectStructureController
implements Addin,
Controller {
    public static final int ADD_TO_PROJECT_CMD_ID = ContentSetSupport.ADD_TO_PROJECT_CMD_ID;
    private static JMenuItem editConfigurationsDlgItem;
    private static JMenuItem addToProjectContextItem;
    private static boolean menusBuilt;
    private JMenuItem newClassItem;
    private JMenuItem newInterfaceItem;
    private JMenuItem emptyItem;
    private JMenuItem deleteMenuItem;
    private IdeAction projectSettingsAction;
    private IdeAction defaultProjectSettingsAction;
    private IdeAction addToProjectAction;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 35) {
            Project project = context.getProject();
            if (project != null) {
                ProjectPropertiesDialog.showDialog((Project)project);
            }
            return true;
        }
        if (n == 37) {
            Project project = Ide.getDefaultProject();
            if (project != null) {
                ProjectPropertiesDialog.showDialog((Project)project);
            }
            return true;
        }
        if (n == NewInterfaceCommand.CMD_ID) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Command command = CommandProcessor.createCommand((String)ideAction.getCommand(), (Context)context);
            try {
                commandProcessor.invoke(command);
            }
            catch (Exception exception) {
                oracle.ide.dialogs.ExceptionDialog.showExceptionDialog((Context)context, (Throwable)exception);
            }
            return true;
        }
        if (n == ADD_TO_PROJECT_CMD_ID) {
            Element element = context.getElement();
            if (element == null) {
                return false;
            }
            OpenCommandData openCommandData = new OpenCommandData(true);
            String string = null;
            DefaultURLFilter defaultURLFilter = null;
            if (element.getData() instanceof Workspaces) {
                string = ModelArb.getString(135);
                defaultURLFilter = new DefaultURLFilter(ModelArb.getString(136));
                defaultURLFilter.addExtension(".jws");
            } else if (element instanceof Workspace) {
                string = ModelArb.getString(137);
                defaultURLFilter = new DefaultURLFilter(ModelArb.getString(138));
                defaultURLFilter.addExtension(".jpr");
            }
            if (defaultURLFilter != null) {
                openCommandData.dialogTitle = string;
                openCommandData.urlFilter = defaultURLFilter;
                IdeAction ideAction2 = IdeAction.find((int)9);
                ideAction2.putValue("UserData", (Object)openCommandData);
                try {
                    try {
                        ideAction2.performAction(context);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
                finally {
                    ideAction2.putValue("UserData", null);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 35) {
            boolean bl = context.getProject() != null;
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == ADD_TO_PROJECT_CMD_ID) {
            Element element = context.getElement();
            String string = null;
            boolean bl = false;
            if (element == null) {
                return false;
            }
            if (element.getData() instanceof Workspaces || element instanceof Workspace) {
                string = ModelArb.format(43, element.getShortLabel());
                bl = true;
            } else if (element instanceof Project || context.getProject() != null) {
                string = ModelArb.getString(42);
                bl = true;
            }
            ideAction.setEnabled(bl);
            ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string));
            return true;
        }
        if (n == 21) {
            View view;
            String string = null;
            View view2 = view = context != null ? context.getView() : null;
            if (view instanceof ProjectNavigatorWindow) {
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length > 0) {
                    if (elementArray[0] instanceof Project) {
                        string = context.getWorkspace().getShortLabel();
                        ideAction.setEnabled(true);
                    } else if (elementArray[0] instanceof Workspace) {
                        string = Ide.getWorkspaces().getShortLabel();
                        ideAction.setEnabled(true);
                    } else if (elementArray[0] == Ide.getWorkspaces() || elementArray[0].getData() == Ide.getWorkspaces()) {
                        ideAction.setEnabled(false);
                    } else {
                        Project project = context.getProject();
                        if (project != null) {
                            string = project.getShortLabel();
                            ideAction.setEnabled(false);
                        }
                    }
                }
                String string2 = null;
                string2 = string == null ? IdeArb.getString((int)223) : IdeArb.format((int)224, string);
                ideAction.putValue("Name", (Object)string2);
                return true;
            }
        } else if (n == NewInterfaceCommand.CMD_ID) {
            boolean bl = context != null && context.getProject() != null;
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private IdeAction getProjectSettingsAction() {
        if (this.projectSettingsAction == null) {
            this.projectSettingsAction = IdeAction.find((int)35);
        }
        return this.projectSettingsAction;
    }

    private synchronized void buildMenus(MenuManager menuManager) {
        if (!menusBuilt) {
            IdeAction ideAction = this.getAction(8, IdeArb.getString((int)50), IdeArb.getInteger((int)51), IdeArb.getInstance(), 52, null);
            ideAction.setEnabled(true);
            this.newClassItem = menuManager.createMenuItem((ToggleAction)ideAction, 1.0f);
            ideAction = this.getAction(NewInterfaceCommand.CMD_ID, CommandArb.getString(5), CommandArb.getInteger(6), CommandArb.getInstance(), 7, this);
            ideAction.setCommand(NewInterfaceCommand.CMD_NAME);
            ideAction.setEnabled(true);
            this.newInterfaceItem = menuManager.createMenuItem((ToggleAction)ideAction, 1.0f);
            editConfigurationsDlgItem = menuManager.createMenuItem((ToggleAction)this.getProjectSettingsAction(), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
            ideAction = IdeAction.find((int)ADD_TO_PROJECT_CMD_ID);
            addToProjectContextItem = menuManager.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_FILE_ADD_TO_PROJECT);
            ideAction = IdeAction.find((int)20);
            this.deleteMenuItem = menuManager.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_FILE_ERASE);
            menusBuilt = true;
        }
    }

    static boolean isSystemNavigator(View view) {
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        return JProjectStructureController.viewNavigatorMatchesManager(view, navigatorManager);
    }

    private static boolean isApplicationNavigator(View view) {
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        return JProjectStructureController.viewNavigatorMatchesManager(view, navigatorManager);
    }

    private static boolean isConnectionNavigator(View view) {
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        return JProjectStructureController.viewNavigatorMatchesManager(view, navigatorManager);
    }

    private static boolean viewNavigatorMatchesManager(View view, NavigatorManager navigatorManager) {
        if (view instanceof NavigatorWindow) {
            NavigatorWindow navigatorWindow = (NavigatorWindow)view;
            NavigatorManager navigatorManager2 = navigatorWindow.getManager();
            return navigatorManager2 == navigatorManager;
        }
        return false;
    }

    public void initialize() {
        JDevMenus.loadToolsMenu();
        Menubar menubar = Ide.getMenubar();
        this.projectSettingsAction = IdeAction.find((int)35);
        this.projectSettingsAction.addController((Controller)this);
        this.defaultProjectSettingsAction = IdeAction.find((int)37);
        this.defaultProjectSettingsAction.addController((Controller)this);
        this.defaultProjectSettingsAction.setEnabled(true);
        IdeAction ideAction = IdeActions.getFileRemoveFromIDEAction();
        ideAction.addController((Controller)this);
        String string = ModelArb.format(43, "");
        this.addToProjectAction = this.getAction(ADD_TO_PROJECT_CMD_ID, StringUtils.stripMnemonic((String)string), new Integer(StringUtils.getMnemonicKeyCode((String)string)), ModelArb.getInstance(), 45, this);
        this.emptyItem = new JMenuItem(IdeArb.getString((int)233));
        this.emptyItem.setEnabled(false);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdeveloper/model/projectaccelerators.xml");
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        JProjectMenuListener jProjectMenuListener = new JProjectMenuListener(null);
        navigatorManager.addContextMenuListener((ContextMenuListener)jProjectMenuListener, Workspaces.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)jProjectMenuListener, Project.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)new NodeMenuListener(null), Node.class);
        JDevTechnologies.register();
        JProjectTechnologyNotifier.initialize();
    }

    private IdeAction getAction(int n, String string, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Controller controller) {
        IdeAction ideAction = IdeAction.get((int)n, (String)AddinManager.getAddinManager().getCommand(n, null), (String)string, (ArrayResourceBundle)arrayResourceBundle, (int)n3);
        ideAction.setEnabled(false);
        ideAction.putValue("MnemonicKey", (Object)n2);
        if (controller != null) {
            ideAction.addController(controller);
        }
        return ideAction;
    }

    static JMenuItem ra$deleteMenuItem(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.deleteMenuItem;
    }

    static boolean maS$isConnectionNavigator(View view) {
        return JProjectStructureController.isConnectionNavigator(view);
    }

    static boolean ra$menusBuilt() {
        return menusBuilt;
    }

    static void mav$buildMenus(JProjectStructureController jProjectStructureController, MenuManager menuManager) {
        jProjectStructureController.buildMenus(menuManager);
    }

    static JMenuItem ra$addToProjectContextItem() {
        return addToProjectContextItem;
    }

    static IdeAction mav$getProjectSettingsAction(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.getProjectSettingsAction();
    }

    static JMenuItem ra$newClassItem(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.newClassItem;
    }

    static JMenuItem ra$newInterfaceItem(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.newInterfaceItem;
    }

    static JMenuItem ra$editConfigurationsDlgItem() {
        return editConfigurationsDlgItem;
    }

    private class NodeMenuListener
    implements ActiveViewListener,
    ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            Element element;
            View view;
            Context context;
            if (contextMenu != null && (context = contextMenu.getContext()) != null && (view = context.getView()) != null && !JProjectStructureController.maS$isConnectionNavigator(view) && (element = context.getElement()) != null && !(element instanceof Library)) {
                if (!JProjectStructureController.ra$menusBuilt()) {
                    JProjectStructureController.mav$buildMenus(JProjectStructureController.this, (MenuManager)contextMenu);
                }
                if (element instanceof Workspace) {
                    contextMenu.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                }
                contextMenu.add((Component)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this), 1.0f);
                Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
            Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void activeViewChanged(ActiveViewEvent activeViewEvent) {
            IdeAction ideAction = (IdeAction)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this).getAction();
            ideAction.updateAction();
        }

        private NodeMenuListener() {
        }

        NodeMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class JProjectMenuListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            Context context;
            if (contextMenu != null && (context = contextMenu.getContext()) != null) {
                if (!JProjectStructureController.ra$menusBuilt()) {
                    JProjectStructureController.mav$buildMenus(JProjectStructureController.this, (MenuManager)contextMenu);
                }
                if (context.getProject() != null) {
                    if (JProjectStructureController.isSystemNavigator(context.getView())) {
                        contextMenu.add((Component)JProjectStructureController.ra$newClassItem(JProjectStructureController.this), 1.0f);
                        contextMenu.add((Component)JProjectStructureController.ra$newInterfaceItem(JProjectStructureController.this), 1.0f);
                    }
                    contextMenu.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                    JProjectStructureController.ra$editConfigurationsDlgItem().setEnabled(true);
                    contextMenu.add((Component)JProjectStructureController.ra$editConfigurationsDlgItem(), MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                } else {
                    contextMenu.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                }
                if (context.getProject() != null || context.getWorkspace() != null) {
                    contextMenu.add((Component)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this), MenuConstants.SECTION_FILE_ERASE_REMOVE);
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return JProjectStructureController.this.handleEvent(JProjectStructureController.mav$getProjectSettingsAction(JProjectStructureController.this), context);
        }

        private JProjectMenuListener() {
        }

        JProjectMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

