/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.ChangeInfo;
import oracle.jdeveloper.model.JProjectTechnologyEvent;
import oracle.jdeveloper.model.JProjectTechnologyListener;

public final class JProjectTechnologyNotifier {
    private static final HashMap _listenerMap = new HashMap();
    private static ProjectChangeListener _listener;
    private static final String ITEM_KEY;

    static {
        ITEM_KEY = TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY + "/";
    }

    static void initialize() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener((String)TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY, (ProjectChangeListener)_listener);
        }
    }

    public static void registerTechnologyListener(String string, JProjectTechnologyListener jProjectTechnologyListener) {
        LinkedList<JProjectTechnologyListener> linkedList = (LinkedList<JProjectTechnologyListener>)_listenerMap.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<JProjectTechnologyListener>();
            _listenerMap.put(string, linkedList);
        }
        linkedList.add(jProjectTechnologyListener);
    }

    public static void unregisterTechnologyListener(String string, JProjectTechnologyListener jProjectTechnologyListener) {
        List list = (List)_listenerMap.get(string);
        if (list == null || !list.remove(jProjectTechnologyListener)) {
            throw new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            _listenerMap.remove(string);
        }
    }

    private static void fireTechnologyAdded(Project project, String string) {
        Object v = _listenerMap.get(string);
        if (v != null) {
            List list = (List)v;
            JProjectTechnologyEvent jProjectTechnologyEvent = new JProjectTechnologyEvent(project, string);
            for (JProjectTechnologyListener jProjectTechnologyListener : list) {
                jProjectTechnologyListener.technologyAdded(jProjectTechnologyEvent);
            }
        }
    }

    private static void fireTechnologyRemoved(Project project, String string) {
        Object v = _listenerMap.get(string);
        if (v != null) {
            List list = (List)v;
            JProjectTechnologyEvent jProjectTechnologyEvent = new JProjectTechnologyEvent(project, string);
            for (JProjectTechnologyListener jProjectTechnologyListener : list) {
                jProjectTechnologyListener.technologyRemoved(jProjectTechnologyEvent);
            }
        }
    }

    static String ra$ITEM_KEY() {
        return ITEM_KEY;
    }

    static void maS$fireTechnologyAdded(Project project, String string) {
        JProjectTechnologyNotifier.fireTechnologyAdded(project, string);
    }

    static void maS$fireTechnologyRemoved(Project project, String string) {
        JProjectTechnologyNotifier.fireTechnologyRemoved(project, string);
    }

    public static final class 1
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            ChangeInfo[] changeInfoArray = projectChangeEvent.getChangeDetails();
            int n = changeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeInfo changeInfo = changeInfoArray[n2];
                if (changeInfo.getPropertyName().startsWith(JProjectTechnologyNotifier.ra$ITEM_KEY())) {
                    switch (changeInfo.getChangeType()) {
                        case 1: 
                        case 2: {
                            JProjectTechnologyNotifier.maS$fireTechnologyAdded(projectChangeEvent.getProject(), changeInfo.getNewValueAsString());
                            break;
                        }
                        case 3: {
                            JProjectTechnologyNotifier.maS$fireTechnologyRemoved(projectChangeEvent.getProject(), changeInfo.getOldValueAsString());
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

