/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.SourceRootHelper;
import oracle.jdeveloper.resource.JProjectArb;

public final class JProjectUtil {
    private static final String JAVA_NODE_KEY = "java-node-key";
    private static boolean canceled;

    private JProjectUtil() {
    }

    public static URL getProjectBasePath(Project project) {
        URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL uRL = uRLPath.getFirstEntry();
        if (uRL == null) {
            uRL = URLFileSystem.getParent((URL)project.getURL());
        }
        return uRL;
    }

    public static void addLibraries(Project project, Object[] objectArray) {
        JProjectUtil._updateLibraries(project, objectArray, true);
    }

    public static void removeLibraries(Project project, Object[] objectArray) {
        JProjectUtil._updateLibraries(project, objectArray, false);
    }

    public static void setOutputDirectory(Project project, URL uRL) {
        JavaProject.getInstance(project).setOutputDirectory(uRL);
    }

    public static void execturePathChange(Project project, Runnable runnable) {
        project.applyBatchChanges(runnable);
    }

    private static void _updateLibraries(Project project, Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            project.applyBatchChanges((Runnable)new 1(objectArray, bl, project));
        }
    }

    private static void resetCancelState() {
        canceled = false;
    }

    static void notifyCanceled() {
        canceled = true;
    }

    static URL[] getSourceRoots(URL[] uRLArray, SourceRootHelper[] sourceRootHelperArray) {
        JProjectUtil.resetCancelState();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        while (n < uRLArray.length) {
            if (canceled) {
                return new URL[0];
            }
            URL uRL = uRLArray[n];
            ArrayList arrayList2 = JProjectUtil.findSourceRootsFromURL(uRL, sourceRootHelperArray);
            if (arrayList2.size() > 0) {
                arrayList.addAll(arrayList2);
            } else {
                arrayList.add(uRL);
            }
            JProjectUtil.ensureRootContentIsIncluded(uRL, arrayList, sourceRootHelperArray);
            ++n;
        }
        URL[] uRLArray2 = new URL[arrayList.size()];
        arrayList.toArray(uRLArray2);
        return uRLArray2;
    }

    private static void ensureRootContentIsIncluded(URL uRL, List list, SourceRootHelper[] sourceRootHelperArray) {
        URLFilter uRLFilter;
        URL[] uRLArray;
        if (list.contains(uRL)) {
            return;
        }
        boolean bl = false;
        for (URL uRL2 : list) {
            if (!URLFileSystem.isBaseURLFor((URL)uRL, (URL)uRL2)) continue;
            bl = true;
            break;
        }
        if (bl && (uRLArray = URLFileSystem.list((URL)uRL, (URLFilter)(uRLFilter = GlobalIgnoreList.getURLFilter()))) != null) {
            boolean bl2 = false;
            int n = 0;
            while (n < uRLArray.length) {
                if (URLFileSystem.hasSuffix((URL)uRLArray[n], (String)".java")) {
                    bl2 = true;
                    break;
                }
                int n2 = 0;
                while (n2 < sourceRootHelperArray.length) {
                    if (URLFileSystem.hasSuffix((URL)uRLArray[n], (String)sourceRootHelperArray[n2].getFileExtension())) {
                        bl2 = true;
                        break;
                    }
                    if (bl2) break;
                    ++n2;
                }
                ++n;
            }
            if (bl2) {
                list.add(0, uRL);
            }
        }
    }

    static ArrayList getSourceRootsFromFolder(URL uRL, SourceRootHelper[] sourceRootHelperArray) {
        JProjectUtil.resetCancelState();
        return JProjectUtil.findSourceRootsFromURL(uRL, sourceRootHelperArray);
    }

    private static ArrayList findSourceRootsFromURL(URL uRL, SourceRootHelper[] sourceRootHelperArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URLFilter uRLFilter = GlobalIgnoreList.getURLFilter();
        URL[] uRLArray = URLFileSystem.list((URL)uRL, (URLFilter)uRLFilter);
        if (uRLArray != null) {
            HashMap hashMap = JProjectUtil.buildNodeMap(uRLArray, sourceRootHelperArray);
            Node[] nodeArray = JProjectUtil.getNodesForKey(hashMap, JAVA_NODE_KEY);
            int n = 0;
            while (n < nodeArray.length) {
                if (canceled) {
                    return new ArrayList(0);
                }
                JavaSourceNode javaSourceNode = (JavaSourceNode)nodeArray[n];
                boolean[] blArray = new boolean[]{false};
                URL uRL2 = JProjectUtil.determineSourceRoot(javaSourceNode, false, blArray);
                if (!blArray[0] && !arrayList.contains(uRL2)) {
                    arrayList.add(uRL2);
                    return arrayList;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < sourceRootHelperArray.length) {
                if (canceled) {
                    return new ArrayList(0);
                }
                String string = sourceRootHelperArray[n2].getClass().getName();
                Node[] nodeArray2 = JProjectUtil.getNodesForKey(hashMap, string);
                int n3 = 0;
                while (n3 < nodeArray2.length) {
                    Node node = nodeArray2[n3];
                    boolean[] blArray = new boolean[]{false};
                    URL uRL3 = sourceRootHelperArray[n2].determineSourceRoot(node, blArray);
                    if (!blArray[0] && !arrayList.contains(uRL3)) {
                        arrayList.add(uRL3);
                        return arrayList;
                    }
                    ++n3;
                }
                ++n2;
            }
            URL[] uRLArray2 = JProjectUtil.getDirectories(uRLArray);
            int n4 = 0;
            while (n4 < uRLArray2.length) {
                if (canceled) {
                    return new ArrayList(0);
                }
                URL uRL4 = uRLArray2[n4];
                ArrayList arrayList2 = JProjectUtil.findSourceRootsFromURL(uRL4, sourceRootHelperArray);
                if (arrayList2.size() == 1) {
                    URL uRL5 = (URL)arrayList2.get(0);
                    if (!arrayList.contains(uRL5)) {
                        arrayList.add(uRL5);
                    }
                    if (URLFileSystem.isBaseURLFor((URL)uRL5, (URL)uRL)) {
                        return arrayList;
                    }
                } else if (arrayList2.size() > 0) {
                    for (URL uRL6 : arrayList2) {
                        if (arrayList.contains(uRL6)) continue;
                        arrayList.add(uRL6);
                    }
                }
                ++n4;
            }
        } else if (URLFileSystem.isDirectoryPath((URL)uRL)) {
            arrayList.add(uRL);
        }
        if (canceled) {
            return new ArrayList(0);
        }
        return arrayList;
    }

    static URL getSourceRootForFile(URL uRL, boolean bl, SourceRootHelper[] sourceRootHelperArray) {
        URL[] uRLArray = new URL[]{uRL};
        HashMap hashMap = JProjectUtil.buildNodeMap(uRLArray, sourceRootHelperArray);
        Node[] nodeArray = JProjectUtil.getNodesForKey(hashMap, JAVA_NODE_KEY);
        if (nodeArray.length == 1) {
            boolean[] blArray = new boolean[]{false};
            URL uRL2 = JProjectUtil.determineSourceRoot((JavaSourceNode)nodeArray[0], bl, blArray);
            return uRL2;
        }
        int n = 0;
        while (n < sourceRootHelperArray.length) {
            String string = sourceRootHelperArray[n].getClass().getName();
            Node[] nodeArray2 = JProjectUtil.getNodesForKey(hashMap, string);
            int n2 = 0;
            while (n2 < nodeArray2.length) {
                Node node = nodeArray2[n2];
                boolean[] blArray = new boolean[]{false};
                URL uRL3 = sourceRootHelperArray[n].determineSourceRoot(node, blArray);
                if (!blArray[0]) {
                    return uRL3;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static Node[] getNodesForKey(HashMap hashMap, String string) {
        if (hashMap.containsKey(string)) {
            List list = (List)hashMap.get(string);
            Node[] nodeArray = new Node[list.size()];
            list.toArray(nodeArray);
            return nodeArray;
        }
        return new Node[0];
    }

    private static HashMap buildNodeMap(URL[] uRLArray, SourceRootHelper[] sourceRootHelperArray) {
        HashMap hashMap = new HashMap(sourceRootHelperArray.length + 1);
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            if (URLFileSystem.hasSuffix((URL)uRL, (String)".java")) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)uRL);
                    JProjectUtil.store(node, hashMap, JAVA_NODE_KEY);
                }
                catch (Exception exception) {}
            } else {
                int n2 = 0;
                while (n2 < sourceRootHelperArray.length) {
                    if (URLFileSystem.hasSuffix((URL)uRL, (String)sourceRootHelperArray[n2].getFileExtension())) {
                        try {
                            Node node = NodeFactory.findOrCreate((Class)sourceRootHelperArray[n2].getNodeClass(), (URL)uRL);
                            JProjectUtil.store(node, hashMap, sourceRootHelperArray[n2].getClass().getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashMap;
    }

    private static void store(Node node, HashMap hashMap, String string) {
        List<Node> list;
        if (hashMap.containsKey(string)) {
            list = (List)hashMap.get(string);
        } else {
            list = new ArrayList();
            hashMap.put(string, list);
        }
        list.add(node);
    }

    private static URL[] getDirectories(URL[] uRLArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (URLFileSystem.isDirectory((URL)uRL)) continue;
            iterator.remove();
        }
        URL[] uRLArray2 = new URL[arrayList.size()];
        arrayList.toArray(uRLArray2);
        return uRLArray2;
    }

    static URL determineSourceRoot(JavaSourceNode javaSourceNode, boolean bl, boolean[] blArray) {
        URL uRL = javaSourceNode.getURL();
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        String string = javaSourceNode.getPackage();
        if (ModelUtil.hasLength((String)string)) {
            string = string.replace('.', '/');
            string = string.concat("/");
        }
        URL uRL3 = uRL2;
        if (ModelUtil.hasLength((String)string) && (uRL3 = URLFileSystem.getBaseParent((URL)uRL2, (String)string)).equals(uRL2)) {
            blArray[0] = true;
            if (bl) {
                String string2 = JProjectArb.format(109, URLFileSystem.getPlatformPathName((URL)javaSourceNode.getURL()));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)JProjectArb.getString(108), null);
            }
        }
        return uRL3;
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Object[] v$libraries;
        private final /* synthetic */ boolean v$add;
        private final /* synthetic */ Project v$project;

        public void run() {
            int n = 0;
            while (n < this.v$libraries.length) {
                if (this.v$libraries[n] != null) {
                    if (this.v$add) {
                        JProjectLibraries.getInstance((PropertyStorage)this.v$project).addLibrary(this.v$libraries[n]);
                    } else {
                        JProjectLibraries.getInstance((PropertyStorage)this.v$project).removeLibrary(this.v$libraries[n]);
                    }
                }
                ++n;
            }
        }

        public 1(Object[] objectArray, boolean bl, Project project) {
            this.v$project = project;
            this.v$add = bl;
            this.v$libraries = objectArray;
        }
    }
}

