/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLTempFile;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public final class JavaClassNode
extends JavaNode {
    public static final String EXT = ".class";
    private TextBuffer _decompiledBuffer;

    protected void openImpl() throws IOException {
        this.getTextBufferImpl();
    }

    protected void closeImpl() throws IOException {
        this._decompiledBuffer = null;
    }

    protected void saveImpl() throws IOException {
    }

    protected void revertImpl() throws IOException {
        this.loadTextBufferImpl();
    }

    public InputStream getInputStream() throws IOException {
        TextBuffer textBuffer = this.acquireTextBuffer();
        return TextBufferStreamFactory.getInputStream((TextBuffer)textBuffer);
    }

    protected TextBuffer getTextBufferDirectly() {
        this.ensureOpen();
        return this.getTextBufferImpl();
    }

    void $init$() {
        this._decompiledBuffer = null;
    }

    private TextBuffer getTextBufferImpl() {
        if (this._decompiledBuffer == null) {
            this._decompiledBuffer = TextBufferFactory.createArrayTextBuffer();
            this.loadTextBufferImpl();
        }
        return this._decompiledBuffer;
    }

    private void loadTextBufferImpl() {
        try {
            try {
                String string = this.getDecompiledClass();
                if (string != null) {
                    this._decompiledBuffer.setReadOnly(false);
                    this._decompiledBuffer.remove(0, this._decompiledBuffer.getLength());
                    this._decompiledBuffer.insert(0, string.toCharArray());
                }
            }
            catch (RuntimeException runtimeException) {
                this._decompiledBuffer.remove(0, this._decompiledBuffer.getLength());
            }
        }
        finally {
            this._decompiledBuffer.clearModified();
            this._decompiledBuffer.setReadOnly(true);
        }
    }

    private String getDecompiledClass() {
        Project project;
        String string = System.getProperty("jcncmd");
        if (string != null) {
            try {
                URLTempFile uRLTempFile = new URLTempFile(this.getURL());
                File file = uRLTempFile.getFile();
                Process process = Runtime.getRuntime().exec(string + " " + file.getAbsolutePath());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                1 var7_7 = new 1(this, bufferedReader, stringBuffer);
                var7_7.start();
                int n = process.waitFor();
                var7_7.join();
                if (n == 0) {
                    String string2 = stringBuffer.toString();
                    return string2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        if (project != null) {
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaFile javaFile = javaManager.getFile(this.getURL());
            return JavaClassNode.emitFile(javaFile);
        }
        return null;
    }

    private static String emitFile(JavaFile javaFile) {
        StringBuffer stringBuffer = new StringBuffer(4096);
        JavaClassNode.emitComment(0, "", stringBuffer);
        JavaClassNode.emitComment(0, "Oracle JDeveloper Stub Generated Source", stringBuffer);
        JavaClassNode.emitComment(0, "", stringBuffer);
        JavaClassNode.emitPackage(javaFile.getPackageName(), stringBuffer);
        JavaClass javaClass = javaFile.getPrimaryClass();
        JavaClassNode.emitClass(javaClass, stringBuffer);
        return stringBuffer.toString();
    }

    private static void emitPackage(String string, StringBuffer stringBuffer) {
        if (string != null && string.length() > 0) {
            stringBuffer.append("package ");
            stringBuffer.append(string);
            stringBuffer.append(";");
            JavaClassNode.emitEOL(stringBuffer);
            JavaClassNode.emitEOL(stringBuffer);
        }
    }

    private static void emitClass(JavaClass javaClass, StringBuffer stringBuffer) {
        Collection collection;
        boolean bl;
        Collection collection2;
        boolean bl2;
        Collection collection3;
        Iterator iterator;
        boolean bl3;
        String string;
        boolean bl4;
        String string2 = JavaClassNode.getClassModifiers(javaClass);
        if (string2.length() > 0) {
            stringBuffer.append(string2);
            JavaClassNode.emitSpace(stringBuffer);
        }
        stringBuffer.append((bl4 = javaClass.isInterface()) ? "interface" : "class");
        JavaClassNode.emitSpace(stringBuffer);
        stringBuffer.append(javaClass.getName());
        JavaClassNode.emitEOL(stringBuffer);
        JavaType javaType = javaClass.getSuperclass();
        if (javaType != null && !"java.lang.Object".equals(string = javaType.getQualifiedName())) {
            JavaClassNode.emitIndent(1, stringBuffer);
            stringBuffer.append("extends ");
            stringBuffer.append(string);
            JavaClassNode.emitEOL(stringBuffer);
        }
        if (bl3 = (iterator = (collection3 = javaClass.getInterfaces()).iterator()).hasNext()) {
            JavaClassNode.emitIndent(1, stringBuffer);
            stringBuffer.append(bl4 ? "extends " : "implements ");
        }
        String string3 = "";
        while (iterator.hasNext()) {
            stringBuffer.append(string3);
            string3 = ", ";
            JavaType javaType2 = (JavaType)iterator.next();
            stringBuffer.append(javaType2.getQualifiedName());
        }
        if (bl3) {
            JavaClassNode.emitEOL(stringBuffer);
        }
        stringBuffer.append("{");
        JavaClassNode.emitEOL(stringBuffer);
        Collection collection4 = javaClass.getDeclaredConstructors();
        iterator = collection4.iterator();
        boolean bl5 = iterator.hasNext();
        if (bl5) {
            JavaClassNode.emitComment(1, "", stringBuffer);
            JavaClassNode.emitComment(1, "Constructors", stringBuffer);
            JavaClassNode.emitComment(1, "", stringBuffer);
        }
        boolean bl6 = true;
        while (iterator.hasNext()) {
            if (!bl6) {
                JavaClassNode.emitEOL(stringBuffer);
            }
            bl6 = false;
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(javaMethod, stringBuffer);
        }
        if (bl5) {
            JavaClassNode.emitEOL(stringBuffer);
        }
        if (bl2 = (iterator = (collection2 = javaClass.getDeclaredFields()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", stringBuffer);
            JavaClassNode.emitComment(1, "Fields", stringBuffer);
            JavaClassNode.emitComment(1, "", stringBuffer);
        }
        bl6 = true;
        while (iterator.hasNext()) {
            if (!bl6) {
                JavaClassNode.emitEOL(stringBuffer);
            }
            bl6 = false;
            JavaField javaField = (JavaField)iterator.next();
            JavaClassNode.emitField(javaField, stringBuffer);
        }
        if (bl2) {
            JavaClassNode.emitEOL(stringBuffer);
        }
        if (bl = (iterator = (collection = javaClass.getDeclaredMethods()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", stringBuffer);
            JavaClassNode.emitComment(1, "Methods", stringBuffer);
            JavaClassNode.emitComment(1, "", stringBuffer);
        }
        bl6 = true;
        while (iterator.hasNext()) {
            if (!bl6) {
                JavaClassNode.emitEOL(stringBuffer);
            }
            bl6 = false;
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(javaMethod, stringBuffer);
        }
        stringBuffer.append("}");
        JavaClassNode.emitEOL(stringBuffer);
    }

    private static void emitField(JavaField javaField, StringBuffer stringBuffer) {
        JavaClassNode.emitIndent(1, stringBuffer);
        String string = JavaClassNode.getFieldModifiers(javaField);
        if (string.length() > 0) {
            stringBuffer.append(string);
            JavaClassNode.emitSpace(stringBuffer);
        }
        stringBuffer.append(javaField.getResolvedType().getQualifiedName());
        JavaClassNode.emitSpace(stringBuffer);
        stringBuffer.append(javaField.getName());
        stringBuffer.append(";");
        JavaClassNode.emitEOL(stringBuffer);
    }

    private static void emitMethod(JavaMethod javaMethod, StringBuffer stringBuffer) {
        String string;
        JavaClassNode.emitIndent(1, stringBuffer);
        boolean bl = javaMethod.isConstructor();
        String string2 = string = bl ? JavaClassNode.getConstructorModifiers(javaMethod) : JavaClassNode.getMethodModifiers(javaMethod);
        if (string.length() > 0) {
            stringBuffer.append(string);
            JavaClassNode.emitSpace(stringBuffer);
        }
        if (bl) {
            JavaClass javaClass = javaMethod.getOwningClass();
            stringBuffer.append(javaClass.getName());
        } else {
            JavaType javaType = javaMethod.getReturnType();
            if (javaType != null) {
                stringBuffer.append(javaType.getQualifiedName());
                JavaClassNode.emitSpace(stringBuffer);
            }
            stringBuffer.append(javaMethod.getName());
        }
        JavaClassNode.emitMethodParameters(javaMethod, stringBuffer);
        JavaClassNode.emitSpace(stringBuffer);
        stringBuffer.append("{ }");
        JavaClassNode.emitEOL(stringBuffer);
    }

    private static void emitMethodParameters(JavaMethod javaMethod, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        Collection collection = javaMethod.getParameters();
        if (collection != null) {
            String string = "";
            int n = 1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string);
                string = ", ";
                JavaVariable javaVariable = (JavaVariable)iterator.next();
                JavaType javaType = javaVariable.getResolvedType();
                stringBuffer.append(javaType.getQualifiedName());
                JavaClassNode.emitSpace(stringBuffer);
                String string2 = javaVariable.getName();
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append("p" + n++);
            }
        }
        stringBuffer.append(")");
    }

    private static String getFieldModifiers(JavaField javaField) {
        int n = javaField.getModifiers();
        return Modifier.toString(n);
    }

    private static String getMethodModifiers(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        boolean bl = javaClass.isInterface();
        int n = javaMethod.getModifiers();
        if (bl) {
            n &= 0xFFFFFBFE;
        }
        return Modifier.toString(n);
    }

    private static String getConstructorModifiers(JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = javaMethod.getModifiers();
        if (Modifier.isPublic(n)) {
            stringBuffer.append("public ");
        }
        if (Modifier.isPrivate(n)) {
            stringBuffer.append("private ");
        }
        if (Modifier.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (Modifier.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isFinal(n)) {
            stringBuffer.append("final ");
        }
        return stringBuffer.toString().trim();
    }

    private static String getClassModifiers(JavaClass javaClass) {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = javaClass.getModifiers();
        boolean bl = javaClass.isInterface();
        if (Modifier.isPublic(n)) {
            stringBuffer.append("public ");
        }
        if (Modifier.isPrivate(n)) {
            stringBuffer.append("private ");
        }
        if (Modifier.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (!bl && Modifier.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isStatic(n)) {
            stringBuffer.append("static ");
        }
        if (Modifier.isFinal(n)) {
            stringBuffer.append("final ");
        }
        if (Modifier.isNative(n)) {
            stringBuffer.append("native ");
        }
        return stringBuffer.toString().trim();
    }

    private static void emitEOL(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
    }

    private static void emitSpace(StringBuffer stringBuffer) {
        stringBuffer.append(" ");
    }

    private static void emitIndent(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
    }

    private static void emitComment(int n, String string, StringBuffer stringBuffer) {
        JavaClassNode.emitIndent(n, stringBuffer);
        stringBuffer.append("// ");
        if (string != null) {
            stringBuffer.append(string);
        }
        JavaClassNode.emitEOL(stringBuffer);
    }

    public JavaClassNode() {
        this.$init$();
    }

    public final class 1
    extends Thread {
        private final /* synthetic */ BufferedReader v$br;
        private final /* synthetic */ StringBuffer v$buf;
        final /* synthetic */ JavaClassNode this$0;

        public void run() {
            try {
                String string;
                while ((string = this.v$br.readLine()) != null) {
                    this.v$buf.append(string).append("\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public 1(JavaClassNode javaClassNode, BufferedReader bufferedReader, StringBuffer stringBuffer) {
            this.v$buf = stringBuffer;
            this.v$br = bufferedReader;
            this.this$0 = javaClassNode;
        }
    }
}

