/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.ContentSetPanel;
import oracle.jdeveloper.model.ContentSetValidator;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.SourceRootHelper;
import oracle.jdeveloper.resource.ModelArb;

public class JavaContentValidator
implements ContentSetValidator {
    private ProgressBar _progressBar;
    private ContentSetPanel _projectContentPanel;
    private static final List SOURCE_ROOT_HELPERS = new ArrayList(5);

    void setProgressBar(ProgressBar progressBar) {
        this._progressBar = progressBar;
    }

    public static void registerSourceRootHelper(SourceRootHelper sourceRootHelper) {
        if (sourceRootHelper != null && !SOURCE_ROOT_HELPERS.contains(sourceRootHelper)) {
            SOURCE_ROOT_HELPERS.add(sourceRootHelper);
        }
    }

    public static void unRegisterSourceRootHelper(SourceRootHelper sourceRootHelper) {
        if (sourceRootHelper != null && SOURCE_ROOT_HELPERS.contains(sourceRootHelper)) {
            SOURCE_ROOT_HELPERS.remove(sourceRootHelper);
        }
    }

    static SourceRootHelper[] getRegisteredSourceRootHelpers() {
        SourceRootHelper[] sourceRootHelperArray = new SourceRootHelper[SOURCE_ROOT_HELPERS.size()];
        SOURCE_ROOT_HELPERS.toArray(sourceRootHelperArray);
        return sourceRootHelperArray;
    }

    public void validateAndProcessURLs(ContentSetPanel contentSetPanel, URL[] uRLArray) {
        this._projectContentPanel = contentSetPanel;
        HashMap hashMap = this.processURLs(uRLArray);
        if (this._progressBar != null && this._progressBar.hasUserCancelled()) {
            JProjectUtil.notifyCanceled();
            return;
        }
        if (hashMap.keySet().size() == 0) {
            String string = ModelArb.getString(122);
            String string2 = ModelArb.getString(123);
            if (MessageDialog.confirm((Component)this.getParentComponent(), (Object)string2, (String)string, null)) {
                int n = 0;
                while (n < uRLArray.length) {
                    URL uRL = uRLArray[n];
                    this._projectContentPanel.addFolderToContentSet(uRL);
                    ++n;
                }
            }
            return;
        }
        if (this.userConfirmed(hashMap)) {
            for (URL uRL : hashMap.keySet()) {
                List list = (List)hashMap.get(uRL);
                for (URL uRL2 : list) {
                    if (uRL.toString().length() < uRL2.toString().length()) {
                        this._projectContentPanel.addFolderToContentSet(uRL2);
                        continue;
                    }
                    this._projectContentPanel.addFolderToContentSet(uRL, uRL2);
                }
            }
        }
    }

    private boolean userConfirmed(Map map) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        for (URL uRL : map.keySet()) {
            List list = (List)map.get(uRL);
            for (URL uRL2 : list) {
                if (uRL.toString().length() < uRL2.toString().length()) {
                    arrayList.add(uRL2);
                    continue;
                }
                arrayList2.add(uRL);
            }
        }
        boolean bl = false;
        int n = arrayList.size();
        if (n > 0) {
            arrayList.addAll(0, arrayList2);
            String string = this.buildMessageFromUrlList(arrayList);
            int n2 = n + arrayList2.size();
            Object object = n2 == 1 ? ModelArb.format(118, string) : (n <= 5 ? ModelArb.format(119, string) : new ConfirmPanel(string));
            String string2 = ModelArb.getString(117);
            bl = MessageDialog.confirm((Component)this.getParentComponent(), (Object)object, (String)string2, null);
        }
        return bl || n == 0;
    }

    private String buildMessageFromUrlList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (URL uRL : list) {
            stringBuffer.append(URLFileSystem.getPlatformPathName((URL)uRL));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private Component getParentComponent() {
        if (this._projectContentPanel != null) {
            return this._projectContentPanel;
        }
        return Ide.getMainWindow();
    }

    private void updateProgressBar(String string) {
        if (this._progressBar != null && !this._progressBar.hasUserCancelled()) {
            this._progressBar.updateProgress(null, string);
        }
    }

    private boolean panelHasURL(URL uRL) {
        if (this._projectContentPanel != null) {
            return this._projectContentPanel.contentSetContainsURL(uRL);
        }
        return false;
    }

    private HashMap processURLs(URL[] uRLArray) {
        HashMap hashMap = new HashMap();
        1FindSrcRootProcess findSrcRootProcess = new 1FindSrcRootProcess(this, this.getParentComponent(), uRLArray, hashMap);
        String string = findSrcRootProcess.start();
        return hashMap;
    }

    HashMap processURLsAndConfirm(URL[] uRLArray) {
        HashMap hashMap = this.processURLs(uRLArray);
        if (this.userConfirmed(hashMap)) {
            return hashMap;
        }
        hashMap.clear();
        return hashMap;
    }

    static void mav$updateProgressBar(JavaContentValidator javaContentValidator, String string) {
        javaContentValidator.updateProgressBar(string);
    }

    static boolean mav$panelHasURL(JavaContentValidator javaContentValidator, URL uRL) {
        return javaContentValidator.panelHasURL(uRL);
    }

    static ProgressBar ra$_progressBar(JavaContentValidator javaContentValidator) {
        return javaContentValidator._progressBar;
    }

    static void wa$_progressBar(JavaContentValidator javaContentValidator, ProgressBar progressBar) {
        javaContentValidator._progressBar = progressBar;
    }

    public class 1FindSrcRootProcess
    implements Runnable {
        private final /* synthetic */ URL[] v$urls;
        private final /* synthetic */ HashMap v$map;
        final /* synthetic */ JavaContentValidator this$0;

        public 1FindSrcRootProcess(JavaContentValidator javaContentValidator, Component component, URL[] uRLArray, HashMap hashMap) {
            this.v$map = hashMap;
            this.v$urls = uRLArray;
            this.this$0 = javaContentValidator;
            String string = ModelArb.getString(125);
            if (JavaContentValidator.ra$_progressBar(javaContentValidator) == null) {
                JavaContentValidator.wa$_progressBar(javaContentValidator, new ProgressBar(component, string, (Runnable)this, true));
            } else {
                JavaContentValidator.ra$_progressBar(javaContentValidator).setRunnable((Runnable)this);
            }
        }

        public String start() {
            String string = ModelArb.getString(126);
            JavaContentValidator.ra$_progressBar(this.this$0).start(string, "");
            return "Process completed";
        }

        public void run() {
            int n = 0;
            while (n < this.v$urls.length) {
                URL uRL = this.v$urls[n];
                JavaContentValidator.mav$updateProgressBar(this.this$0, URLFileSystem.getPlatformPathName((URL)uRL));
                if (JavaContentValidator.mav$panelHasURL(this.this$0, uRL)) {
                    ArrayList<URL> arrayList = new ArrayList<URL>(1);
                    arrayList.add(uRL);
                    this.v$map.put(uRL, arrayList);
                } else {
                    URL[] uRLArray = new URL[]{uRL};
                    URL[] uRLArray2 = JProjectUtil.getSourceRoots(uRLArray, JavaContentValidator.getRegisteredSourceRootHelpers());
                    if (uRLArray2.length > 0) {
                        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray2));
                        this.v$map.put(uRL, arrayList);
                    }
                }
                ++n;
            }
            JavaContentValidator.ra$_progressBar(this.this$0).setDoneStatus();
        }
    }

    private class ConfirmPanel
    extends JPanel {
        final JList rootList;
        final JScrollPane scroller;
        final JLabel intro;
        final JLabel confirm;

        void $init$() {
            this.rootList = new JList();
            this.scroller = new JScrollPane(this.rootList);
            this.intro = new JLabel(ModelArb.getString(120));
            this.confirm = new JLabel(ModelArb.getString(121));
        }

        ConfirmPanel(String string) {
            super(new BorderLayout(0, 10));
            this.$init$();
            this.rootList.setListData(string.split("\n"));
            this.add((Component)this.intro, "North");
            this.add((Component)this.scroller, "Center");
            this.add((Component)this.confirm, "South");
        }
    }
}

