/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CopyOnWriteList;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaProjectListener;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.jar.JarNode;

public final class JavaProject
extends HashStructureAdapter {
    public static final String EXT = ".jpr";
    public static final String SOURCEPATH_PROPERTY = "sourcePath";
    public static final String CLASSPATH_PROPERTY = "classPath";
    public static final String PROJECT_SOURCEPATH_PROPERTY = "projectSourcePath";
    public static final String DOCPATH_PROPERTY = "docPath";
    private static final int SRC_PATH_EXIST = 0;
    private static final int SRC_PATH_ADD = 1;
    private static final int SRC_PATH_CANCEL_ADD = 2;
    private static ProjectChangeListener _sourcepathListener;
    private static ProjectChangeListener _projectSourcepathListener;
    private static ProjectChangeListener _classpathListener;
    private static ProjectChangeListener _docpathListener;
    private static ProjectChangeListener _exportedRefListener;
    private static final CopyOnWriteList _javaProjectListeners;
    private final Project _project;
    private final HashStructure _user;
    public static final String OUTPUT_DIRECTORY_LOCAL_KEY = "outputDirectory";
    public static final String OUTPUT_DIRECTORY;
    public static final String DEFAULT_PACKAGE = "defaultPackage";
    private static final String MOST_RECENT_PACKAGE = "mostRecentPackage";
    private static final String RECENT_PACKAGES = "recentlyUsedPackages";

    static {
        _javaProjectListeners = new CopyOnWriteList();
        OUTPUT_DIRECTORY = JProjectPaths.DATA_KEY + "/" + OUTPUT_DIRECTORY_LOCAL_KEY;
    }

    private JavaProject(Project project, HashStructure hashStructure) {
        super(hashStructure);
        this._project = project;
        this._user = project.getUserPropertiesOnly();
    }

    public static JavaProject getInstance(Project project) {
        return new JavaProject(project, project.getProperties());
    }

    public static JavaProject getInstance(Project project, HashStructure hashStructure) {
        return new JavaProject(project, hashStructure);
    }

    static void addJavaProjectListener(JavaProjectListener javaProjectListener) {
        _javaProjectListeners.addIfAbsent((Object)javaProjectListener);
    }

    static void removeJavaProjectListener(JavaProjectListener javaProjectListener) {
        _javaProjectListeners.remove((Object)javaProjectListener);
    }

    public URL getOutputDirectory() {
        URL uRL;
        URL uRL2 = this._hash.getURL(OUTPUT_DIRECTORY);
        if (uRL2 == null && (uRL = URLFileSystem.getParent((URL)this._project.getURL())) != null) {
            uRL2 = URLFactory.newDirURL((URL)uRL, (String)"classes");
        }
        return uRL2;
    }

    public void setOutputDirectory(URL uRL) {
        this._hash.putURL(OUTPUT_DIRECTORY, uRL);
    }

    public String getDefaultPackage() {
        String string = this._hash.getString(DEFAULT_PACKAGE);
        if (string == null) {
            string = JavaProject.generateDefaultPackageName(this._project);
        }
        return string;
    }

    public static String generateDefaultPackageName(Project project) {
        if (project == null) {
            return ModelArb.getString((int)4);
        }
        return JavaProject.generateDefaultPackageName(project.getShortLabel());
    }

    public static String generateDefaultPackageName(String string) {
        String string2;
        String string3 = string.toLowerCase();
        int n = string3.length();
        int n2 = EXT.length();
        String string4 = string3.endsWith(EXT) && n > n2 ? string3.substring(0, n - EXT.length()) : string3;
        if (IdeUtil.isPackageIdentifier((String)string4)) {
            string2 = string4;
        } else {
            StringBuffer stringBuffer = new StringBuffer(string4.length());
            char[] cArray = string4.toCharArray();
            int n3 = cArray.length - 1;
            int n4 = 0;
            while (n4 <= n3) {
                int n5 = stringBuffer.length();
                if (n5 == 15) break;
                if (n5 == 0 && Character.isJavaIdentifierStart(cArray[n4]) || n5 > 0 && Character.isJavaIdentifierPart(cArray[n4])) {
                    stringBuffer.append(cArray[n4]);
                } else if (n5 == 0 && n4 == n3) {
                    stringBuffer.append(ModelArb.getString((int)5));
                    n4 = -1;
                }
                ++n4;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    void setDefaultPackage(String string) {
        this._hash.putString(DEFAULT_PACKAGE, string);
        this.setMostRecentPackage(string);
    }

    public String getMostRecentPackage() {
        String string = this._user.getString(MOST_RECENT_PACKAGE);
        if (string == null) {
            string = this.getDefaultPackage();
            this.setMostRecentPackage(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMostRecentPackage(String string) {
        ListStructure listStructure;
        this._user.putString(MOST_RECENT_PACKAGE, string);
        ListStructure listStructure2 = listStructure = this.getRecentPackages();
        synchronized (listStructure2) {
            int n = listStructure.indexOf((Object)string);
            if (n == -1) {
                listStructure.add(0, (Object)string);
            } else if (n > 0) {
                listStructure.remove(n);
                listStructure.add(0, (Object)string);
            }
        }
    }

    public ListStructure getRecentPackages() {
        return this.getOrCreateRecentPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentPackages(List list) {
        ListStructure listStructure;
        ListStructure listStructure2 = listStructure = this.getOrCreateRecentPackages();
        synchronized (listStructure2) {
            listStructure.mirror(list);
        }
    }

    private ListStructure getOrCreateRecentPackages() {
        HashStructure hashStructure = this._project.getSharedPropertiesOnly();
        boolean bl = !this._user.containsKey(RECENT_PACKAGES) && hashStructure.containsKey(RECENT_PACKAGES);
        ListStructure listStructure = this._user.getOrCreateListStructure(RECENT_PACKAGES);
        if (bl) {
            try {
                ListStructure listStructure2 = hashStructure.getListStructure(RECENT_PACKAGES);
                listStructure2.copyTo(listStructure);
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
        }
        return listStructure;
    }

    public void addToProjectSourcePath(JavaSourceNode javaSourceNode) {
        boolean[] blArray = new boolean[]{true};
        this.addToProjectSourcePath(javaSourceNode, blArray);
    }

    public void addToProject(Collection collection, boolean bl) {
        if (collection.size() > 0) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean[] blArray = new boolean[]{bl};
            boolean[] blArray2 = new boolean[]{bl};
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!this._project.canAdd(element)) {
                    iterator.remove();
                    continue;
                }
                if (!(element instanceof Locatable)) continue;
                Locatable locatable = (Locatable)element;
                if (bl2 && locatable instanceof JavaSourceNode) {
                    switch (this.addToProjectSourcePath((JavaSourceNode)locatable, blArray)) {
                        case 2: {
                            bl2 = false;
                        }
                    }
                    continue;
                }
                if ((!bl3 || !(locatable instanceof JarNode)) && !(locatable instanceof JavaClassNode)) continue;
                switch (this.addToAdditionalClassPath(locatable.getURL(), blArray2)) {
                    case 2: {
                        bl3 = false;
                    }
                }
            }
        }
    }

    private int addToAdditionalClassPath(URL uRL, boolean[] blArray) {
        JProjectPaths jProjectPaths = JProjectPaths.getInstance((PropertyStorage)this._project);
        URLPath uRLPath = jProjectPaths.getAdditionalClassPath();
        if (uRLPath.contains(uRL = this.validateJarURL(uRL))) {
            return 0;
        }
        if (blArray[0]) {
            blArray[0] = false;
            String string = JProjectArb.getString(178);
            if (JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, JProjectArb.getString(179), 0) == 1) {
                return 2;
            }
        }
        uRLPath.add(uRL);
        jProjectPaths.setAdditionalClassPath(uRLPath);
        return 1;
    }

    private URL validateJarURL(URL uRL) {
        if (JarUtil.isArchive((String)uRL.getPath())) {
            return URLFactory.newJarURL((URL)uRL, (String)"");
        }
        return uRL;
    }

    private int addToProjectSourcePath(JavaSourceNode javaSourceNode, boolean[] blArray) {
        URL uRL;
        URLPath uRLPath = PathsConfiguration.getInstance(this._project).getProjectSourcePath();
        if (uRLPath.toRelativePath(uRL = javaSourceNode.getURL()) != null) {
            return 0;
        }
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        String string = javaSourceNode.getPackage(this._project);
        if (ModelUtil.hasLength((String)string)) {
            string = string.replace('.', '/');
            string = string.concat("/");
            File file = new File(string);
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                File file2;
                URL uRL3 = uRLArray[n];
                String string2 = URLFileSystem.toRelativeSpec((URL)javaSourceNode.getURL(), (URL)uRL3, (boolean)true);
                if (ModelUtil.hasLength((String)string2) && (file2 = new File(string2).getParentFile()) != null && file.compareTo(file2) == 0) {
                    return 0;
                }
                ++n;
            }
        } else if (uRLPath.contains(uRL2)) {
            return 0;
        }
        if (blArray[0]) {
            blArray[0] = false;
            String string3 = JProjectArb.getString(107);
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string3, JProjectArb.getString(108), 0);
            if (n == 1 || n == -1) {
                return 2;
            }
        }
        URL uRL4 = JProjectUtil.determineSourceRoot(javaSourceNode, true, new boolean[]{false});
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(this._project);
        URLPath uRLPath2 = pathsConfiguration.getProjectSourcePath();
        uRLPath2.add(uRL4);
        pathsConfiguration.setProjectSourcePath(uRLPath2);
        return 1;
    }

    static void init() {
        JavaProject.initSourcepathListener();
        JavaProject.initProjectSourcepathListener();
        JavaProject.initClasspathListener();
        JavaProject.initDocpathListener();
        JavaProject.initExportedRefListener();
    }

    private static void initSourcepathListener() {
        if (_sourcepathListener == null) {
            _sourcepathListener = new 5();
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_sourcepathListener);
            JavaProject.registerJDKLibrariesDependencies(_sourcepathListener);
        }
    }

    private static void initProjectSourcepathListener() {
        if (_projectSourcepathListener == null) {
            _projectSourcepathListener = new 4();
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_projectSourcepathListener);
        }
    }

    private static void initClasspathListener() {
        if (_classpathListener == null) {
            _classpathListener = new 3();
            Project.addProjectChangeListener((String)OUTPUT_DIRECTORY, (ProjectChangeListener)_classpathListener);
            Project.addProjectChangeListener((String)(JProjectPaths.DATA_KEY + "/" + "additionalClassPath"), (ProjectChangeListener)_classpathListener);
            JavaProject.registerJDKLibrariesDependencies(_classpathListener);
        }
    }

    private static void initDocpathListener() {
        if (_docpathListener == null) {
            _docpathListener = new 2();
            JavaProject.registerJDKLibrariesDependencies(_docpathListener);
        }
    }

    private static void initExportedRefListener() {
        if (_exportedRefListener == null) {
            _exportedRefListener = new 1();
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/exportedReferences", (ProjectChangeListener)_exportedRefListener);
        }
    }

    private static void registerJDKLibrariesDependencies(ProjectChangeListener projectChangeListener) {
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/jdkReference", (ProjectChangeListener)projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions", (ProjectChangeListener)projectChangeListener);
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/" + "dependencyList"), (ProjectChangeListener)projectChangeListener);
    }

    private static abstract class CachingProjectChangeListener
    extends ProjectChangeListener {
        private static int _debugLevel = Integer.getInteger("ProjectChangeListener.debug.level", 0);

        protected abstract Object getValue(Project var1);

        protected abstract String getUpdateMessageName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectOpened(Project project) {
            Object object = this.getValue(project);
            Map map = project.getTransientProperties();
            String string = this.getUpdateMessageName();
            Map map2 = map;
            synchronized (map2) {
                map.put(string, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            Project project = projectChangeEvent.getProject();
            Map map = project.getTransientProperties();
            String string = this.getUpdateMessageName();
            Object object = this.getValue(project);
            Map map2 = map;
            synchronized (map2) {
                Object v = map.get(string);
                if (ModelUtil.areDifferent(v, (Object)object)) {
                    map.put(string, object);
                    String string2 = this.getUpdateMessageName();
                    if (_debugLevel > 0) {
                        System.out.println(">>>>> Updated " + string2);
                    }
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(project, string2, v, object);
                    PropertyChangeEvent[] propertyChangeEventArray = new PropertyChangeEvent[]{propertyChangeEvent};
                    this.fireEvents(project, propertyChangeEventArray, (Object)this);
                }
            }
        }

        void fireEvents(Project project, PropertyChangeEvent[] propertyChangeEventArray, Object object) {
            UpdateMessage.firePropertiesChanged((Subject)project, (PropertyChangeEvent[])propertyChangeEventArray, (Object)object);
        }

        private CachingProjectChangeListener() {
        }

        CachingProjectChangeListener(5 var1_1) {
            this();
        }

        CachingProjectChangeListener(4 var1_1) {
            this();
        }

        CachingProjectChangeListener(3 var1_1) {
            this();
        }

        CachingProjectChangeListener(2 var1_1) {
            this();
        }
    }

    public static final class 5
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getSourcePath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.SOURCEPATH_PROPERTY;
        }

        public 5() {
            super((5)null);
        }
    }

    public static final class 4
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getProjectSourcePath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.PROJECT_SOURCEPATH_PROPERTY;
        }

        public 4() {
            super((4)null);
        }
    }

    public static final class 3
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getClassPath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.CLASSPATH_PROPERTY;
        }

        public 3() {
            super((3)null);
        }
    }

    public static final class 2
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getDocPath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.DOCPATH_PROPERTY;
        }

        public 2() {
            super((2)null);
        }
    }

    public static final class 1
    extends ProjectChangeListener {
        protected Object getValue(Project project) {
            return JProjectLibraries.getInstance((PropertyStorage)project).getExports();
        }

        protected String getUpdateMessageName() {
            return "exportedReferences";
        }
    }
}

