/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.library.LibraryArb;

public class LibraryModel {
    protected Component panel;
    protected Library lib;
    protected String name;
    protected MutableLibraryList list;
    protected URLPath clsPath;
    protected URLPath srcPath;
    protected URLPath docPath;

    public LibraryModel(Library library, MutableLibraryList mutableLibraryList, Component component) {
        this.lib = library;
        this.list = mutableLibraryList;
        this.panel = component;
    }

    public void setName(String string) {
        this.name = string != null ? string.trim() : "";
    }

    public void setClassPath(URLPath uRLPath) {
        this.clsPath = uRLPath;
    }

    public void setSourcePath(URLPath uRLPath) {
        this.srcPath = uRLPath;
    }

    public void setDocPath(URLPath uRLPath) {
        this.docPath = uRLPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Library commit() throws Exception {
        URLPath uRLPath;
        if (this.lib == null) {
            return this.lib;
        }
        boolean bl = this.lib instanceof JDK;
        String string = this.lib.getName();
        if (!ModelUtil.hasLength((String)this.name)) {
            this.showError(ControlsArb.getString(57), ControlsArb.getString(71));
            throw new Exception();
        }
        if (!ModelUtil.areEqual((Object)string, (Object)this.name)) {
            Object object = this.list.createIDFromName(this.name, bl);
            if (object != null) {
                if (string != null && string.trim().length() > 0) {
                    String string2 = LibraryArb.format(75, new String[]{LibraryArb.getString(bl ? 73 : 71)});
                    String string3 = LibraryArb.format(76, new String[]{LibraryArb.getString(bl ? 73 : 71)});
                    if (!MessageDialog.confirm((Component)this.panel, (Object)string2, (String)string3, null, (boolean)true)) {
                        throw new Exception();
                    }
                }
                Library library = null;
                library = bl ? this.list.findJDK(object) : this.list.findLibrary(object);
                if (library != null) {
                    String string4 = ComponentArb.format((int)30, (Object[])new String[]{LibraryArb.getString(bl ? 73 : 71), this.name});
                    if (!MessageDialog.confirm((Component)this.panel, (Object)string4, (String)ComponentArb.getString((int)25), null, (boolean)true)) throw new Exception();
                    if (this.list.isTransient() || library.isLocked()) {
                        this.showError(ComponentArb.format((int)29, (Object[])new String[]{this.name}), ComponentArb.getString((int)35));
                        throw new Exception();
                    }
                }
            } else {
                this.showError(ControlsArb.getString(57), ControlsArb.getString(71));
                throw new Exception();
            }
            Library library = null;
            this.list.remove(this.lib);
            library = bl ? this.list.addJDK(this.name, ((JDK)this.lib).getJavaExecutable()) : this.list.addLibrary(this.name);
            if (library != null) {
                library.initFromLibrary(this.lib);
            }
            this.lib = library;
        }
        if (!ModelUtil.areEqual((Object)this.clsPath, (Object)(uRLPath = this.lib.getClassPath()))) {
            this.lib.setClassPath(this.clsPath);
        }
        if (!ModelUtil.areEqual((Object)this.srcPath, (Object)(uRLPath = this.lib.getSourcePath()))) {
            this.lib.setSourcePath(this.srcPath);
        }
        if (ModelUtil.areEqual((Object)this.docPath, (Object)(uRLPath = this.lib.getDocPath()))) return this.lib;
        this.lib.setDocPath(this.docPath);
        return this.lib;
    }

    protected void showError(String string, String string2) {
        MessageDialog.error((Component)this.panel, (Object)string, (String)string2, null);
    }
}

