/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.resource.TechArb;

public final class TechnologiesPanel
extends ProjectSettingsTraversablePanel {
    public static final String TECHNOLOGY_SCOPE_DATA_KEY = "technologyScope";
    private static final String HELP_ID = "f1_idedprojsettechnologyscopedpp_html";
    private final DefaultListModel _fromModel;
    private final DefaultListModel _toModel;
    private final GridBagLayout _layout;
    private final JLabel _fromLabel;
    private final JList _fromList;
    private final JLabel _toLabel;
    private final JList _toList;
    private final Shuttle _technologiesShuttle;
    private final JLabel _descriptionLabel;
    private final DescriptionScrollPane _descriptionScrollPane;
    private final ListPicker _fromPicker;
    private final ListPicker _toPicker;
    private TechnologyScope _scope;
    private static final String[] PROPERTY_KEYS = new String[]{"technologyScope"};

    void $init$() {
        this._fromModel = new DefaultListModel();
        this._toModel = new DefaultListModel();
        this._layout = new GridBagLayout();
        this._fromLabel = new JLabel();
        this._fromList = new JList();
        this._toLabel = new JLabel();
        this._toList = new JList();
        this._technologiesShuttle = new Shuttle();
        this._descriptionLabel = new JLabel();
        this._descriptionScrollPane = new DescriptionScrollPane();
        this._fromPicker = new ListPicker(this._fromList);
        this._toPicker = new ListPicker(this._toList);
    }

    public TechnologiesPanel() {
        this.$init$();
        this.setHelpID(HELP_ID);
        EventAdapter eventAdapter = new EventAdapter(null);
        this._fromList.addFocusListener(eventAdapter);
        this._fromList.addListSelectionListener(eventAdapter);
        this._toList.addFocusListener(eventAdapter);
        this._toList.addListSelectionListener(eventAdapter);
        this._technologiesShuttle.addShuttleListener((ShuttleListener)eventAdapter);
        this._fromList.setModel(this._fromModel);
        this._fromList.setSelectionMode(2);
        this._fromPicker.setItemsSorted(true);
        this._toList.setModel(this._toModel);
        this._toList.setSelectionMode(2);
        this._toPicker.setItemsSorted(true);
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromList, (String)TechArb.getString(1));
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toList, (String)TechArb.getString(2));
        ResourceUtils.resLabel((JLabel)this._descriptionLabel, (Component)this._descriptionScrollPane.getLabelComponent(), (String)TechArb.getString(3));
        Border border = BorderFactory.createEmptyBorder(0, 0, 2, 0);
        this._fromLabel.setBorder(border);
        this._toLabel.setBorder(border);
        this._technologiesShuttle.add((Component)this._fromLabel, (Object)"FromHeader");
        this._technologiesShuttle.setFromPicker((ItemPicker)this._fromPicker);
        this._technologiesShuttle.add((Component)this._toLabel, (Object)"ToHeader");
        this._technologiesShuttle.setToPicker((ItemPicker)this._toPicker);
        this.setLayout(this._layout);
        this.add((Component)this._technologiesShuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this._descriptionScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        TechnologyScope technologyScope = this.getTechnologyScopeFromContext(traversableContext);
        this._scope = new TechnologyScope(technologyScope);
        this.populateModels(this._scope);
    }

    public void onExit(TraversableContext traversableContext) {
        TechId[] techIdArray = this._scope.toArray();
        boolean bl = false;
        int n = 0;
        while (n < techIdArray.length) {
            TechId techId = techIdArray[n];
            if (techId.isVisible()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this._scope.clear();
        }
        this.putTechnologyScopeToContext(traversableContext, this._scope);
    }

    public String getDataKey() {
        return TechnologyScopeConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    private TechnologyScope getTechnologyScopeFromContext(TraversableContext traversableContext) {
        PropertyStorage propertyStorage;
        TechnologyScope technologyScope = (TechnologyScope)traversableContext.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY);
        if (technologyScope != null) {
            return technologyScope;
        }
        Object object = propertyStorage = traversableContext.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)traversableContext) : (Project)traversableContext.find("Project");
        if (propertyStorage != null) {
            TechnologyScopeConfiguration technologyScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyStorage);
            return technologyScopeConfiguration.getTechnologyScope();
        }
        return null;
    }

    private void putTechnologyScopeToContext(TraversableContext traversableContext, TechnologyScope technologyScope) {
        if (traversableContext.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY) != null) {
            traversableContext.putDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY, (Object)technologyScope);
            return;
        }
        PropertyStorage propertyStorage = TechnologiesPanel.getPropertyData((Namespace)traversableContext);
        TechnologyScopeConfiguration technologyScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyStorage);
        technologyScopeConfiguration.setTechnologyScope(technologyScope);
    }

    private void populateModels(TechnologyScope technologyScope) {
        TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
        Object[] objectArray = technologyRegistry.getVisibleTechIds();
        Arrays.sort(objectArray);
        this._fromModel.clear();
        this._fromModel.ensureCapacity(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this._fromModel.addElement(object);
            ++n;
        }
        Object[] objectArray2 = technologyScope.toArray();
        Arrays.sort(objectArray2);
        this._toModel.clear();
        this._toModel.ensureCapacity(objectArray2.length);
        int n2 = 0;
        while (n2 < objectArray2.length) {
            Object object = objectArray2[n2];
            if (object.isVisible() && this._fromModel.contains(object)) {
                this._fromModel.removeElement(object);
                this._toModel.addElement(object);
            }
            ++n2;
        }
        this._fromList.ensureIndexIsVisible(0);
        this._toList.ensureIndexIsVisible(0);
    }

    static DescriptionScrollPane ra$_descriptionScrollPane(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._descriptionScrollPane;
    }

    static TechnologyScope ra$_scope(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._scope;
    }

    static void mav$populateModels(TechnologiesPanel technologiesPanel, TechnologyScope technologyScope) {
        technologiesPanel.populateModels(technologyScope);
    }

    private final class EventAdapter
    implements ShuttleListener,
    ListSelectionListener,
    FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            this.updateDescription((JList)focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateDescription((JList)listSelectionEvent.getSource());
        }

        public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
            Transferable[] transferableArray = shuttleEvent.getItems();
            int n = 0;
            while (n < transferableArray.length) {
                TechId techId = this.extractTechId(transferableArray[n]);
                if (techId != null) {
                    TechnologiesPanel.ra$_scope(TechnologiesPanel.this).add(techId);
                }
                ++n;
            }
            TechnologiesPanel.mav$populateModels(TechnologiesPanel.this, TechnologiesPanel.ra$_scope(TechnologiesPanel.this));
        }

        public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
            Transferable[] transferableArray = shuttleEvent.getItems();
            int n = 0;
            while (n < transferableArray.length) {
                TechId techId = this.extractTechId(transferableArray[n]);
                if (techId != null) {
                    TechnologiesPanel.ra$_scope(TechnologiesPanel.this).remove(techId);
                }
                ++n;
            }
            TechnologiesPanel.mav$populateModels(TechnologiesPanel.this, TechnologiesPanel.ra$_scope(TechnologiesPanel.this));
        }

        public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
        }

        private void updateDescription(JList jList) {
            TechId techId = (TechId)jList.getSelectedValue();
            if (techId != null) {
                TechnologiesPanel.ra$_descriptionScrollPane(TechnologiesPanel.this).setText(techId.getDescription());
            } else {
                TechnologiesPanel.ra$_descriptionScrollPane(TechnologiesPanel.this).setText(null);
            }
        }

        private TechId extractTechId(Transferable transferable) {
            if (transferable instanceof ObjectTransferable) {
                ObjectTransferable objectTransferable = (ObjectTransferable)transferable;
                DataFlavor dataFlavor = TransferUtils.getDataFlavor(TechId.class);
                try {
                    TechId techId = (TechId)objectTransferable.getTransferData(dataFlavor);
                    return techId;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

