/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.jdeveloper.palette.IncrementFieldListener;

public final class IncrementalField
extends JPanel
implements ActionListener {
    private final JTextField _numberFld;
    private final GridBagLayout gridBagLayout1;
    private final ArrayList _listeners;
    private JButton _increaseBtn;
    private JButton _decreaseBtn;
    private int _index;

    void $init$() {
        this._numberFld = new JTextField();
        this.gridBagLayout1 = new GridBagLayout();
        this._listeners = new ArrayList();
        this._increaseBtn = new JButton(".");
        this._decreaseBtn = new JButton(".");
        this._index = 1;
    }

    public IncrementalField(int n) {
        this.$init$();
        this._index = n;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._increaseBtn = this.decorate(this._increaseBtn);
        this._decreaseBtn = this.decorate(this._decreaseBtn);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this._decreaseBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), -2, -12));
        this.add((Component)this._increaseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), -2, -12));
        this.add((Component)this._numberFld, new GridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._numberFld.setText("" + this._index);
        this._increaseBtn.addActionListener(this);
        this._decreaseBtn.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getValue().length() == 0) {
            this._numberFld.setText("" + this._index);
        }
        if (actionEvent.getSource() == this._increaseBtn) {
            int n = Integer.valueOf(this.getValue());
            this._numberFld.setText("" + ++n);
        } else {
            int n = Integer.valueOf(this.getValue());
            if (--n < 0) {
                n = 0;
            }
            this._numberFld.setText("" + n);
        }
        for (IncrementFieldListener incrementFieldListener : this._listeners) {
            incrementFieldListener.valueChanged(Integer.valueOf(this.getValue()));
        }
    }

    public String getValue() {
        String string = this._numberFld.getText().trim();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isDigit(c)) {
                return "1";
            }
            ++n;
        }
        return this._numberFld.getText().trim();
    }

    public JButton decorate(JButton jButton) {
        jButton.setRolloverEnabled(true);
        jButton.setBorderPainted(true);
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalAlignment(0);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    public void addIncrementFieldListener(IncrementFieldListener incrementFieldListener) {
        this._listeners.add(incrementFieldListener);
    }

    public void removeIncrementFieldListener(IncrementFieldListener incrementFieldListener) {
        this._listeners.remove(incrementFieldListener);
    }

    public final JTextField getTextComponent() {
        return this._numberFld;
    }
}

