/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;

public class DeleteNode
extends RefactoringChange {
    private Project _project;
    private URL _url;
    private String _text;

    public DeleteNode(Project project, URL uRL) {
        super(null);
        this._project = project;
        this._url = uRL;
        TextNode textNode = (TextNode)NodeFactory.find((URL)uRL);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        this._text = textBuffer.getString(0, textBuffer.getLength());
        this.setNode((Node)textNode);
    }

    public boolean doit() throws Exception {
        boolean bl = DeleteNode.deleteNode(this._project, this._url);
        this.setNode(null);
        return bl;
    }

    public static boolean deleteNode(Project project, URL uRL) throws IOException {
        boolean bl = false;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        try {
            cacheSupport.beginCacheUse();
            Node node = NodeFactory.find((URL)uRL);
            if (node != null) {
                node.delete();
                bl = true;
            } else {
                URLFileSystem.delete((URL)uRL);
                bl = true;
            }
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return bl;
    }

    public boolean undo() throws Exception {
        JavaManager javaManager = JavaManager.getJavaManager(this._project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        try {
            cacheSupport.beginCacheUse();
            TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)this._url);
            this._project.add((Element)textNode);
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            textBuffer.append(this._text.toCharArray());
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)textNode);
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return true;
    }
}

