/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import oracle.ide.model.Node;
import oracle.jdeveloper.refactoring.changes.CreateNode;
import oracle.jdeveloper.refactoring.changes.RenameNode;
import oracle.jdeveloper.refactoring.changes.TextChange;

public abstract class RefactoringChange
implements Comparable {
    protected static final int COMPARE_TYPE_MASK = -1879048193;
    private Node _node;

    public RefactoringChange(Node node) {
        this._node = node;
    }

    public Node getNode() {
        return this._node;
    }

    protected void setNode(Node node) {
        this._node = node;
    }

    public abstract boolean doit() throws Exception;

    public abstract boolean undo() throws Exception;

    public int compareTo(Object object) {
        int n = RefactoringChange.compareChangeTypes(this, object);
        if (n == 0) {
            n = this.hashCode() - object.hashCode() & 0x8FFFFFFF;
        }
        return n;
    }

    public static int compareChangeTypes(RefactoringChange refactoringChange, Object object) {
        Class<?> clazz = refactoringChange.getClass();
        Class<?> clazz2 = object.getClass();
        return RefactoringChange.getChangePriority(clazz) - RefactoringChange.getChangePriority(clazz2) << 28;
    }

    private static int getChangePriority(Class clazz) {
        return clazz == CreateNode.class ? 1 : (clazz == TextChange.class ? 2 : (clazz == RenameNode.class ? 3 : 0));
    }
}

